/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.util;

import com.zoho.api.logger.SDKLogger;
import com.zoho.crm.api.HeaderMap;
import com.zoho.crm.api.Initializer;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.fields.Field;
import com.zoho.crm.api.fields.FieldsOperations;
import com.zoho.crm.api.modules.APIException;
import com.zoho.crm.api.modules.Module;
import com.zoho.crm.api.modules.ModulesOperations;
import com.zoho.crm.api.modules.ResponseHandler;
import com.zoho.crm.api.modules.ResponseWrapper;
import com.zoho.crm.api.relatedlists.RelatedList;
import com.zoho.crm.api.relatedlists.RelatedListsOperations;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.CommonAPIHandler;
import com.zoho.crm.api.util.Constants;
import com.zoho.crm.api.util.Converter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Utility {
    private static HashMap<String, String> apiTypeVsDataType = new HashMap();
    private static HashMap<String, String> apiTypeVsStructureName = new HashMap();
    private static final Logger LOGGER = Logger.getLogger(SDKLogger.class.getName());
    private static final JSONObject JSONDETAILS = Initializer.jsonDetails;
    private static Boolean newFile = false;
    private static Boolean getModifiedModules = false;
    private static Boolean forceRefresh = false;
    public static JSONObject apiSupportedModule = new JSONObject();
    private static String moduleAPIName;

    public static void assertNotNull(Object value, String errorCode, String errorMessage) throws SDKException {
        if (value == null) {
            throw new SDKException(errorCode, errorMessage);
        }
    }

    private static synchronized void fileExistsFlow(String moduleAPIName, String recordFieldDetailsPath, String lastModifiedTime) throws IOException, SDKException {
        JSONObject recordFieldDetailsJson = Initializer.getJSON(recordFieldDetailsPath);
        if (Initializer.getInitializer().getSDKConfig().getAutoRefreshFields() && !newFile.booleanValue() && !getModifiedModules.booleanValue() && (recordFieldDetailsJson.optString("FIELDS-LAST-MODIFIED-TIME").isEmpty() || forceRefresh.booleanValue() || System.currentTimeMillis() - Long.valueOf(recordFieldDetailsJson.getString("FIELDS-LAST-MODIFIED-TIME")) > 3600000L)) {
            getModifiedModules = true;
            lastModifiedTime = forceRefresh == false && recordFieldDetailsJson.has("FIELDS-LAST-MODIFIED-TIME") ? recordFieldDetailsJson.getString("FIELDS-LAST-MODIFIED-TIME") : null;
            Utility.modifyFields(recordFieldDetailsPath, lastModifiedTime);
            getModifiedModules = false;
        } else if (!Initializer.getInitializer().getSDKConfig().getAutoRefreshFields() && forceRefresh.booleanValue() && !getModifiedModules.booleanValue()) {
            getModifiedModules = true;
            Utility.modifyFields(recordFieldDetailsPath, lastModifiedTime);
            getModifiedModules = false;
        }
        recordFieldDetailsJson = Initializer.getJSON(recordFieldDetailsPath);
        if (moduleAPIName == null || recordFieldDetailsJson.has(moduleAPIName.toLowerCase())) {
            return;
        }
        Utility.fillDataType();
        recordFieldDetailsJson.put(moduleAPIName.toLowerCase(), (Object)new JSONObject());
        FileWriter file = new FileWriter(recordFieldDetailsPath);
        file.flush();
        file.write(recordFieldDetailsJson.toString());
        file.flush();
        file.close();
        JSONObject fieldDetails = (JSONObject)Utility.getFieldsDetails(moduleAPIName);
        recordFieldDetailsJson = Initializer.getJSON(recordFieldDetailsPath);
        recordFieldDetailsJson.put(moduleAPIName.toLowerCase(), (Object)fieldDetails);
        file = new FileWriter(recordFieldDetailsPath);
        file.flush();
        file.write(recordFieldDetailsJson.toString());
        file.flush();
        file.close();
    }

    private static String verifyModuleAPIName(String moduleName) throws IOException {
        JSONObject fieldsJSON;
        if (moduleName != null && Constants.DEFAULT_MODULENAME_VS_APINAME.get(moduleName.toLowerCase()) != null) {
            return Constants.DEFAULT_MODULENAME_VS_APINAME.get(moduleName.toLowerCase());
        }
        String recordFieldDetailsPath = Utility.getFileName();
        File recordFieldDetails = new File(recordFieldDetailsPath);
        if (recordFieldDetails.exists() && (fieldsJSON = Initializer.getJSON(recordFieldDetailsPath)).has("SDK-MODULE-METADATA") && fieldsJSON.getJSONObject("SDK-MODULE-METADATA").has(moduleName.toLowerCase())) {
            return fieldsJSON.getJSONObject("SDK-MODULE-METADATA").getJSONObject(moduleName.toLowerCase()).getString("api_name");
        }
        return moduleName;
    }

    private static void setHandlerAPIPath(String moduleAPIName, CommonAPIHandler handlerInstance) {
        if (handlerInstance == null) {
            return;
        }
        String apiPath = handlerInstance.getAPIPath();
        if (apiPath.toLowerCase().contains(moduleAPIName.toLowerCase())) {
            CharSequence[] apiPathSplit = apiPath.split("/");
            for (int i = 0; i < apiPathSplit.length; ++i) {
                if (apiPathSplit[i].equalsIgnoreCase(moduleAPIName)) {
                    apiPathSplit[i] = moduleAPIName;
                    continue;
                }
                if (!Constants.DEFAULT_MODULENAME_VS_APINAME.containsKey(((String)apiPathSplit[i]).toLowerCase()) || Constants.DEFAULT_MODULENAME_VS_APINAME.get(((String)apiPathSplit[i]).toLowerCase()) == null) continue;
                apiPathSplit[i] = Constants.DEFAULT_MODULENAME_VS_APINAME.get(((String)apiPathSplit[i]).toLowerCase());
            }
            apiPath = String.join((CharSequence)"/", apiPathSplit);
            handlerInstance.setAPIPath(apiPath);
        }
    }

    public static synchronized void getFields(String moduleAPIName, CommonAPIHandler handlerInstance) throws SDKException {
        Utility.moduleAPIName = moduleAPIName;
        Utility.getFieldsInfo(moduleAPIName, handlerInstance);
    }

    public static synchronized void getFieldsInfo(String moduleAPIName, CommonAPIHandler handlerInstance) throws SDKException {
        String recordFieldDetailsPath = null;
        String lastModifiedTime = null;
        try {
            if (moduleAPIName != null && Utility.searchJSONDetails(moduleAPIName) != null) {
                return;
            }
            File resourcesPath = new File(Initializer.getInitializer().getResourcePath() + File.separator + "resources");
            if (!resourcesPath.exists()) {
                resourcesPath.mkdirs();
            }
            moduleAPIName = Utility.verifyModuleAPIName(moduleAPIName);
            Utility.setHandlerAPIPath(moduleAPIName, handlerInstance);
            if (handlerInstance != null && handlerInstance.getModuleAPIName() == null && !Constants.SKIP_MODULES.contains(moduleAPIName.toLowerCase())) {
                return;
            }
            recordFieldDetailsPath = Utility.getFileName();
            File recordFieldDetails = new File(recordFieldDetailsPath);
            if (recordFieldDetails.exists()) {
                Utility.fileExistsFlow(moduleAPIName, recordFieldDetailsPath, lastModifiedTime);
            } else if (Initializer.getInitializer().getSDKConfig().getAutoRefreshFields()) {
                newFile = true;
                Utility.fillDataType();
                apiSupportedModule = apiSupportedModule.length() > 0 ? apiSupportedModule : Utility.getModules(null);
                JSONObject recordFieldDetailsJson = recordFieldDetails.exists() ? Initializer.getJSON(recordFieldDetailsPath) : new JSONObject();
                recordFieldDetailsJson.put("FIELDS-LAST-MODIFIED-TIME", (Object)String.valueOf(System.currentTimeMillis()));
                if (apiSupportedModule.length() > 0) {
                    for (String module : apiSupportedModule.keySet()) {
                        if (recordFieldDetailsJson.has(module)) continue;
                        JSONObject moduleData = apiSupportedModule.getJSONObject(module);
                        recordFieldDetailsJson.put(module, (Object)new JSONObject());
                        FileWriter file = new FileWriter(recordFieldDetailsPath);
                        file.write(recordFieldDetailsJson.toString());
                        file.flush();
                        file.close();
                        JSONObject fieldDetails = (JSONObject)Utility.getFieldsDetails(moduleData.getString("api_name"));
                        recordFieldDetailsJson = Initializer.getJSON(recordFieldDetailsPath);
                        recordFieldDetailsJson.put(module, (Object)fieldDetails);
                        file = new FileWriter(recordFieldDetailsPath);
                        file.flush();
                        file.write(recordFieldDetailsJson.toString());
                        file.flush();
                        file.close();
                    }
                }
                newFile = false;
            } else if (forceRefresh.booleanValue() && !getModifiedModules.booleanValue()) {
                getModifiedModules = true;
                JSONObject recordFieldDetailsJson = new JSONObject();
                FileWriter file = new FileWriter(recordFieldDetailsPath);
                file.write(recordFieldDetailsJson.toString());
                file.flush();
                file.close();
                Utility.modifyFields(recordFieldDetailsPath, lastModifiedTime);
                getModifiedModules = false;
            } else {
                Utility.fillDataType();
                JSONObject recordFieldDetailsJson = new JSONObject();
                recordFieldDetailsJson.put(moduleAPIName.toLowerCase(), (Object)new JSONObject());
                FileWriter file = new FileWriter(recordFieldDetailsPath);
                file.write(recordFieldDetailsJson.toString());
                file.flush();
                file.close();
                JSONObject fieldDetails = (JSONObject)Utility.getFieldsDetails(moduleAPIName);
                recordFieldDetailsJson = Initializer.getJSON(recordFieldDetailsPath);
                recordFieldDetailsJson.put(moduleAPIName.toLowerCase(), (Object)fieldDetails);
                file = new FileWriter(recordFieldDetailsPath);
                file.flush();
                file.write(recordFieldDetailsJson.toString());
                file.flush();
                file.close();
            }
        }
        catch (SDKException | IOException | JSONException e) {
            if (recordFieldDetailsPath != null && new File(recordFieldDetailsPath).exists()) {
                try {
                    JSONObject recordFieldDetailsJson = Initializer.getJSON(recordFieldDetailsPath);
                    if (recordFieldDetailsJson.has(moduleAPIName.toLowerCase())) {
                        recordFieldDetailsJson.remove(moduleAPIName.toLowerCase());
                    }
                    if (newFile.booleanValue()) {
                        if (recordFieldDetailsJson.get("FIELDS-LAST-MODIFIED-TIME") != null) {
                            recordFieldDetailsJson.remove("FIELDS-LAST-MODIFIED-TIME");
                        }
                        newFile = false;
                    }
                    if (getModifiedModules.booleanValue() || forceRefresh.booleanValue()) {
                        getModifiedModules = false;
                        forceRefresh = false;
                        if (lastModifiedTime != null) {
                            recordFieldDetailsJson.put("FIELDS-LAST-MODIFIED-TIME", lastModifiedTime);
                        }
                    }
                    FileWriter file = new FileWriter(recordFieldDetailsPath);
                    file.flush();
                    file.write(recordFieldDetailsJson.toString());
                    file.flush();
                    file.close();
                }
                catch (IOException ex) {
                    SDKException exception = new SDKException("Exception", ex);
                    LOGGER.log(Level.SEVERE, "Exception", exception);
                    throw exception;
                }
            }
            SDKException exception = e instanceof SDKException ? (SDKException)e : new SDKException("Exception", (Exception)e);
            LOGGER.log(Level.SEVERE, "Exception", exception);
            throw exception;
        }
    }

    private static void modifyFields(String recordFieldDetailsPath, String modifiedTime) throws IOException, SDKException {
        FileWriter file = null;
        JSONObject modifiedModules = Utility.getModules(modifiedTime);
        JSONObject recordFieldDetailsJson = Initializer.getJSON(recordFieldDetailsPath);
        recordFieldDetailsJson.put("FIELDS-LAST-MODIFIED-TIME", (Object)String.valueOf(System.currentTimeMillis()));
        file = new FileWriter(recordFieldDetailsPath);
        file.flush();
        file.write(recordFieldDetailsJson.toString());
        file.flush();
        file.close();
        if (modifiedModules.length() > 0) {
            for (String module : modifiedModules.keySet()) {
                if (!recordFieldDetailsJson.has(module.toLowerCase())) continue;
                Utility.deleteFields(recordFieldDetailsJson, module.toLowerCase());
            }
            file = new FileWriter(recordFieldDetailsPath);
            file.flush();
            file.write(recordFieldDetailsJson.toString());
            file.flush();
            file.close();
            for (String module : modifiedModules.keySet()) {
                JSONObject moduleData = modifiedModules.getJSONObject(module);
                Utility.getFieldsInfo(moduleData.getString("api_name"), null);
            }
        }
    }

    public static void deleteFields(JSONObject recordFieldDetailsJson, String module) {
        ArrayList subformModules = new ArrayList();
        JSONObject fieldsJSON = recordFieldDetailsJson.getJSONObject(module);
        fieldsJSON.keySet().forEach(key -> {
            if (fieldsJSON.getJSONObject(key).has("subform") && fieldsJSON.getJSONObject(key).getBoolean("subform") && recordFieldDetailsJson.has(fieldsJSON.getJSONObject(key).getString("module"))) {
                subformModules.add(fieldsJSON.getJSONObject(key).getString("module"));
            }
        });
        recordFieldDetailsJson.remove(module);
        if (!subformModules.isEmpty()) {
            for (String subformModule : subformModules) {
                Utility.deleteFields(recordFieldDetailsJson, subformModule);
            }
        }
    }

    private static String getFileName() throws UnsupportedEncodingException {
        Converter converterInstance = new Converter(){

            @Override
            public Object getWrappedResponse(Object response, String pack) throws Exception {
                return null;
            }

            @Override
            public Object getResponse(Object response, String pack) throws Exception {
                return null;
            }

            @Override
            public Object formRequest(Object requestObject, String pack, Integer instanceNumber, JSONObject memberDetail) throws Exception {
                return null;
            }

            @Override
            public void appendToRequest(HttpEntityEnclosingRequestBase requestBase, Object requestObject) throws Exception {
            }
        };
        return Initializer.getInitializer().getResourcePath() + File.separator + "resources" + File.separator + converterInstance.getEncodedFileName();
    }

    public static synchronized void getRelatedLists(String relatedModuleName, String moduleAPIName, CommonAPIHandler commonAPIHandler) throws SDKException {
        try {
            JSONObject recordFieldDetailsJSON;
            JSONArray modulerelatedList;
            FileWriter file;
            String recordFieldDetailsPath;
            File recordFieldDetails;
            boolean isNewData = false;
            String key = (moduleAPIName + "_" + "Related_Lists").toLowerCase();
            File resourcesPath = new File(Initializer.getInitializer().getResourcePath() + File.separator + "resources");
            if (!resourcesPath.exists()) {
                resourcesPath.mkdirs();
            }
            if (!(recordFieldDetails = new File(recordFieldDetailsPath = Utility.getFileName())).exists() || recordFieldDetails.exists() && Initializer.getJSON(recordFieldDetailsPath).optJSONArray(key) == null) {
                isNewData = true;
                moduleAPIName = Utility.verifyModuleAPIName(moduleAPIName);
                JSONArray relatedListValues = Utility.getRelatedListDetails(moduleAPIName);
                JSONObject recordFieldDetailsJSON2 = recordFieldDetails.exists() ? Initializer.getJSON(recordFieldDetailsPath) : new JSONObject();
                recordFieldDetailsJSON2.put(key, (Object)relatedListValues);
                file = new FileWriter(recordFieldDetailsPath);
                file.write(recordFieldDetailsJSON2.toString());
                file.flush();
                file.close();
            }
            if (!Utility.checkRelatedListExists(relatedModuleName, modulerelatedList = (recordFieldDetailsJSON = Initializer.getJSON(recordFieldDetailsPath)).getJSONArray(key), commonAPIHandler) && !isNewData) {
                recordFieldDetailsJSON.remove(key);
                file = new FileWriter(recordFieldDetailsPath);
                file.write(recordFieldDetailsJSON.toString());
                file.flush();
                file.close();
                Utility.getRelatedLists(relatedModuleName, moduleAPIName, commonAPIHandler);
            }
        }
        catch (SDKException e) {
            LOGGER.log(Level.SEVERE, "Exception", e);
            throw e;
        }
        catch (Exception e) {
            SDKException exception = new SDKException("Exception", e);
            LOGGER.log(Level.SEVERE, "Exception", exception);
            throw exception;
        }
    }

    private static boolean checkRelatedListExists(String relatedModuleName, JSONArray modulerelatedListJA, CommonAPIHandler commonAPIHandler) throws JSONException, SDKException {
        for (int index = 0; index < modulerelatedListJA.length(); ++index) {
            JSONObject relatedListJO = modulerelatedListJA.getJSONObject(index);
            if (relatedListJO.getString("api_name") == null || !relatedListJO.getString("api_name").equalsIgnoreCase(relatedModuleName)) continue;
            if (relatedListJO.getString("href").equals("null")) {
                throw new SDKException("API UNSUPPORTED OPERATION", commonAPIHandler.getHttpMethod() + " " + commonAPIHandler.getAPIPath() + " Operation is not supported by API");
            }
            if (!relatedListJO.getString("module").equalsIgnoreCase("null")) {
                commonAPIHandler.setModuleAPIName(relatedListJO.getString("module"));
                Utility.getFieldsInfo(relatedListJO.getString("module"), commonAPIHandler);
            }
            return true;
        }
        return false;
    }

    private static JSONArray getRelatedListDetails(String moduleAPIName) throws SDKException {
        RelatedListsOperations relatedListsOperations = new RelatedListsOperations(moduleAPIName);
        APIResponse<com.zoho.crm.api.relatedlists.ResponseHandler> response = relatedListsOperations.getRelatedLists();
        JSONArray relatedListJA = new JSONArray();
        if (response != null) {
            if (response.getStatusCode() == 204) {
                return relatedListJA;
            }
            if (response.isExpected()) {
                com.zoho.crm.api.relatedlists.ResponseHandler responseHandler = response.getObject();
                if (responseHandler instanceof com.zoho.crm.api.relatedlists.ResponseWrapper) {
                    com.zoho.crm.api.relatedlists.ResponseWrapper responseWrapper = (com.zoho.crm.api.relatedlists.ResponseWrapper)responseHandler;
                    ArrayList relatedLists = (ArrayList)responseWrapper.getRelatedLists();
                    for (RelatedList relatedList : relatedLists) {
                        JSONObject relatedListDetail = new JSONObject();
                        relatedListDetail.put("api_name", (Object)relatedList.getAPIName());
                        relatedListDetail.put("module", (Object)(relatedList.getModule() != null ? relatedList.getModule() : "null"));
                        relatedListDetail.put("name", (Object)relatedList.getName());
                        relatedListDetail.put("href", (Object)(relatedList.getHref() != null ? relatedList.getHref() : "null"));
                        relatedListJA.put((Object)relatedListDetail);
                    }
                } else if (responseHandler instanceof com.zoho.crm.api.relatedlists.APIException) {
                    com.zoho.crm.api.relatedlists.APIException exception = (com.zoho.crm.api.relatedlists.APIException)responseHandler;
                    JSONObject errorResponse = new JSONObject();
                    errorResponse.put("code", (Object)exception.getCode().getValue());
                    errorResponse.put("status", (Object)exception.getStatus().getValue());
                    errorResponse.put("message", (Object)exception.getMessage().getValue());
                    throw new SDKException("API_EXCEPTION", errorResponse);
                }
            } else {
                JSONObject errorResponse = new JSONObject();
                errorResponse.put("code", response.getStatusCode());
                throw new SDKException("API_EXCEPTION", errorResponse);
            }
        }
        return relatedListJA;
    }

    public static Object getFieldsDetails(String moduleAPIName) throws SDKException {
        JSONObject fieldsDetails = new JSONObject();
        FieldsOperations fieldOperation = new FieldsOperations(moduleAPIName);
        APIResponse<com.zoho.crm.api.fields.ResponseHandler> response = fieldOperation.getFields(new ParameterMap());
        if (response != null) {
            if (response.getStatusCode() == 204) {
                return fieldsDetails;
            }
            if (response.isExpected()) {
                com.zoho.crm.api.fields.ResponseHandler responseHandler = response.getObject();
                if (responseHandler instanceof com.zoho.crm.api.fields.ResponseWrapper) {
                    JSONObject fieldDetail;
                    com.zoho.crm.api.fields.ResponseWrapper responseWrapper = (com.zoho.crm.api.fields.ResponseWrapper)responseHandler;
                    ArrayList fields = (ArrayList)responseWrapper.getFields();
                    for (Field field : fields) {
                        String keyName = field.getAPIName();
                        if (Constants.KEYS_TO_SKIP.contains(keyName)) continue;
                        JSONObject fieldDetail2 = new JSONObject();
                        Utility.setDataType(fieldDetail2, field, moduleAPIName);
                        fieldsDetails.put(field.getAPIName(), (Object)fieldDetail2);
                    }
                    if (Constants.INVENTORY_MODULES.contains(moduleAPIName)) {
                        fieldDetail = new JSONObject();
                        fieldDetail.put("name", (Object)"$line_tax");
                        fieldDetail.put("type", (Object)"java.util.List");
                        fieldDetail.put("structure_name", (Object)"com.zoho.crm.api.record.LineTax");
                        fieldDetail.put("lookup", true);
                        fieldsDetails.put("$line_tax", (Object)fieldDetail);
                    }
                    if ("Notes".equalsIgnoreCase(moduleAPIName)) {
                        fieldDetail = new JSONObject();
                        fieldDetail.put("name", (Object)"$attachments");
                        fieldDetail.put("type", (Object)"java.util.List");
                        fieldDetail.put("structure_name", (Object)"com.zoho.crm.api.attachments.Attachment");
                        fieldsDetails.put("$attachments", (Object)fieldDetail);
                    }
                } else if (responseHandler instanceof com.zoho.crm.api.fields.APIException) {
                    com.zoho.crm.api.fields.APIException exception = (com.zoho.crm.api.fields.APIException)responseHandler;
                    JSONObject errorResponse = new JSONObject();
                    errorResponse.put("code", (Object)exception.getCode().getValue());
                    errorResponse.put("status", (Object)exception.getStatus().getValue());
                    errorResponse.put("message", (Object)exception.getMessage().getValue());
                    SDKException exception1 = new SDKException("API_EXCEPTION", errorResponse);
                    if (Utility.moduleAPIName.equalsIgnoreCase(moduleAPIName)) {
                        throw exception1;
                    }
                    LOGGER.log(Level.SEVERE, "API_EXCEPTION", exception1);
                }
            } else {
                JSONObject errorResponse = new JSONObject();
                errorResponse.put("code", response.getStatusCode());
                throw new SDKException("API_EXCEPTION", errorResponse);
            }
        }
        return fieldsDetails;
    }

    public static JSONObject searchJSONDetails(String key) {
        key = "com.zoho.crm.api.record." + key;
        for (String keyInJSON : Initializer.jsonDetails.keySet()) {
            if (!keyInJSON.equalsIgnoreCase(key)) continue;
            JSONObject returnJSON = new JSONObject();
            returnJSON.put("modulePackageName", (Object)keyInJSON);
            returnJSON.put("moduleDetails", (Object)JSONDETAILS.getJSONObject(keyInJSON));
            return returnJSON;
        }
        return null;
    }

    public static synchronized boolean verifyPhotoSupport(String moduleAPIName) throws SDKException {
        try {
            JSONObject moduleMetaData;
            moduleAPIName = Utility.verifyModuleAPIName(moduleAPIName);
            if (Constants.PHOTO_SUPPORTED_MODULES.contains(moduleAPIName.toLowerCase())) {
                return true;
            }
            JSONObject modules = Utility.getModuleNames();
            if (modules.optJSONObject(moduleAPIName.toLowerCase()) != null && (moduleMetaData = modules.getJSONObject(moduleAPIName.toLowerCase())).has("generated_type") && !moduleMetaData.getString("generated_type").equals("custom")) {
                throw new SDKException("UPLOAD PHOTO UNSUPPORTED MODULE", "Photo Upload Operation is not supported by the module: " + moduleAPIName);
            }
        }
        catch (SDKException e) {
            throw e;
        }
        catch (Exception e) {
            SDKException exception = new SDKException("Exception", e);
            throw exception;
        }
        return true;
    }

    private static JSONObject getModuleNames() throws Exception {
        String recordFieldDetailsPath;
        File recordFieldDetails;
        JSONObject moduleData = new JSONObject();
        File resourcesPath = new File(Initializer.getInitializer().getResourcePath() + File.separator + "resources");
        if (!resourcesPath.exists()) {
            resourcesPath.mkdirs();
        }
        if (!(recordFieldDetails = new File(recordFieldDetailsPath = Utility.getFileName())).exists() || recordFieldDetails.exists() && (Initializer.getJSON(recordFieldDetailsPath).optJSONObject("SDK-MODULE-METADATA") == null || Initializer.getJSON(recordFieldDetailsPath).optJSONObject("SDK-MODULE-METADATA").length() == 0)) {
            moduleData = Utility.getModules(null);
            Utility.writeModuleMetaData(recordFieldDetailsPath, moduleData);
            return moduleData;
        }
        JSONObject recordFieldDetailsJson = Initializer.getJSON(recordFieldDetailsPath);
        moduleData = recordFieldDetailsJson.getJSONObject("SDK-MODULE-METADATA");
        return moduleData;
    }

    private static void writeModuleMetaData(String recordFieldDetailsPath, JSONObject moduleData) throws IOException {
        JSONObject moduleDataJSON = new JSONObject();
        moduleData.keySet().forEach(key -> moduleDataJSON.put(key, moduleData.get(key)));
        File recordFieldDetails = new File(recordFieldDetailsPath);
        JSONObject fieldDetailsJSON = recordFieldDetails.exists() ? Initializer.getJSON(recordFieldDetailsPath) : new JSONObject();
        fieldDetailsJSON.put("SDK-MODULE-METADATA", (Object)moduleDataJSON);
        FileWriter file = new FileWriter(recordFieldDetailsPath);
        file.write(fieldDetailsJSON.toString());
        file.flush();
        file.close();
    }

    private static JSONObject getModules(String header) throws SDKException {
        APIResponse<ResponseHandler> response;
        JSONObject apiNames = new JSONObject();
        HeaderMap headerMap = new HeaderMap();
        if (header != null) {
            OffsetDateTime headerValue = OffsetDateTime.ofInstant(Instant.ofEpochMilli(Long.valueOf(header)), ZoneId.systemDefault()).withNano(0);
            headerMap.add(ModulesOperations.GetModulesHeader.IF_MODIFIED_SINCE, headerValue);
        }
        if ((response = new ModulesOperations().getModules(headerMap)) != null) {
            if (Arrays.asList(204, 304).contains(response.getStatusCode())) {
                return apiNames;
            }
            if (response.isExpected()) {
                ResponseHandler responseObject = response.getObject();
                if (responseObject instanceof ResponseWrapper) {
                    List<Module> modules = ((ResponseWrapper)responseObject).getModules();
                    for (Module module : modules) {
                        if (!module.getAPISupported().booleanValue()) continue;
                        JSONObject moduleDetails = new JSONObject();
                        moduleDetails.put("api_name", (Object)module.getAPIName());
                        moduleDetails.put("generated_type", (Object)module.getGeneratedType().getValue());
                        apiNames.put(module.getAPIName().toLowerCase(), (Object)moduleDetails);
                    }
                } else if (responseObject instanceof APIException) {
                    APIException exception = (APIException)responseObject;
                    JSONObject errorResponse = new JSONObject();
                    errorResponse.put("code", (Object)exception.getCode().getValue());
                    errorResponse.put("status", (Object)exception.getStatus().getValue());
                    errorResponse.put("message", (Object)exception.getMessage().getValue());
                    throw new SDKException("API_EXCEPTION", errorResponse);
                }
            }
        }
        if (header == null) {
            try {
                File resourcesPath = new File(Initializer.getInitializer().getResourcePath() + File.separator + "resources");
                if (!resourcesPath.exists()) {
                    resourcesPath.mkdirs();
                }
                Utility.writeModuleMetaData(Utility.getFileName(), apiNames);
            }
            catch (IOException e) {
                throw new SDKException("Exception", e);
            }
        }
        return apiNames;
    }

    public static void refreshModules() throws SDKException {
        forceRefresh = true;
        Utility.getFieldsInfo(null, null);
        forceRefresh = false;
    }

    public static JSONObject getJSONObject(JSONObject json, String key) {
        for (String keyInJSON : json.keySet()) {
            if (!keyInJSON.equalsIgnoreCase(key)) continue;
            return json.getJSONObject(keyInJSON);
        }
        return null;
    }

    private static void setDataType(JSONObject fieldDetail, Field field, String moduleAPIName) throws SDKException {
        String apiType = field.getDataType();
        String keyName = field.getAPIName();
        String module = "";
        if (!(field.getSystemMandatory() == null || !field.getSystemMandatory().booleanValue() || moduleAPIName.equalsIgnoreCase("Calls") && keyName.equalsIgnoreCase("Call_Duration"))) {
            fieldDetail.put("required", true);
        }
        if (keyName.equalsIgnoreCase("Product_Details") && Constants.INVENTORY_MODULES.contains(moduleAPIName.toLowerCase())) {
            fieldDetail.put("name", (Object)keyName);
            fieldDetail.put("type", (Object)"java.util.List");
            fieldDetail.put("structure_name", (Object)"com.zoho.crm.api.record.InventoryLineItems");
            fieldDetail.put("skip_mandatory", true);
            return;
        }
        if (keyName.equalsIgnoreCase("Pricing_Details") && moduleAPIName.equalsIgnoreCase("Price_Books")) {
            fieldDetail.put("name", (Object)keyName);
            fieldDetail.put("type", (Object)"java.util.List");
            fieldDetail.put("structure_name", (Object)"com.zoho.crm.api.record.PricingDetails");
            fieldDetail.put("skip_mandatory", true);
            return;
        }
        if (keyName.equalsIgnoreCase("Participants") && (moduleAPIName.equalsIgnoreCase("Events") || moduleAPIName.equalsIgnoreCase("Activities"))) {
            fieldDetail.put("name", (Object)keyName);
            fieldDetail.put("type", (Object)"java.util.List");
            fieldDetail.put("structure_name", (Object)"com.zoho.crm.api.record.Participants");
            fieldDetail.put("skip_mandatory", true);
            return;
        }
        if (keyName.equalsIgnoreCase("Comments") && (moduleAPIName.equalsIgnoreCase("Solutions") || moduleAPIName.equalsIgnoreCase("Cases"))) {
            fieldDetail.put("name", (Object)keyName);
            fieldDetail.put("type", (Object)"java.util.List");
            fieldDetail.put("structure_name", (Object)"com.zoho.crm.api.record.Comment");
            fieldDetail.put("lookup", true);
            return;
        }
        if (keyName.equalsIgnoreCase("Layout")) {
            fieldDetail.put("name", (Object)keyName);
            fieldDetail.put("type", (Object)"com.zoho.crm.api.layouts.Layout");
            fieldDetail.put("structure_name", (Object)"com.zoho.crm.api.layouts.Layout");
            fieldDetail.put("lookup", true);
            return;
        }
        if (apiTypeVsDataType.containsKey(apiType)) {
            fieldDetail.put("type", (Object)apiTypeVsDataType.get(apiType));
        } else if (apiType.equalsIgnoreCase("formula")) {
            String returnType;
            if (field.getFormula() != null && apiTypeVsDataType.get(returnType = field.getFormula().getReturnType()) != null) {
                fieldDetail.put("type", (Object)apiTypeVsDataType.get(returnType));
            }
            fieldDetail.put("read-only", true);
        } else {
            return;
        }
        if (apiType.toLowerCase().contains("lookup")) {
            fieldDetail.put("lookup", true);
        }
        if (apiType.toLowerCase().equalsIgnoreCase("consent_lookup")) {
            fieldDetail.put("skip_mandatory", true);
        }
        if (apiTypeVsStructureName.containsKey(apiType)) {
            fieldDetail.put("structure_name", (Object)apiTypeVsStructureName.get(apiType));
        }
        if (field.getDataType().equalsIgnoreCase("picklist") && field.getPickListValues() != null && field.getPickListValues().size() > 0) {
            fieldDetail.put("picklist", true);
            JSONArray values = new JSONArray();
            field.getPickListValues().forEach(plv -> values.put((Object)plv.getDisplayValue()));
            fieldDetail.put("values", (Object)values);
        }
        if (apiType.equalsIgnoreCase("subform")) {
            module = field.getSubform().getModule();
            fieldDetail.put("module", (Object)module);
            fieldDetail.put("skip_mandatory", true);
            fieldDetail.put("subform", true);
        }
        if (apiType.equalsIgnoreCase("lookup")) {
            module = field.getLookup().getModule();
            if (module != null && !module.equalsIgnoreCase("se_module")) {
                fieldDetail.put("module", (Object)module);
                if (module.equalsIgnoreCase("Accounts") && !field.getCustomField().booleanValue()) {
                    fieldDetail.put("skip_mandatory", true);
                }
            } else {
                module = "";
            }
            fieldDetail.put("lookup", true);
        }
        if (module.length() > 0) {
            Utility.getFieldsInfo(module, null);
        }
        fieldDetail.put("name", (Object)keyName);
    }

    private static void fillDataType() {
        if (!apiTypeVsDataType.isEmpty()) {
            return;
        }
        String[] fieldAPINamesString = new String[]{"textarea", "text", "website", "email", "phone", "mediumtext", "multiselectlookup", "profileimage", "autonumber"};
        String[] fieldAPINamesInteger = new String[]{"integer"};
        String[] fieldAPINamesBoolean = new String[]{"boolean"};
        String[] fieldAPINamesLong = new String[]{"long", "bigint"};
        String[] fieldAPINamesDouble = new String[]{"double", "percent", "lookup", "currency"};
        String[] fieldAPINamesFile = new String[]{"imageupload"};
        String[] fieldAPINamesFieldFile = new String[]{"fileupload"};
        String[] fieldAPINamesDateTime = new String[]{"datetime", "event_reminder"};
        String[] fieldAPINamesDate = new String[]{"date"};
        String[] fieldAPINamesLookup = new String[]{"lookup"};
        String[] fieldAPINamesPickList = new String[]{"picklist"};
        String[] fieldAPINamesMultiSelectPickList = new String[]{"multiselectpicklist"};
        String[] fieldAPINamesSubForm = new String[]{"subform"};
        String[] fieldAPINamesOwnerLookUp = new String[]{"ownerlookup", "userlookup"};
        String[] fieldAPINamesMultiUserLookUp = new String[]{"multiuserlookup"};
        String[] fieldAPINamesMultiModuleLookUp = new String[]{"multimodulelookup"};
        String[] fieldAPINameTaskRemindAt = new String[]{"ALARM"};
        String[] fieldAPINameRecurringActivity = new String[]{"RRULE"};
        String[] fieldAPINameReminder = new String[]{"multireminder"};
        String[] fieldAPINameConsentLookUp = new String[]{"consent_lookup"};
        for (String fieldAPIName : fieldAPINamesString) {
            apiTypeVsDataType.put(fieldAPIName, "java.lang.String");
        }
        for (String fieldAPIName : fieldAPINamesInteger) {
            apiTypeVsDataType.put(fieldAPIName, "java.lang.Integer");
        }
        for (String fieldAPIName : fieldAPINamesBoolean) {
            apiTypeVsDataType.put(fieldAPIName, "java.lang.Boolean");
        }
        for (String fieldAPIName : fieldAPINamesLong) {
            apiTypeVsDataType.put(fieldAPIName, "java.lang.Long");
        }
        for (String fieldAPIName : fieldAPINamesDouble) {
            apiTypeVsDataType.put(fieldAPIName, "java.lang.Double");
        }
        for (String fieldAPIName : fieldAPINamesFile) {
            apiTypeVsDataType.put(fieldAPIName, "com.zoho.crm.api.util.StreamWrapper");
        }
        for (String fieldAPIName : fieldAPINamesDateTime) {
            apiTypeVsDataType.put(fieldAPIName, "java.time.OffsetDateTime");
        }
        for (String fieldAPIName : fieldAPINamesDate) {
            apiTypeVsDataType.put(fieldAPIName, "java.time.LocalDate");
        }
        for (String fieldAPIName : fieldAPINamesLookup) {
            apiTypeVsDataType.put(fieldAPIName, "com.zoho.crm.api.record.Record");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.Record");
        }
        for (String fieldAPIName : fieldAPINamesPickList) {
            apiTypeVsDataType.put(fieldAPIName, "com.zoho.crm.api.util.Choice");
        }
        for (String fieldAPIName : fieldAPINamesMultiSelectPickList) {
            apiTypeVsDataType.put(fieldAPIName, "java.util.List");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.util.Choice");
        }
        for (String fieldAPIName : fieldAPINamesSubForm) {
            apiTypeVsDataType.put(fieldAPIName, "java.util.List");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.Record");
        }
        for (String fieldAPIName : fieldAPINamesOwnerLookUp) {
            apiTypeVsDataType.put(fieldAPIName, "com.zoho.crm.api.users.User");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.users.User");
        }
        for (String fieldAPIName : fieldAPINamesMultiUserLookUp) {
            apiTypeVsDataType.put(fieldAPIName, "java.util.List");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.users.User");
        }
        for (String fieldAPIName : fieldAPINamesMultiModuleLookUp) {
            apiTypeVsDataType.put(fieldAPIName, "java.util.List");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.modules.Module");
        }
        for (String fieldAPIName : fieldAPINamesFieldFile) {
            apiTypeVsDataType.put(fieldAPIName, "java.util.List");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.FileDetails");
        }
        for (String fieldAPIName : fieldAPINameTaskRemindAt) {
            apiTypeVsDataType.put(fieldAPIName, "com.zoho.crm.api.record.RemindAt");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.RemindAt");
        }
        for (String fieldAPIName : fieldAPINameRecurringActivity) {
            apiTypeVsDataType.put(fieldAPIName, "com.zoho.crm.api.record.RecurringActivity");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.RecurringActivity");
        }
        for (String fieldAPIName : fieldAPINameReminder) {
            apiTypeVsDataType.put(fieldAPIName, "java.util.List");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.Reminder");
        }
        for (String fieldAPIName : fieldAPINameConsentLookUp) {
            apiTypeVsDataType.put(fieldAPIName, "com.zoho.crm.api.record.Consent");
            apiTypeVsStructureName.put(fieldAPIName, "com.zoho.crm.api.record.Consent");
        }
    }
}

