const mysql = require("mysql"); //NO I18N
const util = require("util");   //NO I18N

const config = require("../../config/appKeys"); //NO I18N
const CommonUtil = require("../utils/commonUtil");  //NO I18N

let sqlConfig = {
    user: config.CLOUDSQL_DB_USER,
    password: config.CLOUDSQL_DB_PASSWORD,
    database: config.CLOUDSQL_DB_NAME
}

if (CommonUtil.isEmptyString(config.CLOUDSQL_DB_SOCKETPATH)) {
    sqlConfig.host = config.CLOUDSQL_DB_HOST;
} else {
    sqlConfig.socketPath = config.CLOUDSQL_DB_SOCKETPATH;
}

const sql = mysql.createPool(sqlConfig);
const query = util.promisify(sql.query).bind(sql);

const DatabaseUtil = {
    users: (function () {
        const _doesUserExists = async (zuid) => {
            const queryString = `SELECT ZUID FROM Users WHERE ZUID = "${zuid}"`;    //NO I18N
            const result = await query(queryString);
            if (result.length === 0) {
                return false;
            } else {
                return true;
            }
        };

        const _addUser = async (zuid) => {
            const queryString = `INSERT INTO Users (ZUID, CREATED_ON) VALUES ("${zuid}", ${Date.now()})`;   //NO I18N
            await query(queryString);
            await DatabaseUtil.projects.createProject(zuid, "General"); //NO I18N
        };

        const _addToken = async (zuid, token) => {
            const { iv, cipher } = CommonUtil.encryptToken(token);
            const queryString = `UPDATE Users SET TOKEN_IV = "${iv}", TOKEN_CIPHER = "${cipher}" WHERE ZUID = "${zuid}"`;   //NO I18N
            await query(queryString);
        };

        const _getToken = async (zuid) => {
            const queryString = `SELECT TOKEN_IV, TOKEN_CIPHER FROM Users WHERE ZUID = "${zuid}"`;  //NO I18N
            const result = await query(queryString);
            return CommonUtil.decryptToken(
                result[0].TOKEN_IV,
                result[0].TOKEN_CIPHER
            );
        };

        const _isTokenAdded = async (zuid) => {
            const queryString = `SELECT TOKEN_CIPHER FROM Users WHERE ZUID = "${zuid}"`;    //NO I18N
            const result = await query(queryString);
            if (result[0].TOKEN_CIPHER === null) {
                return false;
            }
            return true;
        };

        return {
            doesUserExists: _doesUserExists,
            addUser: _addUser,
            addToken: _addToken,
            getToken: _getToken,
            isTokenAdded: _isTokenAdded
        };
    })(),

    projects: (function () {
        const _createProject = async (creator, title) => {
            const projectId = DatabaseUtil.generateUID();
            const queryString = `INSERT INTO Projects (PROJECT_ID, TITLE, CREATOR, CREATED_ON) VALUES (${projectId}, "${title}", "${creator}", ${Date.now()})`; //NO I18N
            await query(queryString);
            return projectId;
        };

        const _getProject = async (projectId) => {
            const queryString = `SELECT PROJECT_ID, TITLE, CREATED_ON FROM Projects WHERE PROJECT_ID = "${projectId}"`; //NO I18N
            const result = await query(queryString);
            return result[0];
        };

        const _getAllProjects = async (creator) => {
            const queryString = `SELECT PROJECT_ID, TITLE, CREATED_ON FROM Projects WHERE CREATOR = "${creator}"`;  //NO I18N
            return await query(queryString);
        };

        const _deleteProject = async (projectId) => {
            await DatabaseUtil.tasks.deleteAllTask(projectId);
            const queryString = `DELETE FROM Projects WHERE PROJECT_ID = ${projectId}`;
            await query(queryString);
        }

        return {
            createProject: _createProject,
            getAllProjects: _getAllProjects,
            getProject: _getProject,
            deleteProject : _deleteProject
        };
    })(),

    tasks: (function () {
        const _addTask = async (data) => {
            const taskId = DatabaseUtil.generateUID();
            const queryString = `INSERT INTO Tasks (TASK_ID, CREATOR, CREATED_ON, NAME, PROJECT_ID, STATUS, START_TIME) VALUES (${taskId}, "${data.creator}", ${Date.now()}, "${data.name}", ${data.projectId}, "${data.status}", ${data.startTime})`;  //NO I18N
            await query(queryString);
            return taskId;
        };

        const _getTask = async (taskId) => {
            const queryString = `SELECT * FROM Tasks WHERE TASK_ID = ${taskId}`;
            let result = await query(queryString);
            if (result.length !== 0) {
                result = result[0];
                const projectDetails = await DatabaseUtil.projects.getProject(
                    result.PROJECT_ID
                );
                result.PROJECT_TITLE = projectDetails.TITLE;
            }
            return result;
        };

        const _getCurrentTask = async (zuid) => {
            const queryString = `SELECT * FROM Tasks WHERE CREATOR = "${zuid}" AND STATUS = "started"`; //NO I18N
            let result = await query(queryString);
            if (result.length === 0) {
                return null;
            }
            result = result[0];
            const projectDetails = await DatabaseUtil.projects.getProject(
                result.PROJECT_ID
            );
            result.PROJECT_TITLE = projectDetails.TITLE;
            return result;
        };

        const _getAllTasks = async (projectId) => {
            const queryString = `SELECT * FROM Tasks WHERE PROJECT_ID = ${projectId}`;
            return await query(queryString);
        };

        const _updateTask = async (taskId, data) => {
            let updateValues = [];
            if (typeof data.flagTime !== "undefined") {
                updateValues.push(`FLAG_TIME = ${data.flagTime}`);
            }

            if (typeof data.endTime !== "undefined") {
                updateValues.push(`END_TIME = ${data.endTime}`);
            }

            if (typeof data.timeSpent !== "undefined") {
                updateValues.push(`TIME_SPENT = ${data.timeSpent}`);
            }

            updateValues.push(`STATUS = "${data.status}"`);

            const queryString = `UPDATE Tasks SET ${updateValues.join()} WHERE TASK_ID = ${taskId}`;
            await query(queryString);
        };

        const _deleteTask = async (taskId) => {
            const queryString = `DELETE FROM Tasks WHERE TASK_ID = ${taskId}`;
            await query(queryString);
        };

        const _deleteAllTask = async (projectId) => {
            const queryString = `DELETE FROM Tasks WHERE PROJECT_ID = ${projectId}`;
            return await query(queryString);
        };

        return {
            addTask: _addTask,
            getTask: _getTask,
            getCurrentTask: _getCurrentTask,
            getAllTasks: _getAllTasks,
            updateTask: _updateTask,
            deleteTask: _deleteTask,
            deleteAllTask: _deleteAllTask
        };
    })(),

    generateUID: () => {
        return Math.floor(1000000000000 + Math.random() * 9000000000000);
    }
};

module.exports = DatabaseUtil;