const CommonUtil = require("../utils/commonUtil");	//NO I18N
const DatabaseUtil = require("../utils/databaseUtil");	//NO I18N

const Bots = (function () {
    let reqData;
    const _handler = async (data) => {
        _inititalize(data);
        let response = {};
        const handler = reqData.handler.type;
        switch (handler) {
            case "welcome_handler":	//NO I18N
                response = _welcomeHandler();
                break;
            case "message_handler":	//NO I18N
                response = _messageHandler();
                break;
            case "action_handler":	//NO I18N
                response = await _actionHandler();
        }
        return response;
    };

    const _inititalize = async (data) => {
        reqData = data;
    };

    const _welcomeHandler = () => {
        return {
            text: "Hey! Thanks for subscribing :happy: \nUse the below actions to record time spent on tasks and projects."	//NO I18N
        };
    };

    const _messageHandler = () => {
        return {
            text: "Hey! Use the below actions to record time spent on tasks and projects."	//NO I18N
        };
    };

    const _actionHandler = async () => {
        const zuid = reqData.params.access.user_id;
        if (!(await DatabaseUtil.users.doesUserExists(zuid))) {
            await DatabaseUtil.users.addUser(zuid);
        }

        const isTokenAdded = await DatabaseUtil.users.isTokenAdded(zuid);
        if (!isTokenAdded) {
            return CommonUtil.getAuthButtonResponse();
        }

        const actionName = reqData.handler.name;
        switch (actionName) {
            case "Add Task":	//NO I18N
                return await _addTask(zuid);
            case "Current Task":	//NO I18N
                return await _currentTask(zuid);
            case "Projects":	//NO I18N
                return await _listProjects(zuid);
        }
    };

    const _addTask = async (zuid) => {
        const currentTask = await DatabaseUtil.tasks.getCurrentTask(zuid);
        if (currentTask !== null) {
            return CommonUtil.getBannerResponse(
                "Complete or pause your current task before starting a new task.",	//NO I18N
                true
            );
        }

        const projectsList = await DatabaseUtil.projects.getAllProjects(zuid);
        let projectOptions = [];
        let generalProjectId;
        projectsList.forEach((project) => {
            if (project.TITLE === "General") {
                generalProjectId = project.PROJECT_ID;
            }
            projectOptions.push({ label: project.TITLE, value: project.PROJECT_ID });
        });

        return {
            name: "addtask",	//NO I18N
            type: "form",	//NO I18N
            title: "Add Task",	//NO I18N
            button_label: "Add",	//NO I18N
            inputs: [
                {
                    type: "text",	//NO I18N
                    name: "name",	//NO I18N
                    label: "Name",	//NO I18N
                    hint: "Enter the task name.", //NO I18N
                    placeholder: "Work on state management",	//NO I18N
                    min_length: "3",
                    max_length: "100",
                    mandatory: true
                },
                {
                    type: "select",	//NO I18N
                    name: "project",	//NO I18N
                    label: "Project",	//NO I18N
                    hint: "Choose a project to add the task.",	//NO I18N
                    placeholder: "Select a project",	//NO I18N
                    value: generalProjectId,
                    options: projectOptions,
                    mandatory: true
                }
            ],
            action: { type: "invoke.function", name: "timetrackerform" }	//NO I18N
        };
    };

    const _currentTask = async (zuid) => {
        let response = {};
        const taskDetails = await DatabaseUtil.tasks.getCurrentTask(zuid);
        if (taskDetails === null) {
            response = CommonUtil.getBannerResponse(
                "Right now, you aren't working on any task.",	//NO I18N
                true
            );
        } else {
            let responseText = `*Task name: * ${taskDetails.NAME}\n`;
            responseText += `*Project:* ${taskDetails.PROJECT_TITLE}\n\n`;
            responseText += `*Timer started at:* ${CommonUtil.getLocaleStringFromMS(
                taskDetails.START_TIME
            )}\n`;

            const now = Date.now();
            let timeSpent;
            if (taskDetails.TIME_SPENT === null) {
                timeSpent = now - taskDetails.START_TIME;
            } else {
                timeSpent =
                    parseInt(taskDetails.TIME_SPENT) +
                    parseInt(now - taskDetails.FLAG_TIME);
            }
            responseText += `*Time spent*: ${CommonUtil.getDurationFromMS(timeSpent)}`;

            response = {
                text: responseText,
                card: {
                    title: ":task: You're currently working on...",	//NO I18N
                    theme: "modern-inline"	//NO I18N
                },
                buttons: [
                    {
                        label: "Pause",	//NO I18N
                        action: {
                            type: "invoke.function",	//NO I18N
                            data: { name: "timetrackerbtn" }	//NO I18N
                        },
                        key: taskDetails.TASK_ID
                    },
                    {
                        label: "Stop",	//NO I18N
                        type: "-",
                        action: {
                            type: "invoke.function",	//NO I18N
                            data: { name: "timetrackerbtn" }	//NO I18N
                        },
                        key: taskDetails.TASK_ID
                    }
                ]
            };
        }
        return response;
    };

    const _listProjects = async (zuid) => {
        const allProjects = await DatabaseUtil.projects.getAllProjects(zuid);
        let projectTableRows = [];
        allProjects.forEach((project) => {
            projectData = {
                Title: project.TITLE,
                "Created on": CommonUtil.getLocaleStringFromMS(	//NO I18N
                    project.CREATED_ON,
                    "date"	//NO I18N
                ),
                Tasks: `[View](invoke.function|timetrackerbtn|test@test.tst|${project.PROJECT_ID})`
            };

            if (project.TITLE !== "General") {
                projectData.Delete = `[-Delete](invoke.function|timetrackerbtn|test@test.tst|${project.PROJECT_ID}|p)`;
            }
            projectTableRows.push(projectData);
        });

        return {
            text: "*Here is the List of Projects*\nNote: Deleting the project will delete all its tasks.",	//NO I18N
            card: { theme: "modern-inline" },	//NO I18N
            slides: [
                {
                    type: "table",	//NO I18N
                    data: {
                        headers: ["Title", "Created on", "Tasks", "Delete"],	//NO I18N
                        rows: projectTableRows
                    },
                    buttons: [
                        {
                            label: "Create Project",	//NO I18N
                            action: {
                                type: "invoke.function",	//NO I18N
                                data: { name: "timetrackerbtn" }	//NO I18N
                            }
                        }
                    ]
                }
            ]
        };
    };

    return {
        handler: _handler
    };
    
})();

module.exports = Bots;