const mongoose = require("mongoose");	//NO I18N

const UsersModel = mongoose.Schema({
	zuid: {
		type: String,
		required: true,
		index: true,
		unique: true
	},
	createdOn: {
		type: Date,
        default: new Date()
	},
	token: {
		type: {
			iv: {
				type: String,
				required: true
			},
			cipher: {
				type: String,
				required: true
			}
		},
		required: false
	},
	notifications: {
		type: {
			frequency: String,
			schedulerId: {
				type: String,
				default: null
			}
		}
	},
	currency: String
});

module.exports = mongoose.model("Users", UsersModel);	//NO I18N
