#!/bin/sh

loggedInUser=$( ioreg -n Root -d1 -a | xpath '/plist/dict/key[.="IOConsoleUsers"]/following-sibling::array/dict/key[.="kCGSSessionOnConsoleKey"]/following-sibling::*[1][name()="true"]/../key[.="kCGSSessionUserNameKey"]/following-sibling::string[1]/text()' 2>/dev/null )

if [ -z "$loggedInUser" ]
then
      loggedInUser=$( /usr/bin/python -c 'from SystemConfiguration import SCDynamicStoreCopyConsoleUser; import sys; username = (SCDynamicStoreCopyConsoleUser(None, None, None) or [None])[0]; username = [username,""][username in [u"loginwindow", None, u""]]; sys.stdout.write(username + "\n");' )
fi

if [ -z "$loggedInUser" ]
then
      loggedInUser=$(echo "show State:/Users/ConsoleUser" | scutil | awk '/Name :/ && ! /loginwindow/ { print $3 }')
fi

echo "The user Name is $loggedInUser \n"

dirCheck="/Users/$loggedInUser/Library/Application Support/ZohoMeetingNative"
dir="/Users/$loggedInUser/Library/Application Support/ZohoMeetingNative"

echo "Directory Nme : $dir"

if [ -d "$dirCheck" ];
then
  echo "Directory Already Present\n"
  else
    echo "Making Directory ...\n"
  mkdir "$dir"
fi

cd "$dir"

#Download
echo "Downloading ...\n"
curl "https://assist.zoho.com/agent/ZohoMac.dmg" --output ZohoMac.dmg

dmgPath=$dir/ZohoMac.dmg

echo "Dmg Path :$dmgPath"

#Mount DMG
/usr/bin/hdiutil mount "$dmgPath"

#Copy File
cp -R /Volumes/Zoho/Zoho.app "$dir"
sleep 5

# Unmount
/usr/bin/hdiutil unmount -force /Volumes/Zoho

#Delete DMG
rm -r "$dmgPath"

#Execute for Accessibility
cd "$dir"

sleep 2
open Zoho.app --args -appMode CHECK_ACCESS
sleep 2
open Zoho.app --args -appMode CHECK_RECORD_ACCESS
