#!/bin/sh

###############################################################################

# Replace the <Deployment Link> with the URL

downloadLink=''

###############################################################################

digestSearchstring="encapiKey="
domainSearchstring="/org"

digest=${downloadLink#*$digestSearchstring}
domain=${downloadLink%$domainSearchstring*}
downloadURL="${domain}/api/v2/install_urs?type=2&encapiKey=${digest}&app=mac"
mountUrl="/Volumes/Remote\ Access\ Installer"

loggedInUser=$( ioreg -n Root -d1 -a | xpath '/plist/dict/key[.="IOConsoleUsers"]/following-sibling::array/dict/key[.="kCGSSessionOnConsoleKey"]/following-sibling::*[1][name()="true"]/../key[.="kCGSSessionUserNameKey"]/following-sibling::string[1]/text()' 2>/dev/null )

if [ -z "$loggedInUser" ]
then
      loggedInUser=$(/usr/sbin/scutil <<< "show State:/Users/ConsoleUser" | awk '/Name :/ && ! /loginwindow/ {print $3}')
fi
if [ -z "$loggedInUser" ]
then
      loggedInUser=$(echo "show State:/Users/ConsoleUser" | scutil | awk '/Name :/ && ! /loginwindow/ { print $3 }')
fi

echo "The user Name is $loggedInUser \n"

echo $digest
echo $domain
echo $downloadURL

#Directory
rm -r /Library/ZohoAssist
mkdir /Library/ZohoAssist
cd /Library/ZohoAssist

if mount | grep "on $mountUrl" > /dev/null; then
    /usr/bin/hdiutil unmount /Volumes/Remote\ Access\ Installer/
else
    echo "not mounted"
fi

#Download
curl "$downloadURL" --output ZohoAssistInstaller.dmg

#Mount DMG
sleep 2
/usr/bin/hdiutil attach -nobrowse /Library/ZohoAssist/ZohoAssistInstaller.dmg

#Installer
sleep 3
cd  /Volumes/Remote\ Access\ Installer/InstallerSetup.app/Contents/MacOS/
./InstallerSetup

# Launch Agents
sleep 2
sudo -u $loggedInUser launchctl load /Library/LaunchAgents/com.zoho.assist.PerUserAgent.plist
sleep 2
sudo -u $loggedInUser launchctl load /Library/LaunchAgents/com.zoho.assist.ZAPreLogin.plist

# Unmount
sleep 5
/usr/bin/hdiutil unmount -force /Volumes/Remote\ Access\ Installer/
rm -r /Library/ZohoAssist

#Execute for Accessibility
cd /Library/Application\ Support/ZohoAssist/

sleep 2
open Zoho.app --args -appMode CHECK_ACCESS
sleep 2
open Zoho.app --args -appMode CHECK_RECORD_ACCESS
