/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api;

public class SDKConfig {
    private boolean autoRefreshFields;
    private boolean pickListValidation;
    private int connectionTimeout;
    private int requestTimeout;
    private int socketTimeout;

    SDKConfig(boolean autoRefreshFields, boolean pickListValidation, int connectionTimeout, int requestTimeout, int socketTimeout) {
        this.autoRefreshFields = autoRefreshFields;
        this.pickListValidation = pickListValidation;
        this.connectionTimeout = connectionTimeout;
        this.requestTimeout = requestTimeout;
        this.socketTimeout = socketTimeout;
    }

    public boolean getAutoRefreshFields() {
        return this.autoRefreshFields;
    }

    public boolean getPickListValidation() {
        return this.pickListValidation;
    }

    public int connectionTimeout() {
        return this.connectionTimeout;
    }

    public int requestTimeout() {
        return this.requestTimeout;
    }

    public int socketTimeout() {
        return this.socketTimeout;
    }

    public static class Builder {
        private boolean autoRefreshFields = false;
        private boolean pickListValidation = true;
        private int connectionTimeout = 0;
        private int requestTimeout = 0;
        private int socketTimeout = 0;

        public Builder setAutoRefreshFields(boolean autoRefreshFields) {
            this.autoRefreshFields = autoRefreshFields;
            return this;
        }

        public Builder setPickListValidation(boolean pickListValidation) {
            this.pickListValidation = pickListValidation;
            return this;
        }

        public Builder connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout > 0 ? connectionTimeout : 0;
            return this;
        }

        public Builder requestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout > 0 ? requestTimeout : 0;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout > 0 ? socketTimeout : 0;
            return this;
        }

        public SDKConfig build() {
            return new SDKConfig(this.autoRefreshFields, this.pickListValidation, this.connectionTimeout, this.requestTimeout, this.socketTimeout);
        }
    }
}

