/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.api.authenticator.store;

import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import com.zoho.api.authenticator.OAuthToken;
import com.zoho.api.authenticator.Token;
import com.zoho.api.authenticator.store.TokenStore;
import com.zoho.crm.api.UserSignature;
import com.zoho.crm.api.exception.SDKException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class FileStore
implements TokenStore {
    private String filePath;
    private String[] headers = new String[]{"user_mail", "client_id", "refresh_token", "access_token", "grant_token", "expiry_time"};

    public FileStore(String filePath) throws Exception {
        this.filePath = filePath;
        CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(new File(this.filePath), true));
        FileReader fileReader = new FileReader(this.filePath);
        if (fileReader.read() == -1) {
            csvWriter.writeNext(this.headers);
        }
        fileReader.close();
        csvWriter.flush();
        csvWriter.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Token getToken(UserSignature user, Token token) throws SDKException {
        try (CSVReader csvReader = new CSVReader((Reader)new FileReader(this.filePath));){
            if (!(token instanceof OAuthToken)) return null;
            OAuthToken oauthToken = (OAuthToken)token;
            List allContents = csvReader.readAll();
            int index = 1;
            while (index < allContents.size()) {
                String[] nextRecord = (String[])allContents.get(index);
                if (this.checkTokenExists(user.getEmail(), oauthToken, nextRecord).booleanValue()) {
                    oauthToken.setAccessToken(nextRecord[3]);
                    oauthToken.setExpiresIn(nextRecord[5]);
                    oauthToken.setRefreshToken(nextRecord[2]);
                    OAuthToken oAuthToken = oauthToken;
                    return oAuthToken;
                }
                ++index;
            }
            return null;
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in getToken - FileStore : ", ex);
        }
    }

    @Override
    public void saveToken(UserSignature user, Token token) throws SDKException {
        try {
            String[] data = new String[6];
            if (token instanceof OAuthToken) {
                OAuthToken oauthToken = (OAuthToken)token;
                oauthToken.setUserMail(user.getEmail());
                this.deleteToken(oauthToken);
                data[0] = user.getEmail();
                data[1] = oauthToken.getClientID();
                data[2] = oauthToken.getRefreshToken();
                data[3] = oauthToken.getAccessToken();
                data[4] = oauthToken.getGrantToken();
                data[5] = oauthToken.getExpiresIn();
            }
            try (CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(new File(this.filePath), true));){
                csvWriter.writeNext(data);
                csvWriter.flush();
            }
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in saveToken - FileStore : ", ex);
        }
    }

    @Override
    public void deleteToken(Token token) throws SDKException {
        try (CSVReader csvReader = new CSVReader((Reader)new FileReader(new File(this.filePath)));){
            if (token instanceof OAuthToken) {
                OAuthToken oauthToken = (OAuthToken)token;
                List allContents = csvReader.readAll();
                for (int index = 1; index < allContents.size(); ++index) {
                    String[] nextRecord = (String[])allContents.get(index);
                    if (!this.checkTokenExists(oauthToken.getUserMail(), oauthToken, nextRecord).booleanValue()) continue;
                    allContents.remove(index);
                    break;
                }
                CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(new File(this.filePath)));
                csvWriter.writeAll(allContents);
                csvWriter.close();
            }
        }
        catch (SDKException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in deleteToken - FileStore : ", ex);
        }
    }

    @Override
    public List<Token> getTokens() throws SDKException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        try (CSVReader csvReader = new CSVReader((Reader)new FileReader(this.filePath));){
            List allContents = csvReader.readAll();
            for (int index = 1; index < allContents.size(); ++index) {
                String[] nextRecord = (String[])allContents.get(index);
                OAuthToken.TokenType tokenType = nextRecord[4] != null && !nextRecord[4].isEmpty() ? OAuthToken.TokenType.GRANT : OAuthToken.TokenType.REFRESH;
                String tokenValue = tokenType.equals((Object)OAuthToken.TokenType.REFRESH) ? nextRecord[2] : nextRecord[4];
                OAuthToken token = new OAuthToken(nextRecord[1], null, tokenValue, tokenType);
                token.setUserMail(nextRecord[0]);
                token.setRefreshToken(nextRecord[2]);
                token.setAccessToken(nextRecord[3]);
                token.setExpiresIn(String.valueOf(nextRecord[5]));
                tokens.add(token);
            }
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in getTokens - FileStore : ", ex);
        }
        return tokens;
    }

    @Override
    public void deleteTokens() throws SDKException {
        try (CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(new File(this.filePath), false));){
            csvWriter.writeNext(this.headers);
            csvWriter.flush();
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in deleteTokens - FileStore : ", ex);
        }
    }

    private Boolean checkTokenExists(String email, OAuthToken oauthToken, String[] row) throws SDKException {
        boolean tokenCheck;
        if (email == null) {
            throw new SDKException("USER MAIL NULL ERROR", "User Mail MUST NOT be null. Use setUserMail() to set value.");
        }
        String clientId = oauthToken.getClientID();
        String grantToken = oauthToken.getGrantToken();
        String refreshToken = oauthToken.getRefreshToken();
        boolean bl = tokenCheck = grantToken != null ? grantToken.equals(row[4]) : refreshToken.equals(row[2]);
        if (row[0].equals(email) && row[1].equals(clientId) && tokenCheck) {
            return true;
        }
        return false;
    }
}

