/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.crud;

import com.zoho.crm.library.api.handler.EntityAPIHandler;
import com.zoho.crm.library.api.handler.RelatedListAPIHandler;
import com.zoho.crm.library.api.response.APIResponse;
import com.zoho.crm.library.api.response.BulkAPIResponse;
import com.zoho.crm.library.api.response.FileAPIResponse;
import com.zoho.crm.library.common.CommonUtil;
import com.zoho.crm.library.common.ZCRMEntity;
import com.zoho.crm.library.crud.ZCRMDataProcessingBasisDetails;
import com.zoho.crm.library.crud.ZCRMEventParticipant;
import com.zoho.crm.library.crud.ZCRMInventoryLineItem;
import com.zoho.crm.library.crud.ZCRMJunctionRecord;
import com.zoho.crm.library.crud.ZCRMLayout;
import com.zoho.crm.library.crud.ZCRMModuleRelation;
import com.zoho.crm.library.crud.ZCRMNote;
import com.zoho.crm.library.crud.ZCRMPriceBookPricing;
import com.zoho.crm.library.crud.ZCRMTag;
import com.zoho.crm.library.crud.ZCRMTax;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.setup.users.ZCRMUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ZCRMRecord
extends ZCRMEntity
implements Cloneable {
    private Long entityId = null;
    private String moduleAPIName = null;
    private HashMap<String, Object> fieldNameVsValue = new HashMap();
    private HashMap<String, Object> properties = new HashMap();
    private ArrayList<ZCRMInventoryLineItem> lineItems = new ArrayList();
    private ArrayList<ZCRMEventParticipant> participants = new ArrayList();
    private ArrayList<ZCRMPriceBookPricing> priceDetails = new ArrayList();
    private String lookupLabel = null;
    private ZCRMUser owner;
    private ZCRMUser createdBy;
    private ZCRMUser modifiedBy;
    private String createdTime;
    private String modifiedTime;
    private ZCRMLayout layout;
    private List<ZCRMTax> taxList = new ArrayList<ZCRMTax>();
    private List<ZCRMTag> tagList = new ArrayList<ZCRMTag>();
    private ZCRMDataProcessingBasisDetails dataProcessingBasisDetails;

    public ZCRMRecord(String module) {
        this(module, null);
    }

    private ZCRMRecord(String module, Long id) {
        this.entityId = id;
        this.moduleAPIName = module;
    }

    public static ZCRMRecord getInstance(String moduleAPIName, Long entityId) {
        return new ZCRMRecord(moduleAPIName, entityId);
    }

    public String getModuleAPIName() {
        return this.moduleAPIName;
    }

    public void setModuleAPIName(String moduleAPIName) {
        this.moduleAPIName = moduleAPIName;
    }

    public void setEntityId(Long id) {
        this.entityId = id;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public void setLookupLabel(String lookupLabel) {
        this.lookupLabel = lookupLabel;
    }

    public String getLookupLabel() {
        return this.lookupLabel;
    }

    public void setLayout(ZCRMLayout layout) {
        this.layout = layout;
    }

    public ZCRMLayout getLayout() {
        return this.layout;
    }

    public void setOwner(ZCRMUser owner) {
        this.owner = owner;
    }

    public ZCRMUser getOwner() {
        return this.owner;
    }

    public void setCreatedBy(ZCRMUser createdBy) {
        this.createdBy = createdBy;
    }

    public ZCRMUser getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setModifiedBy(ZCRMUser modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public ZCRMUser getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedTime(String modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public String getModifiedTime() {
        return this.modifiedTime;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    private void setProperties(HashMap<String, Object> nameVsValue) {
        this.properties = nameVsValue;
    }

    public Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public void setFieldValue(String fieldAPIName, Object value) {
        this.fieldNameVsValue.put(fieldAPIName, value);
    }

    public Object getFieldValue(String fieldAPIName) throws ZCRMException {
        if (this.fieldNameVsValue.containsKey(fieldAPIName)) {
            if (this.fieldNameVsValue.get(fieldAPIName) == JSONObject.NULL) {
                return null;
            }
            return this.fieldNameVsValue.get(fieldAPIName);
        }
        throw new ZCRMException("The given field is not present in this record - " + fieldAPIName);
    }

    public HashMap<String, Object> getAllProperties() {
        return this.properties;
    }

    public void addLineItem(ZCRMInventoryLineItem newLineItem) {
        this.lineItems.add(newLineItem);
    }

    public List<ZCRMInventoryLineItem> getLineItems() {
        return this.lineItems;
    }

    public void addParticipant(ZCRMEventParticipant participant) {
        this.participants.add(participant);
    }

    public List<ZCRMEventParticipant> getParticipants() {
        return this.participants;
    }

    public List<ZCRMPriceBookPricing> getPriceDetails() {
        return this.priceDetails;
    }

    public void addPriceDetail(ZCRMPriceBookPricing priceDetail) {
        this.priceDetails.add(priceDetail);
    }

    public List<ZCRMTax> getTaxList() {
        return this.taxList;
    }

    public void addTax(ZCRMTax tax) {
        this.taxList.add(tax);
    }

    public List<ZCRMTag> getTagList() {
        return this.tagList;
    }

    public void addTag(ZCRMTag tag) {
        this.tagList.add(tag);
    }

    public void setDataProcessingBasisDetails(ZCRMDataProcessingBasisDetails dataProcessingBasisDetails) {
        this.dataProcessingBasisDetails = dataProcessingBasisDetails;
    }

    public ZCRMDataProcessingBasisDetails getDataProcessingBasisDetails() {
        return this.dataProcessingBasisDetails;
    }

    public void setData(HashMap<String, Object> fieldNameVsValue) {
        this.fieldNameVsValue = fieldNameVsValue;
    }

    public HashMap<String, Object> getData() {
        return this.fieldNameVsValue;
    }

    public APIResponse create() throws ZCRMException {
        if (this.getEntityId() != null) {
            throw new ZCRMException("Entity ID MUST be null for create operation.");
        }
        return EntityAPIHandler.getInstance(this).createRecord();
    }

    public APIResponse update() throws ZCRMException {
        if (this.getEntityId() == null) {
            throw new ZCRMException("Entity ID MUST NOT be null for update operation.");
        }
        return EntityAPIHandler.getInstance(this).updateRecord();
    }

    public APIResponse delete() throws ZCRMException {
        if (this.getEntityId() == null) {
            throw new ZCRMException("Entity ID MUST NOT be null for delete operation.");
        }
        APIResponse response = EntityAPIHandler.getInstance(this).deleteRecord();
        this.fieldNameVsValue = null;
        this.lineItems = null;
        return response;
    }

    public HashMap<String, Long> convert() throws ZCRMException {
        return this.convert(null);
    }

    public HashMap<String, Long> convert(ZCRMRecord potential) throws ZCRMException {
        return this.convert(potential, null);
    }

    public HashMap<String, Long> convert(ZCRMRecord potential, ZCRMUser assignToUser) throws ZCRMException {
        if (!this.moduleAPIName.equals("Leads")) {
            throw new ZCRMException("Convert option is only supported for Leads Module.");
        }
        return EntityAPIHandler.getInstance(this).convertRecord(potential, assignToUser);
    }

    public BulkAPIResponse getRelatedListRecords(String relatedListAPIName) throws ZCRMException {
        return this.getRelatedListRecords(relatedListAPIName, 1, 20);
    }

    public BulkAPIResponse getRelatedListRecords(String relatedListAPIName, int page, int per_page) throws ZCRMException {
        return this.getRelatedListRecords(relatedListAPIName, null, null, page, per_page, null);
    }

    public BulkAPIResponse getRelatedListRecords(String relatedListAPIName, String sortByField, CommonUtil.SortOrder sortOrder) throws ZCRMException {
        return this.getRelatedListRecords(relatedListAPIName, sortByField, sortOrder, 1, 20, null);
    }

    public BulkAPIResponse getRelatedListRecords(String relatedListAPIName, String sortByField, CommonUtil.SortOrder sortOrder, int page, int per_page, String modifiedSince) throws ZCRMException {
        return RelatedListAPIHandler.getInstance(this, ZCRMModuleRelation.getInstance(this.moduleAPIName, relatedListAPIName)).getRecords(sortByField, sortOrder, page, per_page, modifiedSince);
    }

    public BulkAPIResponse getNotes() throws ZCRMException {
        return this.getNotes(1, 20);
    }

    public BulkAPIResponse getNotes(int page, int per_page) throws ZCRMException {
        return this.getNotes(null, null, page, per_page, null);
    }

    public BulkAPIResponse getNotes(String sortByField, CommonUtil.SortOrder sortOrder) throws ZCRMException {
        return this.getNotes(sortByField, sortOrder, 1, 20, null);
    }

    public BulkAPIResponse getNotes(String sortByField, CommonUtil.SortOrder sortOrder, int page, int per_page, String modifiedSince) throws ZCRMException {
        return RelatedListAPIHandler.getInstance(this, ZCRMModuleRelation.getInstance(this.moduleAPIName, "Notes")).getNotes(sortByField, sortOrder, page, per_page, modifiedSince);
    }

    public APIResponse addNote(ZCRMNote note) throws ZCRMException {
        if (note.getId() != null) {
            throw new ZCRMException("Note ID MUST be null for create operation.");
        }
        return RelatedListAPIHandler.getInstance(this, ZCRMModuleRelation.getInstance(this.moduleAPIName, "Notes")).addNote(note);
    }

    public APIResponse updateNote(ZCRMNote note) throws ZCRMException {
        if (note.getId() == null) {
            throw new ZCRMException("Note ID MUST NOT be null for create operation.");
        }
        return RelatedListAPIHandler.getInstance(this, ZCRMModuleRelation.getInstance(this.moduleAPIName, "Notes")).updateNote(note);
    }

    public APIResponse deleteNote(ZCRMNote note) throws ZCRMException {
        if (note.getId() == null) {
            throw new ZCRMException("Note ID MUST NOT be null for delete operation.");
        }
        return RelatedListAPIHandler.getInstance(this, ZCRMModuleRelation.getInstance(this.moduleAPIName, "Notes")).deleteNote(note);
    }

    public BulkAPIResponse getAllAttachmentsDetails() throws ZCRMException {
        return this.getAllAttachmentsDetails(0, 20, null);
    }

    public BulkAPIResponse getAllAttachmentsDetails(int page, int per_page, String modifiedSince) throws ZCRMException {
        return RelatedListAPIHandler.getInstance(this, ZCRMModuleRelation.getInstance(this.moduleAPIName, "Attachments")).getAllAttachmentsDetails(page, per_page, modifiedSince);
    }

    public APIResponse uploadAttachment(String filePath) throws ZCRMException {
        return RelatedListAPIHandler.getInstance(this, ZCRMModuleRelation.getInstance(this.moduleAPIName, "Attachments")).uploadAttachment(filePath);
    }

    public APIResponse uploadLinkAsAttachment(String attachmentUrl) throws ZCRMException {
        return RelatedListAPIHandler.getInstance(this, ZCRMModuleRelation.getInstance(this.moduleAPIName, "Attachments")).uploadLinkAsAttachment(attachmentUrl);
    }

    public FileAPIResponse downloadAttachment(Long attachmentId) throws ZCRMException {
        return RelatedListAPIHandler.getInstance(this, ZCRMModuleRelation.getInstance(this.moduleAPIName, "Attachments")).downloadAttachment(attachmentId);
    }

    public APIResponse deleteAttachment(Long attachmentId) throws ZCRMException {
        return RelatedListAPIHandler.getInstance(this, ZCRMModuleRelation.getInstance(this.moduleAPIName, "Attachments")).deleteAttachment(attachmentId);
    }

    public APIResponse uploadPhoto(String filePath) throws ZCRMException {
        return EntityAPIHandler.getInstance(this).uploadPhoto(filePath);
    }

    public FileAPIResponse downloadPhoto() throws ZCRMException {
        return EntityAPIHandler.getInstance(this).downloadPhoto();
    }

    public APIResponse deletePhoto() throws ZCRMException {
        return EntityAPIHandler.getInstance(this).deletePhoto();
    }

    public APIResponse addRelation(ZCRMJunctionRecord junctionRecord) throws ZCRMException, JSONException {
        return RelatedListAPIHandler.getInstance(this, junctionRecord).addRelation();
    }

    public APIResponse deleteRelation(ZCRMJunctionRecord junctionRecord) throws ZCRMException {
        return RelatedListAPIHandler.getInstance(this, junctionRecord).deleteRelation();
    }

    public ZCRMRecord clone() throws CloneNotSupportedException {
        ZCRMRecord newRecord = (ZCRMRecord)super.clone();
        newRecord.setEntityId(null);
        newRecord.setProperties(null);
        return newRecord;
    }
}

