/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.common;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.common.CommonUtil;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.exception.ZCRMLogger;
import com.zoho.crm.library.setup.restclient.ZCRMRestClient;
import com.zoho.oauth.client.ZohoOAuth;
import com.zoho.oauth.client.ZohoOAuthClient;
import com.zoho.oauth.common.ZohoOAuthException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class ZCRMConfigUtil {
    public static HashMap<String, String> configProperties = new HashMap();
    private static boolean handleAuthentication = false;
    private static boolean isOAuth = false;

    public static void initializeForMobile(boolean initOAuth) throws Exception {
        ZCRMConfigUtil.initialize(initOAuth);
        handleAuthentication = true;
    }

    public static void initialize(boolean initOAuth) throws Exception {
        InputStream zcrmConfig;
        configProperties = CommonUtil.getFileAsMap(ZCRMConfigUtil.class.getResourceAsStream("/resources/configuration.properties"));
        if (initOAuth) {
            handleAuthentication = true;
            isOAuth = true;
            try {
                ZohoOAuth.initialize((String)configProperties.get("domainSuffix"));
            }
            catch (IOException e) {
                throw new ZCRMException(e);
            }
        }
        if (configProperties.containsKey("domainSuffix")) {
            ZCRMConfigUtil.updateConfigsBaseUrl(configProperties.get("domainSuffix"));
        }
        if ((zcrmConfig = ZCRMConfigUtil.class.getResourceAsStream("/resources/zcrm_configuration.properties")) != null) {
            configProperties.putAll(CommonUtil.getFileAsMap(zcrmConfig));
        }
        ZCRMLogger.initLogger();
        ZCRMLogger.logInfo("Java Client Library configuration properties : " + configProperties);
    }

    public static void loadConfigProperties(InputStream configFileInputStream) throws Exception {
        if (configFileInputStream != null) {
            configProperties.putAll(CommonUtil.getFileAsMap(configFileInputStream));
        }
        if (configProperties.containsKey("domainSuffix")) {
            ZCRMConfigUtil.updateConfigsBaseUrl(configProperties.get("domainSuffix"));
        }
    }

    public static void updateConfigsBaseUrl(String location) throws ZCRMException {
        String apiBaseUrl = "apiBaseUrl";
        String accessType = ZCRMConfigUtil.getAccessType();
        String domain = APIConstants.ACCESS_TYPE.containsKey(accessType) ? APIConstants.ACCESS_TYPE.get(accessType) : APIConstants.ACCESS_TYPE.get("Production");
        switch (location) {
            case "eu": {
                ZCRMConfigUtil.setConfigValue(apiBaseUrl, "https://" + domain + ".zohoapis.eu");
                break;
            }
            case "cn": {
                ZCRMConfigUtil.setConfigValue(apiBaseUrl, "https://" + domain + ".zohoapis.com.cn");
                break;
            }
            default: {
                ZCRMConfigUtil.setConfigValue(apiBaseUrl, "https://" + domain + ".zohoapis.com");
            }
        }
    }

    public static void setConfigValue(String config, String value) {
        configProperties.put(config, value);
    }

    public static String getAccessToken() throws ZohoOAuthException, ZCRMException {
        String userMailId = ZCRMRestClient.getCurrentUserEmail();
        if (userMailId == null && configProperties.get("currentUserEmail") == null) {
            throw new ZCRMException("Current user should either be set in ZCRMRestClient or in configuration.properties file");
        }
        if (userMailId == null) {
            userMailId = configProperties.get("currentUserEmail");
        }
        ZohoOAuthClient cli = ZohoOAuthClient.getInstance();
        return cli.getAccessToken(userMailId);
    }

    public static String getConfigValue(String config) {
        return configProperties.get(config);
    }

    public static String getApiBaseURL() {
        return ZCRMConfigUtil.getConfigValue("apiBaseUrl");
    }

    public static String getApiVersion() {
        return ZCRMConfigUtil.getConfigValue("apiVersion");
    }

    public static String getAuthenticationClass() {
        return ZCRMConfigUtil.getConfigValue("loginAuthClass");
    }

    public static HashMap getAllConfigs() {
        return configProperties;
    }

    public static String getAccessType() {
        return ZCRMConfigUtil.getConfigValue("accessType");
    }

    public static String getPhotoUrl() {
        return ZCRMConfigUtil.getConfigValue("photoUrl");
    }

    public static boolean shouldHandleAuthentication() {
        return handleAuthentication;
    }

    public static boolean isOAuth() {
        return isOAuth;
    }
}

