/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.api.handler;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.api.APIRequest;
import com.zoho.crm.library.api.handler.APIHandler;
import com.zoho.crm.library.api.handler.CommonAPIHandler;
import com.zoho.crm.library.api.response.APIResponse;
import com.zoho.crm.library.api.response.FileAPIResponse;
import com.zoho.crm.library.common.CommonUtil;
import com.zoho.crm.library.common.NullableJSONObject;
import com.zoho.crm.library.crud.ZCRMDataProcessingBasisDetails;
import com.zoho.crm.library.crud.ZCRMEventParticipant;
import com.zoho.crm.library.crud.ZCRMInventoryLineItem;
import com.zoho.crm.library.crud.ZCRMLayout;
import com.zoho.crm.library.crud.ZCRMPriceBookPricing;
import com.zoho.crm.library.crud.ZCRMRecord;
import com.zoho.crm.library.crud.ZCRMSubform;
import com.zoho.crm.library.crud.ZCRMTag;
import com.zoho.crm.library.crud.ZCRMTax;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.exception.ZCRMLogger;
import com.zoho.crm.library.setup.users.ZCRMUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EntityAPIHandler
extends CommonAPIHandler
implements APIHandler {
    protected ZCRMRecord record = null;

    protected EntityAPIHandler(ZCRMRecord zcrmRecord) {
        this.record = zcrmRecord;
    }

    public static EntityAPIHandler getInstance(ZCRMRecord zcrmRecord) {
        return new EntityAPIHandler(zcrmRecord);
    }

    public APIResponse getRecord(Boolean includePrivateFields) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = this.record.getModuleAPIName() + '/' + this.record.getEntityId();
            if (includePrivateFields.booleanValue()) {
                this.requestQueryParams.put("include", (Object)"private_fields");
            }
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONArray responseDataArray = response.getResponseJSON().getJSONArray(this.getJsonRootKey());
            JSONObject recordDetails = responseDataArray.getJSONObject(0);
            this.setRecordProperties(recordDetails);
            response.setData(this.record);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse createRecord() throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.POST;
            this.urlPath = this.record.getModuleAPIName();
            JSONObject requestBodyObj = new JSONObject();
            JSONArray dataArray = new JSONArray();
            dataArray.put((Object)this.getZCRMRecordAsJSON());
            requestBodyObj.put(this.getJsonRootKey(), (Object)dataArray);
            this.requestBody = requestBodyObj;
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONArray responseDataArray = response.getResponseJSON().getJSONArray(this.getJsonRootKey());
            JSONObject responseData = responseDataArray.getJSONObject(0);
            JSONObject recordDetails = responseData.getJSONObject("details");
            this.setRecordProperties(recordDetails);
            response.setData(this.record);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse updateRecord() throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.PUT;
            this.urlPath = this.record.getModuleAPIName() + '/' + this.record.getEntityId();
            JSONObject requestBodyObj = new JSONObject();
            JSONArray dataArray = new JSONArray();
            dataArray.put((Object)this.getZCRMRecordAsJSON());
            requestBodyObj.put(this.getJsonRootKey(), (Object)dataArray);
            this.requestBody = requestBodyObj;
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONArray responseDataArray = response.getResponseJSON().getJSONArray(this.getJsonRootKey());
            JSONObject responseData = responseDataArray.getJSONObject(0);
            JSONObject recordDetails = responseData.getJSONObject("details");
            this.setRecordProperties(recordDetails);
            response.setData(this.record);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse deleteRecord() throws ZCRMException {
        this.requestMethod = APIConstants.RequestMethod.DELETE;
        this.urlPath = this.record.getModuleAPIName() + '/' + this.record.getEntityId();
        return APIRequest.getInstance(this).getAPIResponse();
    }

    public HashMap<String, Long> convertRecord(ZCRMRecord potential, ZCRMUser assignToUser) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.POST;
            this.urlPath = this.record.getModuleAPIName() + '/' + this.record.getEntityId() + "/actions/convert";
            JSONObject requestBodyObj = new JSONObject();
            JSONArray dataArray = new JSONArray();
            JSONObject dataObject = new JSONObject();
            if (assignToUser != null) {
                dataObject.put("assign_to", (Object)String.valueOf(assignToUser.getId()));
            }
            if (potential != null) {
                dataObject.put("Deals", (Object)EntityAPIHandler.getInstance(potential).getZCRMRecordAsJSON());
            }
            dataArray.put((Object)dataObject);
            requestBodyObj.put(this.getJsonRootKey(), (Object)dataArray);
            this.requestBody = requestBodyObj;
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONObject responseJSON = response.getResponseJSON();
            JSONObject convertedIdsJSON = responseJSON.getJSONArray(this.getJsonRootKey()).getJSONObject(0);
            HashMap<String, Long> convertedIds = new HashMap<String, Long>();
            convertedIds.put("Contacts", Long.parseLong(convertedIdsJSON.getString("Contacts")));
            if (!convertedIdsJSON.isNull("Accounts")) {
                convertedIds.put("Accounts", Long.parseLong(convertedIdsJSON.getString("Accounts")));
            }
            if (!convertedIdsJSON.isNull("Deals")) {
                convertedIds.put("Deals", Long.parseLong(convertedIdsJSON.getString("Deals")));
            }
            return convertedIds;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse uploadPhoto(String filePath) throws ZCRMException {
        CommonUtil.validateFile(filePath);
        this.requestMethod = APIConstants.RequestMethod.POST;
        this.urlPath = this.record.getModuleAPIName() + '/' + this.record.getEntityId() + "/photo";
        return APIRequest.getInstance(this).uploadFile(filePath);
    }

    public FileAPIResponse downloadPhoto() throws ZCRMException {
        this.requestMethod = APIConstants.RequestMethod.GET;
        this.urlPath = this.record.getModuleAPIName() + '/' + this.record.getEntityId() + "/photo";
        return APIRequest.getInstance(this).downloadFile();
    }

    public APIResponse deletePhoto() throws ZCRMException {
        this.requestMethod = APIConstants.RequestMethod.DELETE;
        this.urlPath = this.record.getModuleAPIName() + '/' + this.record.getEntityId() + "/photo";
        return APIRequest.getInstance(this).getAPIResponse();
    }

    public void setRecordProperties(JSONObject recordJson) throws JSONException {
        NullableJSONObject recordDetails = new NullableJSONObject(recordJson);
        Iterator<String> jsonItr = recordDetails.keys();
        while (jsonItr.hasNext()) {
            String fieldAPIName = jsonItr.next();
            if ("id".equals(fieldAPIName)) {
                this.record.setEntityId(Long.parseLong(recordDetails.getString(fieldAPIName)));
                continue;
            }
            if ("Product_Details".equals(fieldAPIName)) {
                this.setInventoryLineItems(recordDetails.getJSONArray(fieldAPIName));
                continue;
            }
            if ("Participants".equals(fieldAPIName)) {
                this.setParticipants(recordDetails.getJSONArray(fieldAPIName));
                continue;
            }
            if ("Pricing_Details".equals(fieldAPIName)) {
                this.setPriceDetails(recordDetails.getJSONArray(fieldAPIName));
                continue;
            }
            if ("Created_By".equals(fieldAPIName)) {
                JSONObject createdByObj = recordDetails.getJSONObject(fieldAPIName);
                ZCRMUser createdBy = ZCRMUser.getInstance(Long.parseLong(createdByObj.getString("id")), createdByObj.getString("name"));
                this.record.setCreatedBy(createdBy);
                continue;
            }
            if ("Modified_By".equals(fieldAPIName)) {
                JSONObject modifiedByObj = recordDetails.getJSONObject(fieldAPIName);
                ZCRMUser modifiedBy = ZCRMUser.getInstance(Long.parseLong(modifiedByObj.getString("id")), modifiedByObj.getString("name"));
                this.record.setModifiedBy(modifiedBy);
                continue;
            }
            if ("Created_Time".equals(fieldAPIName)) {
                this.record.setCreatedTime(recordDetails.getString(fieldAPIName));
                continue;
            }
            if ("Modified_Time".equals(fieldAPIName)) {
                this.record.setModifiedTime(recordDetails.getString(fieldAPIName));
                continue;
            }
            if ("Owner".equals(fieldAPIName)) {
                JSONObject ownerObj = recordDetails.getJSONObject(fieldAPIName);
                ZCRMUser owner = ZCRMUser.getInstance(Long.parseLong(ownerObj.getString("id")), ownerObj.getString("name"));
                this.record.setOwner(owner);
                continue;
            }
            if ("Layout".equals(fieldAPIName)) {
                ZCRMLayout layout = null;
                if (!recordDetails.isNull(fieldAPIName)) {
                    JSONObject layoutObj = recordDetails.getJSONObject(fieldAPIName);
                    layout = ZCRMLayout.getInstance(Long.parseLong(layoutObj.getString("id")));
                    layout.setName(layoutObj.getString("name"));
                }
                this.record.setLayout(layout);
                continue;
            }
            if ("Handler".equals(fieldAPIName) && !recordDetails.isNull(fieldAPIName)) {
                JSONObject handlerObj = recordDetails.getJSONObject(fieldAPIName);
                ZCRMUser handler = ZCRMUser.getInstance(Long.parseLong(handlerObj.getString("id")), handlerObj.getString("name"));
                this.record.setFieldValue(fieldAPIName, handler);
                continue;
            }
            if ("Recurring_Activity".equals(fieldAPIName) && !recordDetails.isNull(fieldAPIName)) {
                JSONObject jsonObject = recordDetails.getJSONObject(fieldAPIName);
                this.record.setFieldValue("RRULE", jsonObject.getString("RRULE"));
                continue;
            }
            if ("$line_tax".equals(fieldAPIName)) {
                JSONArray taxDetails = recordDetails.getJSONArray(fieldAPIName);
                for (int index = 0; index < taxDetails.length(); ++index) {
                    JSONObject taxJSON = taxDetails.getJSONObject(index);
                    ZCRMTax tax = ZCRMTax.getInstance(taxJSON.getString("name"));
                    tax.setPercentage(taxJSON.getDouble("percentage"));
                    tax.setValue(taxJSON.getDouble("value"));
                    this.record.addTax(tax);
                }
                continue;
            }
            if ("Tax".equals(fieldAPIName) && recordDetails.get("Tax") instanceof JSONArray) {
                JSONArray taxNames = recordDetails.getJSONArray(fieldAPIName);
                for (int index = 0; index < taxNames.length(); ++index) {
                    ZCRMTax tax = ZCRMTax.getInstance(taxNames.getString(index));
                    this.record.addTax(tax);
                }
                continue;
            }
            if ("Tag".equals(fieldAPIName) && recordDetails.get("Tag") instanceof JSONArray) {
                JSONArray tags = recordDetails.getJSONArray(fieldAPIName);
                for (int index = 0; index < tags.length(); ++index) {
                    JSONObject tagJSON = tags.getJSONObject(index);
                    ZCRMTag tag = ZCRMTag.getInstance(Long.parseLong(tagJSON.getString("id")));
                    tag.setName(tagJSON.getString("name"));
                    this.record.addTag(tag);
                }
                continue;
            }
            if ("Data_Processing_Basis_Details".equals(fieldAPIName) && !recordDetails.isNull("Data_Processing_Basis_Details")) {
                NullableJSONObject dataProcessDetails = new NullableJSONObject(recordDetails.getJSONObject("Data_Processing_Basis_Details"));
                ZCRMDataProcessingBasisDetails dataProcessingBasisDetails = ZCRMDataProcessingBasisDetails.getInstance(Long.parseLong(dataProcessDetails.getString("id")));
                dataProcessingBasisDetails.setConsentDate(dataProcessDetails.getString("Consent_Date"));
                dataProcessingBasisDetails.setConsentEndsOn(dataProcessDetails.getString("Consent_EndsOn"));
                dataProcessingBasisDetails.setConsentRemarks(dataProcessDetails.getString("Consent_Remarks"));
                dataProcessingBasisDetails.setConsentThrough(dataProcessDetails.getString("Consent_Through"));
                ArrayList<CommonUtil.ConsentProcessThrough> consentProcessThroughList = new ArrayList<CommonUtil.ConsentProcessThrough>();
                if (dataProcessDetails.has("Contact_Through_Phone") && dataProcessDetails.getBoolean("Contact_Through_Phone").booleanValue()) {
                    consentProcessThroughList.add(CommonUtil.ConsentProcessThrough.Phone);
                }
                if (dataProcessDetails.has("Contact_Through_Email") && dataProcessDetails.getBoolean("Contact_Through_Email").booleanValue()) {
                    consentProcessThroughList.add(CommonUtil.ConsentProcessThrough.Email);
                }
                if (dataProcessDetails.has("Contact_Through_Survey") && dataProcessDetails.getBoolean("Contact_Through_Survey").booleanValue()) {
                    consentProcessThroughList.add(CommonUtil.ConsentProcessThrough.Survey);
                }
                if (dataProcessDetails.has("Contact_Through_Social") && dataProcessDetails.getBoolean("Contact_Through_Social").booleanValue()) {
                    consentProcessThroughList.add(CommonUtil.ConsentProcessThrough.Social);
                }
                dataProcessingBasisDetails.setConsentProcessThroughList(consentProcessThroughList);
                dataProcessingBasisDetails.setDataProcessingBasis(dataProcessDetails.getString("Data_Processing_Basis"));
                dataProcessingBasisDetails.setLawfulReason(dataProcessDetails.getString("Lawful_Reason"));
                dataProcessingBasisDetails.setMailSentTime(dataProcessDetails.getString("Mail_Sent_Time"));
                JSONObject ownerObj = dataProcessDetails.getJSONObject("Owner");
                ZCRMUser owner = ZCRMUser.getInstance(Long.parseLong(ownerObj.getString("id")), ownerObj.getString("name"));
                dataProcessingBasisDetails.setOwner(owner);
                JSONObject createdByObj = dataProcessDetails.getJSONObject("Created_By");
                ZCRMUser createdBy = ZCRMUser.getInstance(Long.parseLong(createdByObj.getString("id")), createdByObj.getString("name"));
                dataProcessingBasisDetails.setCreatedBy(createdBy);
                JSONObject modifiedByObj = dataProcessDetails.getJSONObject("Modified_By");
                ZCRMUser modifiedBy = ZCRMUser.getInstance(Long.parseLong(modifiedByObj.getString("id")), modifiedByObj.getString("name"));
                dataProcessingBasisDetails.setModifiedBy(modifiedBy);
                dataProcessingBasisDetails.setCreatedTime(dataProcessDetails.getString("Created_Time"));
                dataProcessingBasisDetails.setModifiedTime(dataProcessDetails.getString("Modified_Time"));
                this.record.setDataProcessingBasisDetails(dataProcessingBasisDetails);
                continue;
            }
            if (fieldAPIName.startsWith("$")) {
                String fieldName = fieldAPIName.replaceFirst("\\$", "");
                if (APIConstants.PROPERTIES_AS_FILEDS.contains(fieldName)) {
                    this.record.setFieldValue(fieldName, recordDetails.opt(fieldAPIName));
                    continue;
                }
                this.record.setProperty(fieldName, recordDetails.opt(fieldAPIName));
                continue;
            }
            if (recordDetails.get(fieldAPIName) instanceof JSONObject) {
                JSONObject lookupDetails = recordDetails.getJSONObject(fieldAPIName);
                ZCRMRecord lookupRecord = ZCRMRecord.getInstance(fieldAPIName, Long.parseLong(lookupDetails.getString("id")));
                lookupRecord.setLookupLabel(lookupDetails.getString("name"));
                this.record.setFieldValue(fieldAPIName, lookupRecord);
                continue;
            }
            if (recordDetails.get(fieldAPIName) instanceof JSONArray) {
                JSONArray jsonArray = recordDetails.getJSONArray(fieldAPIName);
                ArrayList<Object> values = new ArrayList<Object>();
                for (int index = 0; index < jsonArray.length(); ++index) {
                    if (jsonArray.get(index) instanceof JSONObject) {
                        values.add(this.getZCRMSubform(jsonArray.getJSONObject(index)));
                        continue;
                    }
                    values.add(jsonArray.get(index));
                }
                this.record.setFieldValue(fieldAPIName, values);
                continue;
            }
            this.record.setFieldValue(fieldAPIName, recordDetails.opt(fieldAPIName));
        }
    }

    private void setInventoryLineItems(JSONArray lineItems) throws JSONException {
        for (int index = 0; index < lineItems.length(); ++index) {
            JSONObject lineItemDetails = lineItems.getJSONObject(index);
            this.record.addLineItem(this.getZCRMInventoryLineItem(lineItemDetails));
        }
    }

    public ZCRMInventoryLineItem getZCRMInventoryLineItem(JSONObject lineItemDetails) throws JSONException {
        NullableJSONObject productDetails = new NullableJSONObject(lineItemDetails.getJSONObject("product"));
        Long lineItemId = Long.parseLong(lineItemDetails.getString("id"));
        ZCRMInventoryLineItem lineItem = ZCRMInventoryLineItem.getInstance(lineItemId);
        ZCRMRecord product = ZCRMRecord.getInstance("Products", Long.parseLong(productDetails.getString("id")));
        product.setLookupLabel(productDetails.getString("name"));
        lineItem.setProduct(product);
        lineItem.setDescription(lineItemDetails.optString("product_description"));
        lineItem.setQuantity(lineItemDetails.getDouble("quantity"));
        lineItem.setListPrice(lineItemDetails.getDouble("list_price"));
        lineItem.setUnitPrice(lineItemDetails.getDouble("unit_price"));
        lineItem.setTotal(lineItemDetails.getDouble("total"));
        lineItem.setDiscount(lineItemDetails.getDouble("Discount"));
        lineItem.setTotalAfterDiscount(lineItemDetails.getDouble("total_after_discount"));
        lineItem.setTaxAmount(lineItemDetails.getDouble("Tax"));
        JSONArray lineTaxes = lineItemDetails.getJSONArray("line_tax");
        for (int index = 0; index < lineTaxes.length(); ++index) {
            JSONObject lineTax = lineTaxes.getJSONObject(index);
            ZCRMTax tax = ZCRMTax.getInstance(lineTax.getString("name"));
            tax.setPercentage(lineTax.getDouble("percentage"));
            tax.setValue(lineTax.getDouble("value"));
            lineItem.addLineTax(tax);
        }
        lineItem.setNetTotal(lineItemDetails.getDouble("net_total"));
        return lineItem;
    }

    private void setParticipants(JSONArray participants) throws JSONException {
        for (int index = 0; index < participants.length(); ++index) {
            JSONObject participantDetails = participants.getJSONObject(index);
            this.record.addParticipant(this.getZCRMParticipant(participantDetails));
        }
    }

    public ZCRMEventParticipant getZCRMParticipant(JSONObject participantDetails) throws JSONException {
        Long participantId = Long.parseLong(participantDetails.getString("participant"));
        String type = participantDetails.getString("type");
        ZCRMEventParticipant participant = ZCRMEventParticipant.getInstance(type, participantId);
        participant.setName(participantDetails.getString("name"));
        participant.setEmail(participantDetails.getString("Email"));
        participant.setInvited(participantDetails.getBoolean("invited"));
        participant.setStatus(participantDetails.getString("status"));
        return participant;
    }

    private void setPriceDetails(JSONArray priceDetails) throws JSONException {
        for (int index = 0; index < priceDetails.length(); ++index) {
            JSONObject priceDetailsJSON = priceDetails.getJSONObject(index);
            this.record.addPriceDetail(this.getZCRMPriceDetail(priceDetailsJSON));
        }
    }

    public ZCRMPriceBookPricing getZCRMPriceDetail(JSONObject priceDetailsJSON) throws JSONException {
        long id = Long.parseLong(priceDetailsJSON.getString("id"));
        ZCRMPriceBookPricing priceDetail = ZCRMPriceBookPricing.getInstance(id);
        priceDetail.setDiscount(priceDetailsJSON.getDouble("discount"));
        priceDetail.setToRange(priceDetailsJSON.getDouble("to_range"));
        priceDetail.setFromRange(priceDetailsJSON.getDouble("from_range"));
        return priceDetail;
    }

    public ZCRMSubform getZCRMSubform(JSONObject subformDetails) throws JSONException {
        ZCRMSubform subform = ZCRMSubform.getInstance(subformDetails.getString("Name"), Long.parseLong(subformDetails.getString("id")));
        NullableJSONObject recordDetails = new NullableJSONObject(subformDetails);
        Iterator<String> jsonItr = recordDetails.keys();
        while (jsonItr.hasNext()) {
            JSONObject jsonObject;
            String fieldAPIName = jsonItr.next();
            if ("id".equals(fieldAPIName)) {
                subform.setEntityId(Long.parseLong(recordDetails.getString(fieldAPIName)));
                continue;
            }
            if ("Created_Time".equals(fieldAPIName)) {
                subform.setCreatedTime(recordDetails.getString(fieldAPIName));
                continue;
            }
            if ("Modified_Time".equals(fieldAPIName)) {
                subform.setModifiedTime(recordDetails.getString(fieldAPIName));
                continue;
            }
            if ("Owner".equals(fieldAPIName)) {
                JSONObject ownerObj = recordDetails.getJSONObject(fieldAPIName);
                ZCRMUser owner = ZCRMUser.getInstance(Long.parseLong(ownerObj.getString("id")), ownerObj.getString("name"));
                subform.setOwner(owner);
                continue;
            }
            if ("Layout".equals(fieldAPIName)) {
                ZCRMLayout layout = null;
                if (!recordDetails.isNull(fieldAPIName)) {
                    JSONObject layoutObj = recordDetails.getJSONObject(fieldAPIName);
                    layout = ZCRMLayout.getInstance(Long.parseLong(layoutObj.getString("id")));
                    layout.setName(layoutObj.getString("name"));
                }
                subform.setLayout(layout);
                continue;
            }
            if ("Remind_At".equals(fieldAPIName) && !recordDetails.isNull(fieldAPIName)) {
                jsonObject = recordDetails.getJSONObject(fieldAPIName);
                subform.setFieldValue("ALARM", jsonObject.getString("ALARM"));
                continue;
            }
            if ("Recurring_Activity".equals(fieldAPIName) && !recordDetails.isNull(fieldAPIName)) {
                jsonObject = recordDetails.getJSONObject(fieldAPIName);
                subform.setFieldValue("RRULE", jsonObject.getString("RRULE"));
                continue;
            }
            if (fieldAPIName.startsWith("$")) {
                String fieldName = fieldAPIName.replaceFirst("\\$", "");
                if (APIConstants.PROPERTIES_AS_FILEDS.contains(fieldName)) {
                    subform.setFieldValue(fieldName, recordDetails.opt(fieldAPIName));
                    continue;
                }
                subform.setProperty(fieldName, recordDetails.opt(fieldAPIName));
                continue;
            }
            if (recordDetails.get(fieldAPIName) instanceof JSONObject) {
                JSONObject lookupDetails = recordDetails.getJSONObject(fieldAPIName);
                ZCRMRecord lookupRecord = ZCRMRecord.getInstance(fieldAPIName, Long.parseLong(lookupDetails.getString("id")));
                lookupRecord.setLookupLabel(lookupDetails.getString("name"));
                subform.setFieldValue(fieldAPIName, lookupRecord);
                continue;
            }
            if (recordDetails.get(fieldAPIName) instanceof JSONArray) {
                JSONArray jsonArray = recordDetails.getJSONArray(fieldAPIName);
                ArrayList<Object> values = new ArrayList<Object>();
                for (int index = 0; index < jsonArray.length(); ++index) {
                    values.add(jsonArray.get(index));
                }
                subform.setFieldValue(fieldAPIName, values);
                continue;
            }
            subform.setFieldValue(fieldAPIName, recordDetails.opt(fieldAPIName));
        }
        return subform;
    }

    JSONObject getZCRMRecordAsJSON() throws JSONException {
        JSONObject recordJSON = new JSONObject();
        HashMap<String, Object> recordData = this.record.getData();
        if (this.record.getOwner() != null) {
            recordJSON.put("Owner", (Object)this.record.getOwner().getId().toString());
        }
        if (this.record.getLayout() != null) {
            recordJSON.put("Layout", (Object)this.record.getLayout().getId().toString());
        }
        this.mapAsJSON(recordData, recordJSON);
        recordJSON.put("Product_Details", (Object)this.getLineItemsAsJSONArray());
        recordJSON.put("Participants", (Object)this.getParticipantsAsJSONArray());
        recordJSON.put("Pricing_Details", (Object)this.getPriceDetailsAsJSONArray());
        recordJSON.put("Tax", (Object)this.getTaxAsJSONArray());
        ZCRMDataProcessingBasisDetails dataProcessingBasisDetails = this.record.getDataProcessingBasisDetails();
        if (dataProcessingBasisDetails != null) {
            recordJSON.put("Data_Processing_Basis_Details", (Object)this.getDataProcessingBasisDetailsAsJSONObject(dataProcessingBasisDetails));
        }
        return recordJSON;
    }

    private void mapAsJSON(HashMap<String, Object> data, JSONObject jsonObject) throws JSONException {
        for (String fieldAPIName : data.keySet()) {
            Object value = data.get(fieldAPIName);
            if (value == null) {
                value = JSONObject.NULL;
            } else if (value instanceof ZCRMRecord) {
                value = ((ZCRMRecord)value).getEntityId().toString();
            } else if (value instanceof ZCRMUser) {
                value = ((ZCRMUser)value).getId().toString();
            } else if (value instanceof ArrayList) {
                JSONArray jsonArray = new JSONArray();
                List list = (List)value;
                for (int index = 0; index < list.size(); ++index) {
                    Object obj = list.get(index);
                    if (obj instanceof ZCRMSubform) {
                        jsonArray.put((Object)this.getSubformsAsJSON((ZCRMSubform)obj));
                        continue;
                    }
                    jsonArray.put(obj);
                }
                value = jsonArray;
            }
            jsonObject.put(fieldAPIName, value);
        }
    }

    private JSONObject getSubformsAsJSON(ZCRMSubform subform) throws JSONException {
        JSONObject subformJSON = new JSONObject();
        HashMap<String, Object> subformData = subform.getData();
        if (subform.getEntityId() != null) {
            subformJSON.put("id", (Object)subform.getEntityId().toString());
        }
        if (subform.getOwner() != null) {
            subformJSON.put("Owner", (Object)subform.getOwner().getId().toString());
        }
        if (subform.getLayout() != null) {
            subformJSON.put("Layout", (Object)subform.getLayout().getId().toString());
        }
        this.mapAsJSON(subformData, subformJSON);
        return subformJSON;
    }

    private JSONObject getDataProcessingBasisDetailsAsJSONObject(ZCRMDataProcessingBasisDetails dataProcessingBasisDetails) throws JSONException {
        JSONObject dataProcessingDetails = new JSONObject();
        List<CommonUtil.ConsentProcessThrough> consentProcessThroughList = dataProcessingBasisDetails.getConsentProcessThroughList();
        if (consentProcessThroughList.contains((Object)CommonUtil.ConsentProcessThrough.Email)) {
            dataProcessingDetails.put("Contact_Through_Email", true);
        }
        if (consentProcessThroughList.contains((Object)CommonUtil.ConsentProcessThrough.Phone)) {
            dataProcessingDetails.put("Contact_Through_Phone", true);
        }
        if (consentProcessThroughList.contains((Object)CommonUtil.ConsentProcessThrough.Social)) {
            dataProcessingDetails.put("Contact_Through_Social", true);
        }
        if (consentProcessThroughList.contains((Object)CommonUtil.ConsentProcessThrough.Survey)) {
            dataProcessingDetails.put("Contact_Through_Survey", true);
        }
        dataProcessingDetails.put("Consent_Through", (Object)dataProcessingBasisDetails.getConsentThrough());
        dataProcessingDetails.put("Data_Processing_Basis", (Object)dataProcessingBasisDetails.getDataProcessingBasis());
        dataProcessingDetails.put("Consent_Date", (Object)dataProcessingBasisDetails.getConsentDate());
        dataProcessingDetails.put("Consent_Remarks", (Object)dataProcessingBasisDetails.getConsentRemarks());
        dataProcessingDetails.put("id", (Object)dataProcessingBasisDetails.getId());
        return dataProcessingDetails;
    }

    private JSONArray getTaxAsJSONArray() throws JSONException {
        if (this.record.getTaxList().isEmpty()) {
            return null;
        }
        JSONArray taxes = new JSONArray();
        List<ZCRMTax> taxList = this.record.getTaxList();
        if (this.record.getModuleAPIName().equals("Products")) {
            for (ZCRMTax aTaxList : taxList) {
                taxes.put((Object)aTaxList.getTaxName());
            }
        } else {
            for (ZCRMTax aTaxList : taxList) {
                JSONObject tax = new JSONObject();
                tax.put("percentage", aTaxList.getPercentage());
                tax.put("name", aTaxList.getPercentage());
                taxes.put((Object)tax);
            }
        }
        return taxes;
    }

    private JSONArray getLineItemsAsJSONArray() throws JSONException {
        if (this.record.getLineItems().isEmpty()) {
            return null;
        }
        JSONArray lineItems = new JSONArray();
        List<ZCRMInventoryLineItem> lineItemsList = this.record.getLineItems();
        for (ZCRMInventoryLineItem invLineItem : lineItemsList.toArray(new ZCRMInventoryLineItem[0])) {
            lineItems.put((Object)this.getZCRMInventoryLineItemAsJSON(invLineItem));
        }
        return lineItems;
    }

    private JSONObject getZCRMInventoryLineItemAsJSON(ZCRMInventoryLineItem invLineItem) throws JSONException {
        JSONObject lineItem = new JSONObject();
        if (invLineItem.getId() != null) {
            lineItem.put("id", (Object)String.valueOf(invLineItem.getId()));
        }
        if (invLineItem.getProduct() != null) {
            lineItem.put("product", (Object)String.valueOf(invLineItem.getProduct().getEntityId()));
        }
        lineItem.put("product_description", (Object)invLineItem.getDescription());
        lineItem.put("list_price", (Object)invLineItem.getListPrice());
        lineItem.put("quantity", (Object)invLineItem.getQuantity());
        if (invLineItem.getDiscountPercentage() == null) {
            lineItem.put("Discount", (Object)invLineItem.getDiscount());
        } else {
            lineItem.put("Discount", (Object)(invLineItem.getDiscountPercentage() + "%"));
        }
        JSONArray lineTaxArray = new JSONArray();
        List<ZCRMTax> taxes = invLineItem.getLineTax();
        for (ZCRMTax tax : taxes) {
            JSONObject linetax = new JSONObject();
            linetax.put("name", (Object)tax.getTaxName());
            linetax.put("value", tax.getValue());
            linetax.put("percentage", tax.getPercentage());
            lineTaxArray.put((Object)linetax);
        }
        lineItem.put("line_tax", (Object)lineTaxArray);
        return lineItem;
    }

    private JSONArray getParticipantsAsJSONArray() throws JSONException {
        if (this.record.getParticipants().isEmpty()) {
            return null;
        }
        JSONArray participants = new JSONArray();
        List<ZCRMEventParticipant> participantsList = this.record.getParticipants();
        for (ZCRMEventParticipant participant : participantsList.toArray(new ZCRMEventParticipant[0])) {
            participants.put((Object)this.getZCRMParticipantAsJSON(participant));
        }
        return participants;
    }

    private JSONObject getZCRMParticipantAsJSON(ZCRMEventParticipant participant) throws JSONException {
        JSONObject participantJSON = new JSONObject();
        participantJSON.put("participant", (Object)String.valueOf(participant.getId()));
        participantJSON.put("type", (Object)participant.getType());
        participantJSON.put("name", (Object)participant.getName());
        participantJSON.put("Email", (Object)participant.getEmail());
        participantJSON.put("invited", (Object)participant.isInvited());
        participantJSON.put("status", (Object)participant.getStatus());
        return participantJSON;
    }

    private JSONArray getPriceDetailsAsJSONArray() throws JSONException {
        if (this.record.getPriceDetails().isEmpty()) {
            return null;
        }
        JSONArray priceDetails = new JSONArray();
        List<ZCRMPriceBookPricing> priceDetailsList = this.record.getPriceDetails();
        for (ZCRMPriceBookPricing priceDetail : priceDetailsList.toArray(new ZCRMPriceBookPricing[0])) {
            priceDetails.put((Object)this.getZCRMPriceDetailAsJSON(priceDetail));
        }
        return priceDetails;
    }

    private JSONObject getZCRMPriceDetailAsJSON(ZCRMPriceBookPricing priceDetail) throws JSONException {
        JSONObject priceDetailJSON = new JSONObject();
        if (priceDetail.getId() != null) {
            priceDetailJSON.put("id", (Object)String.valueOf(priceDetail.getId()));
        }
        priceDetailJSON.put("discount", (Object)priceDetail.getDiscount());
        priceDetailJSON.put("to_range", (Object)priceDetail.getToRange());
        priceDetailJSON.put("from_range", (Object)priceDetail.getFromRange());
        return priceDetailJSON;
    }

    @Override
    public String getJsonRootKey() {
        return "data";
    }
}

