/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.oauth.clientapp;

import com.zoho.oauth.client.ZohoOAuth;
import com.zoho.oauth.client.ZohoPersistenceHandler;
import com.zoho.oauth.common.ZohoOAuthException;
import com.zoho.oauth.contract.ZohoOAuthTokens;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZohoOAuthDBPersistence
implements ZohoPersistenceHandler {
    private static final Logger LOGGER = Logger.getLogger(ZohoOAuthDBPersistence.class.getName());

    @Override
    public void saveOAuthData(ZohoOAuthTokens tokens) throws SQLException, ZohoOAuthException {
        this.deleteOAuthTokens(tokens.getUserMailId());
        Connection conn = null;
        Statement stmt = null;
        try {
            Class.forName("com.mysql.jdbc.Driver");
            conn = DriverManager.getConnection("jdbc:mysql://localhost:3306/zohooauth", ZohoOAuthDBPersistence.getMysqlUserName(), ZohoOAuthDBPersistence.getMysqlPassword());
            stmt = conn.prepareStatement("insert into oauthtokens(useridentifier, accesstoken, refreshtoken, expirytime) values (?,?,?,?)");
            stmt.setString(1, tokens.getUserMailId());
            stmt.setString(2, tokens.getAccessToken());
            stmt.setString(3, tokens.getRefreshToken());
            stmt.setLong(4, tokens.getExpiryTime());
            stmt.executeUpdate();
        }
        catch (Exception exp) {
            LOGGER.log(Level.SEVERE, "Exception while inserting tokens to database." + exp);
            exp.printStackTrace();
            throw new ZohoOAuthException(exp);
        }
        finally {
            stmt.close();
            conn.close();
        }
    }

    @Override
    public ZohoOAuthTokens getOAuthTokens(String userMailId) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ZohoOAuthTokens tokens = new ZohoOAuthTokens();
        Boolean isUserAvailable = false;
        try {
            Class.forName("com.mysql.jdbc.Driver");
            conn = DriverManager.getConnection("jdbc:mysql://localhost:3306/zohooauth", ZohoOAuthDBPersistence.getMysqlUserName(), ZohoOAuthDBPersistence.getMysqlPassword());
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select * from oauthtokens where useridentifier = '" + userMailId + "'");
            while (rs.next()) {
                isUserAvailable = true;
                tokens.setUserMailId(userMailId);
                tokens.setAccessToken(rs.getString("accesstoken"));
                tokens.setRefreshToken(rs.getString("refreshtoken"));
                tokens.setExpiryTime(rs.getLong("expirytime"));
            }
            if (!isUserAvailable.booleanValue()) {
                throw new ZohoOAuthException("Given User not found in persistence.");
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.SEVERE, "Exception while fetching tokens from database." + exp);
            tokens = null;
            if (exp instanceof ZohoOAuthException) {
                throw exp;
            }
            throw new ZohoOAuthException(exp);
        }
        finally {
            rs.close();
            stmt.close();
            conn.close();
        }
        return tokens;
    }

    @Override
    public void deleteOAuthTokens(String userMailId) throws SQLException, ZohoOAuthException {
        Connection conn = null;
        Statement stmt = null;
        try {
            Class.forName("com.mysql.jdbc.Driver");
            conn = DriverManager.getConnection("jdbc:mysql://localhost:3306/zohooauth", ZohoOAuthDBPersistence.getMysqlUserName(), ZohoOAuthDBPersistence.getMysqlPassword());
            stmt = conn.prepareStatement("delete from oauthtokens where useridentifier = '" + userMailId + "'");
            stmt.executeUpdate();
        }
        catch (Exception exp) {
            LOGGER.log(Level.SEVERE, "Exception while deleting tokens from database." + exp);
            exp.printStackTrace();
            throw new ZohoOAuthException(exp);
        }
        finally {
            stmt.close();
            conn.close();
        }
    }

    public static String getMysqlUserName() {
        String username = ZohoOAuth.getConfigValue("mysql_username");
        if (username == null) {
            return "root";
        }
        return username;
    }

    public static String getMysqlPassword() {
        String password = ZohoOAuth.getConfigValue("mysql_password");
        if (password == null) {
            return "";
        }
        return password;
    }
}

