/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.common;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NullableJSONObject {
    private JSONObject actualJSON = null;

    public NullableJSONObject() {
        this.actualJSON = new JSONObject();
    }

    public NullableJSONObject(JSONObject json) {
        this.actualJSON = json != null ? json : new JSONObject();
    }

    public JSONObject getActualJSON() {
        return this.actualJSON;
    }

    public Integer length() {
        return this.actualJSON.length();
    }

    public void put(String key, Object value) throws JSONException {
        if (value == null) {
            value = JSONObject.NULL;
        }
        this.actualJSON.put(key, value);
    }

    public boolean has(String key) {
        return this.actualJSON.has(key);
    }

    public boolean isNull(String key) {
        return !this.actualJSON.has(key) || this.actualJSON.isNull(key);
    }

    public Object get(String key) throws JSONException {
        if (this.isNull(key)) {
            return null;
        }
        return this.actualJSON.get(key);
    }

    public Object opt(String key) throws JSONException {
        try {
            return this.actualJSON.get(key);
        }
        catch (Exception var4) {
            return null;
        }
    }

    public String getString(String key) throws JSONException {
        if (this.isNull(key)) {
            return null;
        }
        return this.actualJSON.getString(key);
    }

    public String optString(String key) throws JSONException {
        return this.optString(key, null);
    }

    public String optString(String key, String defaultValue) throws JSONException {
        return this.actualJSON.optString(key, defaultValue);
    }

    public Integer getInt(String key) throws JSONException {
        if (this.isNull(key)) {
            return null;
        }
        return this.actualJSON.getInt(key);
    }

    public Integer optInt(String key) {
        try {
            return this.actualJSON.getInt(key);
        }
        catch (Exception var4) {
            return null;
        }
    }

    public Integer optInt(String key, int defaultValue) {
        return this.actualJSON.optInt(key, defaultValue);
    }

    public Double getDouble(String key) throws JSONException {
        if (this.isNull(key)) {
            return null;
        }
        return this.actualJSON.getDouble(key);
    }

    public Double optDouble(String key) {
        try {
            return this.actualJSON.getDouble(key);
        }
        catch (Exception var4) {
            return null;
        }
    }

    public Double optDouble(String key, Double defaultValue) {
        return this.actualJSON.optDouble(key, defaultValue);
    }

    public Boolean getBoolean(String key) throws JSONException {
        if (this.isNull(key)) {
            return null;
        }
        return this.actualJSON.getBoolean(key);
    }

    public boolean optBoolean(String key) {
        return this.actualJSON.optBoolean(key);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        return this.actualJSON.optBoolean(key, defaultValue);
    }

    public Long getLong(String key) throws JSONException {
        if (this.isNull(key)) {
            return null;
        }
        return this.actualJSON.getLong(key);
    }

    public Long optLong(String key) {
        try {
            return this.actualJSON.getLong(key);
        }
        catch (Exception var4) {
            return null;
        }
    }

    public Long optLong(String key, Long defaultValue) {
        return this.actualJSON.optLong(key, defaultValue);
    }

    public JSONObject getJSONObject(String key) throws JSONException {
        if (this.isNull(key)) {
            return null;
        }
        return this.actualJSON.getJSONObject(key);
    }

    public JSONObject optJSONObject(String key) {
        return this.actualJSON.optJSONObject(key);
    }

    public JSONObject optJSONObject(String key, JSONObject optVal) throws JSONException {
        if (this.isNull(key)) {
            return optVal;
        }
        return this.actualJSON.getJSONObject(key);
    }

    public JSONArray getJSONArray(String key) throws JSONException {
        if (this.isNull(key)) {
            return null;
        }
        return this.actualJSON.getJSONArray(key);
    }

    public JSONArray optJSONArray(String key) {
        return this.actualJSON.optJSONArray(key);
    }

    public JSONArray optJSONArray(String key, JSONArray optVal) throws JSONException {
        if (this.isNull(key)) {
            return optVal;
        }
        return this.actualJSON.getJSONArray(key);
    }

    public NullableJSONObject getParsedJSONObject(String key) throws JSONException {
        if (this.isNull(key)) {
            return null;
        }
        return new NullableJSONObject(this.actualJSON.getJSONObject(key));
    }

    public Iterator<String> keys() {
        return this.actualJSON.keys();
    }
}

