/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.api.handler;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.api.APIRequest;
import com.zoho.crm.library.api.handler.APIHandler;
import com.zoho.crm.library.api.handler.CommonAPIHandler;
import com.zoho.crm.library.api.response.APIResponse;
import com.zoho.crm.library.api.response.BulkAPIResponse;
import com.zoho.crm.library.common.CommonUtil;
import com.zoho.crm.library.common.NullableJSONObject;
import com.zoho.crm.library.crud.ZCRMOrgTax;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.exception.ZCRMLogger;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TaxAPIHandler
extends CommonAPIHandler
implements APIHandler {
    private TaxAPIHandler() {
    }

    public static TaxAPIHandler getInstance() {
        return new TaxAPIHandler();
    }

    public APIResponse getTax(Long taxId) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "org/taxes/" + taxId;
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONObject responseJSON = response.getResponseJSON();
            JSONArray taxArray = responseJSON.getJSONArray(this.getJsonRootKey());
            response.setData(this.getZCRMOrgTax(taxArray.getJSONObject(0)));
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse getAllTaxes() throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "org/taxes";
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            NullableJSONObject responseJSON = new NullableJSONObject(response.getResponseJSON());
            response.setData(this.getAllZCRMOrgTax(responseJSON));
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    private List<ZCRMOrgTax> getAllZCRMOrgTax(NullableJSONObject responseJSON) throws JSONException {
        ArrayList<ZCRMOrgTax> allOrgTaxes = new ArrayList<ZCRMOrgTax>();
        JSONArray taxArray = responseJSON.optJSONArray(this.getJsonRootKey(), new JSONArray());
        for (int index = 0; index < taxArray.length(); ++index) {
            allOrgTaxes.add(this.getZCRMOrgTax(taxArray.getJSONObject(index)));
        }
        return allOrgTaxes;
    }

    private ZCRMOrgTax getZCRMOrgTax(JSONObject taxJson) throws JSONException {
        NullableJSONObject taxDetails = new NullableJSONObject(taxJson);
        ZCRMOrgTax tax = ZCRMOrgTax.getInstance(Long.parseLong(taxDetails.getString("id")));
        tax.setName(taxDetails.getString("name"));
        tax.setDisplayName(taxDetails.optString("display_label"));
        tax.setValue(taxDetails.getDouble("value"));
        tax.setSequence(taxDetails.optInt("sequence_number"));
        return tax;
    }

    private JSONObject getZCRMOrgTaxAsJSON(ZCRMOrgTax tax) throws JSONException {
        JSONObject taxJSON = new JSONObject();
        taxJSON.put("name", tax.getName());
        taxJSON.put("id", String.valueOf(tax.getId()));
        taxJSON.put("display_label", tax.getDisplayName());
        taxJSON.put("value", tax.getValue());
        taxJSON.put("sequence_number", tax.getSequence());
        return taxJSON;
    }

    public BulkAPIResponse createTaxes(List<ZCRMOrgTax> taxes) throws ZCRMException {
        if (taxes.size() > 100) {
            throw new ZCRMException("Cannot process more than 100 records at a time.");
        }
        try {
            this.requestMethod = APIConstants.RequestMethod.POST;
            this.urlPath = "org/taxes";
            JSONObject requestBodyObj = new JSONObject();
            JSONArray dataArray = new JSONArray();
            for (ZCRMOrgTax tax : taxes) {
                dataArray.put(this.getZCRMOrgTaxAsJSON(tax));
            }
            requestBodyObj.put(this.getJsonRootKey(), dataArray);
            this.requestBody = requestBodyObj;
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMOrgTax> createdTaxes = new ArrayList<ZCRMOrgTax>();
            ArrayList<BulkAPIResponse.EntityResponse> responses = response.getEntityResponses();
            for (int i = 0; i < responses.size(); ++i) {
                BulkAPIResponse.EntityResponse entResponse = (BulkAPIResponse.EntityResponse)responses.get(i);
                if ("success".equals(entResponse.getStatus())) {
                    JSONObject responseData = entResponse.getResponseJSON();
                    JSONObject responseDetails = responseData.getJSONObject("details");
                    ZCRMOrgTax tax = this.getZCRMOrgTax(responseDetails);
                    createdTaxes.add(tax);
                    entResponse.setData(tax);
                    continue;
                }
                entResponse.setData(null);
            }
            response.setData(createdTaxes);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse updateTaxes(List<ZCRMOrgTax> taxes) throws ZCRMException {
        if (taxes.size() > 100) {
            throw new ZCRMException("Cannot process more than 100 records at a time.");
        }
        try {
            this.requestMethod = APIConstants.RequestMethod.PUT;
            this.urlPath = "org/taxes";
            JSONObject requestBodyObj = new JSONObject();
            JSONArray dataArray = new JSONArray();
            for (ZCRMOrgTax tax : taxes) {
                dataArray.put(this.getZCRMOrgTaxAsJSON(tax));
            }
            requestBodyObj.put(this.getJsonRootKey(), dataArray);
            this.requestBody = requestBodyObj;
            return APIRequest.getInstance(this).getBulkAPIResponse();
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse deleteTaxes(List<Long> taxIds) throws ZCRMException {
        if (taxIds.size() > 100) {
            throw new ZCRMException("Cannot process more than 100 records at a time.");
        }
        try {
            this.requestMethod = APIConstants.RequestMethod.DELETE;
            this.urlPath = "org/taxes";
            this.requestQueryParams.put("ids", CommonUtil.collectionToCommaDelimitedString(taxIds.toString(), ","));
            return APIRequest.getInstance(this).getBulkAPIResponse();
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    @Override
    public String getJsonRootKey() {
        return "taxes";
    }
}

