/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.oauth.contract;

import com.zoho.oauth.common.ZohoOAuthException;
import org.json.JSONException;
import org.json.JSONObject;

public class ZohoOAuthTokens {
    private String userMailId;
    private String accessToken;
    private String refreshToken;
    private long expiryTime;

    public void setUserMailId(String userMailId) {
        this.userMailId = userMailId;
    }

    public String getUserMailId() {
        return this.userMailId;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() throws ZohoOAuthException {
        if (this.isAccessTokenValid().booleanValue()) {
            return this.accessToken;
        }
        throw new ZohoOAuthException("Access Token has expired.");
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Long getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(Long expiryTime) {
        this.expiryTime = expiryTime;
    }

    public long getExpiryLapseInMillis() {
        return this.getExpiryTime() - System.currentTimeMillis();
    }

    private Boolean isAccessTokenValid() {
        if (this.getExpiryLapseInMillis() > 15000L) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public JSONObject toJSON() throws JSONException, ZohoOAuthException {
        JSONObject tokens = new JSONObject();
        tokens.put("user_mail_id", (Object)this.getUserMailId());
        tokens.put("access_token", (Object)this.getAccessToken());
        tokens.put("refresh_token", (Object)this.getRefreshToken());
        tokens.put("expires_in", this.getExpiryLapseInMillis());
        tokens.put("expiry_time", (Object)this.getExpiryTime());
        return tokens;
    }
}

