/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.oauth.client;

import com.zoho.oauth.client.ZohoOAuthClient;
import com.zoho.oauth.client.ZohoPersistenceHandler;
import com.zoho.oauth.common.ZohoOAuthException;
import com.zoho.oauth.contract.ZohoOAuthParams;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.logging.Logger;

public class ZohoOAuth {
    private static Logger logger = Logger.getLogger(ZohoOAuth.class.getName());
    private static HashMap<String, String> configProperties = new HashMap();

    public static void initialize(HashMap<String, String> configurations) {
        configProperties.putAll(configurations);
        if (!configProperties.containsKey("iamURL")) {
            ZohoOAuth.setIAMUrl(ZohoOAuth.getConfigValue("domainSuffix"));
        }
        ZohoOAuthParams params = new ZohoOAuthParams();
        params.setAccessType(ZohoOAuth.getConfigValue("access_type"));
        params.setClientId(ZohoOAuth.getConfigValue("client_id"));
        params.setClientSecret(ZohoOAuth.getConfigValue("client_secret"));
        params.setRedirectURL(ZohoOAuth.getConfigValue("redirect_uri"));
        params.setScopes(ZohoOAuth.getConfigValue("scope"));
        ZohoOAuthClient.getInstance(params);
        logger.info("Zoho OAuth Client Library configuration properties : " + configProperties);
    }

    private static void setIAMUrl(String domainSuffix) {
        if (domainSuffix == null) {
            domainSuffix = "com";
        }
        switch (domainSuffix) {
            case "eu": {
                configProperties.put("iamURL", "https://accounts.zoho.eu");
                break;
            }
            case "cn": {
                configProperties.put("iamURL", "https://accounts.zoho.com.cn");
                break;
            }
            default: {
                configProperties.put("iamURL", "https://accounts.zoho.com");
            }
        }
    }

    public static String getConfigValue(String key) {
        return configProperties.get(key);
    }

    public static HashMap<String, String> getAllConfigs() {
        return configProperties;
    }

    public static String getIAMUrl() {
        return ZohoOAuth.getConfigValue("iamURL");
    }

    public static String getLoginWithZohoUrl() {
        return ZohoOAuth.getIAMUrl() + "/oauth/v2/auth?scope=" + ZohoOAuth.getCRMScope() + "&client_id=" + ZohoOAuth.getClientID() + "&client_secret=" + ZohoOAuth.getClientSecret() + "&response_type=code&access_type=" + ZohoOAuth.getAccessType() + "&redirect_uri=" + ZohoOAuth.getRedirectURL();
    }

    public static String getTokenURL() {
        return ZohoOAuth.getIAMUrl() + "/oauth/v2/token";
    }

    public static String getRefreshTokenURL() {
        return ZohoOAuth.getIAMUrl() + "/oauth/v2/token";
    }

    public static String getUserInfoURL() {
        return ZohoOAuth.getIAMUrl() + "/oauth/user/info";
    }

    public static String getRevokeTokenURL() {
        return ZohoOAuth.getIAMUrl() + "/oauth/v2/token/revoke";
    }

    public static String getCRMScope() {
        return ZohoOAuth.getConfigValue("scope");
    }

    public static String getClientID() {
        return ZohoOAuth.getConfigValue("client_id");
    }

    public static String getClientSecret() {
        return ZohoOAuth.getConfigValue("client_secret");
    }

    public static String getRedirectURL() {
        return ZohoOAuth.getConfigValue("redirect_uri");
    }

    public static String getAccessType() {
        return ZohoOAuth.getConfigValue("access_type");
    }

    public static ZohoPersistenceHandler getPersistenceHandlerInstance() throws ZohoOAuthException {
        try {
            String className = ZohoOAuth.getConfigValue("persistence_handler_class");
            return (ZohoPersistenceHandler)Class.forName(className).getConstructor(null).newInstance(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ZohoOAuthException(ex);
        }
    }
}

