/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.crud;

import com.zoho.crm.library.api.handler.TagAPIHandler;
import com.zoho.crm.library.api.response.APIResponse;
import com.zoho.crm.library.common.ZCRMEntity;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.setup.users.ZCRMUser;

public class ZCRMTag
extends ZCRMEntity {
    private String name;
    private Long id;
    private ZCRMUser createdBy;
    private String createdTime;
    private ZCRMUser modifiedBy;
    private String modifiedTime;
    private int count;
    private String moduleApiName;

    private ZCRMTag(Long id) {
        this.id = id;
    }

    private ZCRMTag() {
    }

    private ZCRMTag(long entityId, String moduleApiName) {
        this.id = entityId;
        this.moduleApiName = moduleApiName;
    }

    public static ZCRMTag getInstance(Long id) {
        return new ZCRMTag(id);
    }

    public static ZCRMTag getInstance(Long id, String moduleApiName) {
        return new ZCRMTag(id, moduleApiName);
    }

    public static ZCRMTag getInstance() {
        return new ZCRMTag();
    }

    public Long getId() {
        return this.id;
    }

    public void setTagId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCreatedBy(ZCRMUser createdBy) {
        this.createdBy = createdBy;
    }

    public ZCRMUser getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setModifiedBy(ZCRMUser modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public ZCRMUser getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedTime(String modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public String getModifiedTime() {
        return this.modifiedTime;
    }

    public void setTagCount(int count) {
        this.count = count;
    }

    public int getTagCount() {
        return this.count;
    }

    public void setModuleAPIName(String moduleApiName) {
        this.moduleApiName = moduleApiName;
    }

    public String getModuleAPIName() {
        return this.moduleApiName;
    }

    public APIResponse delete() throws ZCRMException {
        if (this.id == null || this.id == 0L) {
            throw new ZCRMException("Tag ID MUST NOT be null/empty for Delete operation");
        }
        return TagAPIHandler.getInstance().delete(this.id);
    }

    public APIResponse merge(ZCRMTag mergetag) throws ZCRMException {
        if (this.id == null || this.id == 0L) {
            throw new ZCRMException("Tag ID MUST NOT be null/empty for Merge operation");
        }
        if (mergetag.id == null || mergetag.id == 0L) {
            throw new ZCRMException("Merge Tag ID MUST NOT be null/empty for Merge operation");
        }
        return TagAPIHandler.getInstance().merge(this.id, mergetag.id);
    }

    public APIResponse update() throws ZCRMException {
        if (this.id == null || this.id == 0L) {
            throw new ZCRMException("Tag ID MUST NOT be null/empty for Update operation");
        }
        if (this.moduleApiName == null || this.moduleApiName.isEmpty()) {
            throw new ZCRMException("Module Api Name MUST NOT be null/empty for Update operation");
        }
        if (this.name == null || this.name.isEmpty()) {
            throw new ZCRMException("Tag Name MUST NOT be null/empty for Update operation");
        }
        return TagAPIHandler.getInstance().update(this);
    }
}

