/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.common;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.exception.ZCRMLogger;
import com.zoho.crm.library.setup.restclient.ZCRMRestClient;
import com.zoho.oauth.client.ZohoOAuth;
import com.zoho.oauth.client.ZohoOAuthClient;
import com.zoho.oauth.common.ZohoOAuthException;
import java.util.HashMap;

public class ZCRMConfigUtil {
    public static HashMap<String, String> configProperties = new HashMap();

    public static void initialize(HashMap<String, String> configurations) throws Exception {
        configProperties.put("apiVersion", "v2");
        configProperties.put("domainSuffix", "com");
        configProperties.put("photoUrl", "https://profile.zoho.com/api/v1/user/");
        configProperties.putAll(configurations);
        if (!configProperties.containsKey("apiBaseUrl") && (configProperties.containsKey("domainSuffix") || configProperties.containsKey("accessType"))) {
            ZCRMConfigUtil.updateConfigsBaseUrl(configProperties.get("domainSuffix"));
        }
        ZohoOAuth.initialize(configurations);
        ZCRMLogger.initLogger();
        ZCRMLogger.logInfo("Java Client Library configuration properties : " + configProperties);
    }

    public static void updateConfigsBaseUrl(String location) {
        String apiBaseUrl = "apiBaseUrl";
        String accessType = ZCRMConfigUtil.getAccessType();
        String domain = APIConstants.ACCESS_TYPES.containsKey(accessType) ? APIConstants.ACCESS_TYPES.get(accessType) : APIConstants.ACCESS_TYPES.get("Production");
        switch (location) {
            case "eu": {
                ZCRMConfigUtil.setConfigValue(apiBaseUrl, "https://" + domain + ".zohoapis.eu");
                break;
            }
            case "cn": {
                ZCRMConfigUtil.setConfigValue(apiBaseUrl, "https://" + domain + ".zohoapis.com.cn");
                break;
            }
            default: {
                ZCRMConfigUtil.setConfigValue(apiBaseUrl, "https://" + domain + ".zohoapis.com");
            }
        }
    }

    public static void setConfigValue(String config, String value) {
        configProperties.put(config, value);
    }

    public static String getAccessToken() throws ZohoOAuthException, ZCRMException {
        String userMailId = ZCRMRestClient.getCurrentUserEmail();
        if (userMailId == null && configProperties.get("currentUserEmail") == null) {
            throw new ZCRMException("Current user should be set in ZCRMRestClient or in the configurations map ");
        }
        if (userMailId == null) {
            userMailId = configProperties.get("currentUserEmail");
        }
        ZohoOAuthClient cli = ZohoOAuthClient.getInstance();
        return cli.getAccessToken(userMailId);
    }

    public static String getConfigValue(String config) {
        return configProperties.get(config);
    }

    public static String getApiBaseURL() {
        return ZCRMConfigUtil.getConfigValue("apiBaseUrl");
    }

    public static String getApiVersion() {
        return ZCRMConfigUtil.getConfigValue("apiVersion");
    }

    public static HashMap getAllConfigs() {
        return configProperties;
    }

    public static String getAccessType() {
        return ZCRMConfigUtil.getConfigValue("accessType");
    }

    public static String getPhotoUrl() {
        return ZCRMConfigUtil.getConfigValue("photoUrl");
    }
}

