/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.api.handler;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.api.APIRequest;
import com.zoho.crm.library.api.handler.CommonAPIHandler;
import com.zoho.crm.library.api.response.APIResponse;
import com.zoho.crm.library.api.response.BulkAPIResponse;
import com.zoho.crm.library.crud.ZCRMVariableGroup;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.exception.ZCRMLogger;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class VariableGroupAPIHandler
extends CommonAPIHandler {
    private ZCRMVariableGroup variable_groups = null;

    public static VariableGroupAPIHandler getInstance() {
        return new VariableGroupAPIHandler();
    }

    public BulkAPIResponse getVariableGroups() throws ZCRMException {
        try {
            this.urlPath = "settings/variable_groups";
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.requestHeaders.put("Content-Type", (Object)"application/json");
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            JSONObject responseJson = response.getResponseJSON();
            JSONArray data = (JSONArray)responseJson.get("variable_groups");
            ArrayList<ZCRMVariableGroup> dataList = new ArrayList<ZCRMVariableGroup>();
            for (int index = 0; index < data.length(); ++index) {
                JSONObject jsonData = data.getJSONObject(index);
                ZCRMVariableGroup variableGroupsIns = ZCRMVariableGroup.getInstance();
                this.getVariableGroupsResAsObj(jsonData, variableGroupsIns);
                dataList.add(variableGroupsIns);
            }
            response.setData(dataList);
            return response;
        }
        catch (ZCRMException exception) {
            ZCRMLogger.logError(exception);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", exception);
        }
    }

    private void getVariableGroupsResAsObj(JSONObject jsonData, ZCRMVariableGroup entityInstance) throws ZCRMException {
        for (String key : jsonData.keySet()) {
            Object value = jsonData.get(key);
            if (JSONObject.NULL.equals(value)) continue;
            if ("id".equals(key)) {
                entityInstance.setId(Long.valueOf(value.toString()));
                continue;
            }
            if ("name".equals(key)) {
                entityInstance.setName((String)value);
                continue;
            }
            if ("api_name".equals(key)) {
                entityInstance.setApiName((String)value);
                continue;
            }
            if ("display_label".equals(key)) {
                entityInstance.setDisplayLabel((String)value);
                continue;
            }
            if (!"description".equals(key)) continue;
            entityInstance.setDescription((String)value);
        }
    }

    public APIResponse getVariableGroup() throws ZCRMException {
        try {
            this.urlPath = "settings/variable_groups/" + this.variable_groups.getId();
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.requestHeaders.put("Content-Type", (Object)"application/json");
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONObject responseJson = response.getResponseJSON();
            JSONArray data = (JSONArray)responseJson.get("variable_groups");
            JSONObject jsonData = data.getJSONObject(0);
            ZCRMVariableGroup variableGroupsIns = ZCRMVariableGroup.getInstance();
            this.getVariableGroupResAsObj(jsonData, variableGroupsIns);
            response.setData(variableGroupsIns);
            return response;
        }
        catch (ZCRMException exception) {
            ZCRMLogger.logError(exception);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", exception);
        }
    }

    private void getVariableGroupResAsObj(JSONObject jsonData, ZCRMVariableGroup entityInstance) throws ZCRMException {
        for (String key : jsonData.keySet()) {
            Object value = jsonData.get(key);
            if (JSONObject.NULL.equals(value)) continue;
            if ("id".equals(key)) {
                entityInstance.setId(Long.valueOf(value.toString()));
                continue;
            }
            if ("name".equals(key)) {
                entityInstance.setName((String)value);
                continue;
            }
            if ("api_name".equals(key)) {
                entityInstance.setApiName((String)value);
                continue;
            }
            if ("display_label".equals(key)) {
                entityInstance.setDisplayLabel((String)value);
                continue;
            }
            if (!"description".equals(key)) continue;
            entityInstance.setDescription((String)value);
        }
    }

    public void setVariableGroups(ZCRMVariableGroup variable_groups) {
        this.variable_groups = variable_groups;
    }

    @Override
    public String getJsonRootKey() {
        return null;
    }
}

