/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.api.handler;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.api.APIRequest;
import com.zoho.crm.library.api.handler.CommonAPIHandler;
import com.zoho.crm.library.api.response.APIResponse;
import com.zoho.crm.library.api.response.BulkAPIResponse;
import com.zoho.crm.library.crud.ZCRMVariable;
import com.zoho.crm.library.crud.ZCRMVariableGroup;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.exception.ZCRMLogger;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class VariableAPIHandler
extends CommonAPIHandler {
    private ZCRMVariable variables = null;

    public static VariableAPIHandler getInstance() {
        return new VariableAPIHandler();
    }

    public BulkAPIResponse getVariables() throws ZCRMException {
        try {
            this.urlPath = "settings/variables";
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.requestHeaders.put("Content-Type", (Object)"application/json");
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            JSONObject responseJson = response.getResponseJSON();
            JSONArray data = (JSONArray)responseJson.get("variables");
            ArrayList<ZCRMVariable> dataList = new ArrayList<ZCRMVariable>();
            for (int index = 0; index < data.length(); ++index) {
                JSONObject jsonData = data.getJSONObject(index);
                ZCRMVariable variablesIns = ZCRMVariable.getInstance();
                this.getVariablesResAsObj(jsonData, variablesIns);
                dataList.add(variablesIns);
            }
            response.setData(dataList);
            return response;
        }
        catch (ZCRMException exception) {
            ZCRMLogger.logError(exception);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", exception);
        }
    }

    private void getVariablesResAsObj(JSONObject jsonData, ZCRMVariable entityInstance) throws ZCRMException {
        for (String key : jsonData.keySet()) {
            Object value = jsonData.get(key);
            if (JSONObject.NULL.equals(value)) continue;
            if ("id".equals(key)) {
                entityInstance.setId(Long.valueOf(value.toString()));
            } else if ("name".equals(key)) {
                entityInstance.setName((String)value);
            } else if ("api_name".equals(key)) {
                entityInstance.setApiName((String)value);
            } else if ("type".equals(key)) {
                entityInstance.setType((String)value);
            } else if ("value".equals(key)) {
                entityInstance.setValue((String)value);
            }
            if ("variable_group".equals(key)) {
                ZCRMVariableGroup ZCRMVariableGroupIns = ZCRMVariableGroup.getInstance();
                JSONObject jobj = (JSONObject)value;
                ZCRMVariableGroupIns.setId(Long.valueOf(jobj.get("id").toString()));
                ZCRMVariableGroupIns.setApiName((String)jobj.get("api_name"));
                entityInstance.setVariableGroup(ZCRMVariableGroupIns);
            }
            if (!"description".equals(key)) continue;
            entityInstance.setDescription((String)value);
        }
    }

    public APIResponse getVariable(String group) throws ZCRMException {
        try {
            this.urlPath = "settings/variables/" + this.variables.getId();
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.requestHeaders.put("Content-Type", (Object)"application/json");
            if (group != null) {
                this.requestQueryParams.put("group", (Object)group);
            }
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONObject responseJson = response.getResponseJSON();
            JSONArray data = (JSONArray)responseJson.get("variables");
            JSONObject jsonData = data.getJSONObject(0);
            ZCRMVariable variablesIns = ZCRMVariable.getInstance();
            this.getVariableResAsObj(jsonData, variablesIns);
            response.setData(variablesIns);
            return response;
        }
        catch (ZCRMException exception) {
            ZCRMLogger.logError(exception);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", exception);
        }
    }

    private void getVariableResAsObj(JSONObject jsonData, ZCRMVariable entityInstance) throws ZCRMException {
        for (String key : jsonData.keySet()) {
            Object value = jsonData.get(key);
            if (JSONObject.NULL.equals(value)) continue;
            if ("id".equals(key)) {
                entityInstance.setId(Long.valueOf(value.toString()));
            } else if ("name".equals(key)) {
                entityInstance.setName((String)value);
            } else if ("api_name".equals(key)) {
                entityInstance.setApiName((String)value);
            } else if ("type".equals(key)) {
                entityInstance.setType((String)value);
            } else if ("value".equals(key)) {
                entityInstance.setValue((String)value);
            }
            if ("variable_group".equals(key)) {
                ZCRMVariableGroup ZCRMVariableGroupIns = ZCRMVariableGroup.getInstance();
                JSONObject jobj = (JSONObject)value;
                ZCRMVariableGroupIns.setId(Long.valueOf(jobj.get("id").toString()));
                ZCRMVariableGroupIns.setApiName((String)jobj.get("api_name"));
                entityInstance.setVariableGroup(ZCRMVariableGroupIns);
            }
            if (!"description".equals(key)) continue;
            entityInstance.setDescription((String)value);
        }
    }

    public BulkAPIResponse createVariables(ArrayList<ZCRMVariable> variable) throws ZCRMException {
        try {
            this.urlPath = "settings/variables";
            this.requestMethod = APIConstants.RequestMethod.POST;
            this.requestHeaders.put("Content-Type", (Object)"application/json");
            JSONObject requestBody = new JSONObject();
            JSONArray dataList = new JSONArray();
            for (int index = 0; index < variable.size(); ++index) {
                JSONObject dataObject = this.convertObjectToJson(variable.get(index));
                dataList.put((Object)dataObject);
            }
            requestBody.put("variables", (Object)dataList);
            this.requestBody = requestBody;
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            return response;
        }
        catch (ZCRMException exception) {
            ZCRMLogger.logError(exception);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", exception);
        }
    }

    private JSONObject convertObjectToJson(ZCRMVariable entityInstance) throws ZCRMException {
        JSONObject variablesJson = new JSONObject();
        if (entityInstance.getId() != null) {
            variablesJson.put("id", (Object)entityInstance.getId());
        }
        if (entityInstance.getName() != null) {
            variablesJson.put("name", (Object)entityInstance.getName());
        }
        if (entityInstance.getApiName() != null) {
            variablesJson.put("api_name", (Object)entityInstance.getApiName());
        }
        if (entityInstance.getType() != null) {
            variablesJson.put("type", (Object)entityInstance.getType());
        }
        if (entityInstance.getValue() != null) {
            variablesJson.put("value", (Object)entityInstance.getValue());
        }
        if (entityInstance.getVariableGroup() != null) {
            JSONObject variableGroupJson = new JSONObject();
            ZCRMVariableGroup variableGroup = entityInstance.getVariableGroup();
            if (variableGroup.getId() != null) {
                variableGroupJson.put("id", (Object)variableGroup.getId());
            }
            if (variableGroup.getApiName() != null) {
                variableGroupJson.put("api_name", (Object)variableGroup.getApiName());
            }
            variablesJson.put("variable_group", (Object)variableGroupJson);
        }
        if (entityInstance.getDescription() != null) {
            variablesJson.put("description", (Object)entityInstance.getDescription());
        }
        return variablesJson;
    }

    public BulkAPIResponse updateVariables(ArrayList<ZCRMVariable> variable) throws ZCRMException {
        try {
            this.urlPath = "settings/variables";
            this.requestMethod = APIConstants.RequestMethod.PUT;
            this.requestHeaders.put("Content-Type", (Object)"application/json");
            JSONObject requestBody = new JSONObject();
            JSONArray dataList = new JSONArray();
            for (int index = 0; index < variable.size(); ++index) {
                JSONObject dataObject = this.convertObjectToJson(variable.get(index));
                dataList.put((Object)dataObject);
            }
            requestBody.put("variables", (Object)dataList);
            this.requestBody = requestBody;
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            return response;
        }
        catch (ZCRMException exception) {
            ZCRMLogger.logError(exception);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", exception);
        }
    }

    public APIResponse updateVariable() throws ZCRMException {
        try {
            this.urlPath = "settings/variables/" + this.variables.getId();
            this.requestMethod = APIConstants.RequestMethod.PUT;
            this.requestHeaders.put("Content-Type", (Object)"application/json");
            JSONObject requestBody = new JSONObject();
            JSONArray dataList = new JSONArray();
            JSONObject dataObject = this.convertObjectToJson(this.variables);
            dataList.put((Object)dataObject);
            requestBody.put("variables", (Object)dataList);
            this.requestBody = requestBody;
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            return response;
        }
        catch (ZCRMException exception) {
            ZCRMLogger.logError(exception);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", exception);
        }
    }

    public APIResponse deleteVariable() throws ZCRMException {
        try {
            this.urlPath = "settings/variables/" + this.variables.getId();
            this.requestMethod = APIConstants.RequestMethod.DELETE;
            this.requestHeaders.put("Content-Type", (Object)"application/json");
            JSONObject requestBody = new JSONObject();
            JSONArray dataList = new JSONArray();
            JSONObject dataObject = this.convertObjectToJson(this.variables);
            dataList.put((Object)dataObject);
            requestBody.put("variables", (Object)dataList);
            this.requestBody = requestBody;
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            return response;
        }
        catch (ZCRMException exception) {
            ZCRMLogger.logError(exception);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", exception);
        }
    }

    public void setVariables(ZCRMVariable variables) {
        this.variables = variables;
    }

    @Override
    public String getJsonRootKey() {
        return "variables";
    }
}

