/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.api.handler;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.api.APIRequest;
import com.zoho.crm.library.api.handler.APIHandler;
import com.zoho.crm.library.api.handler.CommonAPIHandler;
import com.zoho.crm.library.api.response.APIResponse;
import com.zoho.crm.library.api.response.BulkAPIResponse;
import com.zoho.crm.library.common.NullableJSONObject;
import com.zoho.crm.library.crud.ZCRMModule;
import com.zoho.crm.library.crud.ZCRMModuleRelation;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.exception.ZCRMLogger;
import com.zoho.crm.library.setup.users.ZCRMProfile;
import com.zoho.crm.library.setup.users.ZCRMUser;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MetaDataAPIHandler
extends CommonAPIHandler
implements APIHandler {
    private MetaDataAPIHandler() {
    }

    public static MetaDataAPIHandler getInstance() {
        return new MetaDataAPIHandler();
    }

    public BulkAPIResponse getAllModules(String modifiedSince) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "settings/modules";
            this.requestHeaders.put("If-Modified-Since", (Object)modifiedSince);
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            NullableJSONObject responseJSON = new NullableJSONObject(response.getResponseJSON());
            ArrayList<ZCRMModule> allModules = new ArrayList<ZCRMModule>();
            JSONArray modulesArray = responseJSON.optJSONArray(this.getJsonRootKey(), new JSONArray());
            for (int index = 0; index < modulesArray.length(); ++index) {
                JSONObject moduleDetails = modulesArray.getJSONObject(index);
                allModules.add(this.getZCRMModule(moduleDetails));
            }
            response.setData(allModules);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse getModule(String apiName) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "settings/modules/" + apiName;
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONArray modulesArray = response.getResponseJSON().getJSONArray(this.getJsonRootKey());
            JSONObject moduleDetails = modulesArray.getJSONObject(0);
            response.setData(this.getZCRMModule(moduleDetails));
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    private ZCRMModule getZCRMModule(JSONObject moduleJson) throws JSONException {
        NullableJSONObject moduleDetails = new NullableJSONObject(moduleJson);
        ZCRMModule module = ZCRMModule.getInstance(moduleDetails.getString("api_name"));
        module.setId(Long.parseLong(moduleDetails.getString("id")));
        module.setSystemName(moduleDetails.getString("module_name"));
        module.setSingularLabel(moduleDetails.getString("singular_label"));
        module.setPluralLabel(moduleDetails.getString("plural_label"));
        module.setCreatable(moduleDetails.getBoolean("creatable"));
        module.setViewable(moduleDetails.getBoolean("viewable"));
        module.setEditable(moduleDetails.getBoolean("editable"));
        module.setConvertible(moduleDetails.getBoolean("convertable"));
        module.setDeletable(moduleDetails.getBoolean("deletable"));
        module.setGeneratedType(moduleDetails.optString("generated_type"));
        module.setVisibility(moduleDetails.getInt("visibility"));
        JSONArray accessibleProfilesArray = moduleDetails.getJSONArray("profiles");
        for (int index = 0; index < accessibleProfilesArray.length(); ++index) {
            JSONObject profileObj = accessibleProfilesArray.getJSONObject(index);
            ZCRMProfile profile = null;
            profile = profileObj.has("name") ? ZCRMProfile.getInstance(Long.parseLong(profileObj.getString("id")), profileObj.getString("name")) : ZCRMProfile.getInstance(Long.parseLong(profileObj.getString("id")));
            module.addAccessibleProfile(profile);
        }
        if (!moduleDetails.isNull("modified_by")) {
            JSONObject modifiedByObj = moduleDetails.getJSONObject("modified_by");
            ZCRMUser modifiedBy = ZCRMUser.getInstance(Long.parseLong(modifiedByObj.getString("id")), modifiedByObj.getString("name"));
            module.setModifiedBy(modifiedBy);
            module.setModifiedTime(moduleDetails.getString("modified_time"));
        }
        if (moduleDetails.has("business_card_fields")) {
            ArrayList<String> bcFields = new ArrayList<String>();
            JSONArray bcFieldsArray = moduleDetails.getJSONArray("business_card_fields");
            for (int index = 0; index < bcFieldsArray.length(); ++index) {
                bcFields.add(bcFieldsArray.getString(index));
            }
            module.setBusinessCardFields(bcFields);
        }
        return module;
    }

    private void setRelatedListProperties(ZCRMModuleRelation relatedList, JSONObject relatedListDetails) throws JSONException {
        relatedList.setId(Long.parseLong(relatedListDetails.getString("id")));
        relatedList.setVisible(relatedListDetails.getBoolean("visible"));
        relatedList.setLabel(relatedListDetails.getString("display_label"));
    }

    @Override
    public String getJsonRootKey() {
        return "modules";
    }
}

