/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.util;

import com.zoho.crm.api.Initializer;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.CommonAPIHandler;
import com.zoho.crm.api.util.Converter;
import com.zoho.crm.api.util.StreamWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FormDataConverter
extends Converter {
    private HashMap<String, ArrayList<Object>> uniqueValuesMap = new HashMap();

    public FormDataConverter(CommonAPIHandler commonAPIHandler) {
        super(commonAPIHandler);
    }

    @Override
    public Object formRequest(Object requestInstance, String pack, Integer instanceNumber, JSONObject classMemberDetail) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, SDKException {
        JSONObject classDetail = (JSONObject)Initializer.jsonDetails.get(pack);
        HashMap<String, Object> request = new HashMap<String, Object>();
        for (String memberName : classDetail.keySet()) {
            Object modification = null;
            JSONObject memberDetail = (JSONObject)classDetail.get(memberName);
            if (memberDetail.has("read-only") && memberDetail.getBoolean("read-only") || !memberDetail.has("name")) continue;
            try {
                Method method = requestInstance.getClass().getMethod("isKeyModified", String.class);
                modification = method.invoke(requestInstance, memberDetail.getString("name"));
            }
            catch (NoSuchMethodException | InvocationTargetException ex) {
                throw new SDKException("Exception in calling isKeyModified : ", ex);
            }
            if ((modification == null || (Integer)modification == 0) && memberDetail.has("required") && memberDetail.getBoolean("required")) {
                throw new SDKException("MANDATORY VALUE ERROR", "Value missing or null for mandatory key(s) :" + memberName);
            }
            Field field = requestInstance.getClass().getDeclaredField(memberName);
            field.setAccessible(true);
            Object fieldValue = field.get(requestInstance);
            if (modification == null || (Integer)modification == 0 || !this.valueChecker(requestInstance.getClass().getSimpleName(), memberName, memberDetail, fieldValue, this.uniqueValuesMap, instanceNumber)) continue;
            String keyName = (String)memberDetail.get("name");
            String type = (String)memberDetail.get("type");
            if (type.equalsIgnoreCase("java.util.List")) {
                request.put(keyName, this.setJSONArray(fieldValue, memberDetail));
                continue;
            }
            if (type.equalsIgnoreCase("java.util.Map")) {
                request.put(keyName, this.setJSONObject(fieldValue, memberDetail));
                continue;
            }
            if (memberDetail.has("structure_name")) {
                request.put(keyName, this.formRequest(fieldValue, memberDetail.getString("structure_name"), 1, memberDetail));
                continue;
            }
            request.put(keyName, fieldValue);
        }
        return request;
    }

    @Override
    public void appendToRequest(HttpEntityEnclosingRequestBase requestBase, Object requestObject) throws Exception {
        MultipartEntityBuilder multipartEntity = MultipartEntityBuilder.create();
        multipartEntity.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        if (requestObject instanceof HashMap) {
            this.addFileBody(requestObject, multipartEntity);
        }
        requestBase.setEntity(multipartEntity.build());
    }

    private void addFileBody(Object requestObject, MultipartEntityBuilder multipartEntity) throws IOException {
        HashMap requestObjectMap = (HashMap)requestObject;
        for (Map.Entry requestData : requestObjectMap.entrySet()) {
            if (requestData.getValue() instanceof JSONArray) {
                JSONArray keysDetail = (JSONArray)requestData.getValue();
                for (int keyIndex = 0; keyIndex < keysDetail.length(); ++keyIndex) {
                    int bytesRead;
                    Object fileObject = keysDetail.get(keyIndex);
                    if (!(fileObject instanceof StreamWrapper)) continue;
                    StreamWrapper streamWrapper = (StreamWrapper)fileObject;
                    byte[] buffer = new byte[8192];
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    while ((bytesRead = streamWrapper.getStream().read(buffer)) != -1) {
                        output.write(buffer, 0, bytesRead);
                    }
                    multipartEntity.addPart((String)requestData.getKey(), (ContentBody)new ByteArrayBody(output.toByteArray(), streamWrapper.getName()));
                }
                continue;
            }
            if (requestData.getValue() instanceof StreamWrapper) {
                int bytesRead;
                StreamWrapper streamWrapper = (StreamWrapper)requestData.getValue();
                byte[] buffer = new byte[8192];
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                while ((bytesRead = streamWrapper.getStream().read(buffer)) != -1) {
                    output.write(buffer, 0, bytesRead);
                }
                multipartEntity.addPart((String)requestData.getKey(), (ContentBody)new ByteArrayBody(output.toByteArray(), streamWrapper.getName()));
                continue;
            }
            multipartEntity.addPart((String)requestData.getKey(), (ContentBody)requestData.getValue());
        }
    }

    private JSONObject setJSONObject(Object fieldValue, JSONObject memberDetail) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, JSONException, SDKException {
        JSONObject jsonObject = new JSONObject();
        HashMap requestObject = (HashMap)fieldValue;
        if (memberDetail == null) {
            for (Object key : requestObject.keySet()) {
                jsonObject.put((String)key, this.redirectorForObjectToJSON(requestObject.get(key)));
            }
        } else {
            JSONArray keysDetail = memberDetail.getJSONArray("keys");
            for (int keyIndex = 0; keyIndex < keysDetail.length(); ++keyIndex) {
                JSONObject keyDetail = keysDetail.getJSONObject(keyIndex);
                String keyName = keyDetail.getString("name");
                Object keyValue = null;
                if (!requestObject.containsKey(keyName) || requestObject.get(keyName) == null) continue;
                if (keyDetail.has("structure_name")) {
                    keyValue = this.formRequest(requestObject.get(keyName), keyDetail.getString("structure_name"), 1, memberDetail);
                    jsonObject.put(keyName, keyValue);
                    continue;
                }
                keyValue = requestObject.get(keyName);
                jsonObject.put(keyName, this.redirectorForObjectToJSON(keyValue));
            }
        }
        return jsonObject;
    }

    private JSONArray setJSONArray(Object fieldValue, JSONObject memberDetail) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, SDKException {
        JSONArray jsonArray = new JSONArray();
        ArrayList requestObjects = (ArrayList)fieldValue;
        if (memberDetail == null) {
            for (Object request : requestObjects) {
                jsonArray.put(this.redirectorForObjectToJSON(request));
            }
        } else if (memberDetail.has("structure_name")) {
            int instanceCount = 0;
            String pack = memberDetail.getString("structure_name");
            for (Object request : requestObjects) {
                jsonArray.put(this.formRequest(request, pack, ++instanceCount, memberDetail));
            }
        } else {
            for (Object request : requestObjects) {
                jsonArray.put(this.redirectorForObjectToJSON(request));
            }
        }
        return jsonArray;
    }

    private Object redirectorForObjectToJSON(Object request) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, JSONException, SDKException {
        if (request instanceof List) {
            return this.setJSONArray(request, null);
        }
        if (request instanceof Map) {
            return this.setJSONObject(request, null);
        }
        return request;
    }

    @Override
    public Object getWrappedResponse(Object response, String pack) throws Exception {
        return null;
    }

    @Override
    public Object getResponse(Object response, String pack) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException, SecurityException, UnsupportedOperationException, IOException {
        return null;
    }
}

