/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api;

import com.zoho.api.authenticator.Token;
import com.zoho.api.authenticator.store.TokenStore;
import com.zoho.api.logger.Logger;
import com.zoho.api.logger.SDKLogger;
import com.zoho.crm.api.RequestProxy;
import com.zoho.crm.api.SDKConfig;
import com.zoho.crm.api.UserSignature;
import com.zoho.crm.api.dc.DataCenter;
import com.zoho.crm.api.exception.SDKException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class Initializer {
    private static final Logger LOGGER = Logger.getLogger(SDKLogger.class.getName());
    private static final ThreadLocal<Initializer> LOCAL = new ThreadLocal();
    private static Initializer initializer;
    private DataCenter.Environment environment;
    private TokenStore store;
    private UserSignature user;
    private Token token;
    public static JSONObject jsonDetails;
    private String resourcePath;
    private RequestProxy requestProxy;
    private SDKConfig sdkConfig;

    public static void initialize(UserSignature user, DataCenter.Environment environment, Token token, TokenStore store, SDKConfig sdkConfig, String resourcePath) throws SDKException {
        Initializer.initialize(user, environment, token, store, sdkConfig, resourcePath, null, null);
    }

    public static void initialize(UserSignature user, DataCenter.Environment environment, Token token, TokenStore store, SDKConfig sdkConfig, String resourcePath, RequestProxy proxy) throws SDKException {
        Initializer.initialize(user, environment, token, store, sdkConfig, resourcePath, null, proxy);
    }

    public static void initialize(UserSignature user, DataCenter.Environment environment, Token token, TokenStore store, SDKConfig sdkConfig, String resourcePath, com.zoho.api.logger.Logger logger) throws SDKException {
        Initializer.initialize(user, environment, token, store, sdkConfig, resourcePath, logger, null);
    }

    public static void initialize(UserSignature user, DataCenter.Environment environment, Token token, TokenStore store, SDKConfig sdkConfig, String resourcePath, com.zoho.api.logger.Logger logger, RequestProxy proxy) throws SDKException {
        try {
            if (user == null) {
                throw new SDKException("INITIALIZATION ERROR", "UserSignature MUST NOT be null.");
            }
            if (environment == null) {
                throw new SDKException("INITIALIZATION ERROR", "Environment MUST NOT be null.");
            }
            if (token == null) {
                throw new SDKException("INITIALIZATION ERROR", "Token MUST NOT be null.");
            }
            if (store == null) {
                throw new SDKException("INITIALIZATION ERROR", "Store MUST NOT be null.");
            }
            if (sdkConfig == null) {
                throw new SDKException("INITIALIZATION ERROR", "sdkConfig MUST NOT be null.");
            }
            if (resourcePath == null || resourcePath.isEmpty()) {
                throw new SDKException("INITIALIZATION ERROR", "Resource Path MUST NOT be null/empty.");
            }
            if (logger == null) {
                String filePath = System.getProperty("user.dir") + File.separator + "SDKLogs.log";
                logger = com.zoho.api.logger.Logger.getInstance(Logger.Levels.INFO, filePath);
            }
            SDKLogger.initialize(logger);
            try {
                jsonDetails = Initializer.getJSONDetails();
            }
            catch (IOException e) {
                throw new SDKException("ERROR IN READING JSONDETAILS FILE", e);
            }
            initializer = new Initializer();
            Initializer.initializer.user = user;
            Initializer.initializer.environment = environment;
            Initializer.initializer.token = token;
            Initializer.initializer.store = store;
            Initializer.initializer.sdkConfig = sdkConfig;
            Initializer.initializer.resourcePath = resourcePath;
            Initializer.initializer.requestProxy = proxy;
            LOGGER.log(Level.INFO, "Initialization successful ".concat(initializer.toString()));
        }
        catch (SDKException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SDKException("Exception in initialization : ", e);
        }
    }

    private static JSONObject getJSONDetails() throws IOException, SDKException {
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        String fileContent = "";
        try {
            String line;
            is = Initializer.class.getResourceAsStream("/resources/JSONDetails.json");
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                fileContent = fileContent + line;
            }
        }
        catch (Exception e) {
            throw new SDKException("Exception in loading JSONDetails : ", e);
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return new JSONObject(fileContent);
    }

    public static JSONObject getJSON(String filePath) throws IOException {
        return new JSONObject(new String(Files.readAllBytes(Paths.get(filePath, new String[0]))));
    }

    public static Initializer getInitializer() {
        if (LOCAL.get() != null) {
            return LOCAL.get();
        }
        return initializer;
    }

    public static void switchUser(UserSignature user, DataCenter.Environment environment, Token token, SDKConfig sdkConfig) throws SDKException {
        Initializer.switchUser(user, environment, token, sdkConfig, null);
    }

    public static void switchUser(UserSignature user, DataCenter.Environment environment, Token token, SDKConfig sdkConfig, RequestProxy proxy) throws SDKException {
        if (user == null) {
            throw new SDKException("SWITCH USER ERROR", "UserSignature MUST NOT be null.");
        }
        if (environment == null) {
            throw new SDKException("SWITCH USER ERROR", "Environment MUST NOT be null.");
        }
        if (token == null) {
            throw new SDKException("SWITCH USER ERROR", "Token MUST NOT be null.");
        }
        if (sdkConfig == null) {
            throw new SDKException("SWITCH USER ERROR", "sdkConfig MUST NOT be null.");
        }
        Initializer initializer = new Initializer();
        initializer.user = user;
        initializer.environment = environment;
        initializer.token = token;
        initializer.store = Initializer.initializer.store;
        initializer.sdkConfig = sdkConfig;
        initializer.resourcePath = Initializer.initializer.resourcePath;
        initializer.requestProxy = proxy;
        LOCAL.set(initializer);
        LOGGER.log(Level.INFO, "Initialization switched ".concat(initializer.toString()));
    }

    public DataCenter.Environment getEnvironment() {
        return this.environment;
    }

    public TokenStore getStore() {
        return this.store;
    }

    public UserSignature getUser() {
        return this.user;
    }

    public Token getToken() {
        return this.token;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public RequestProxy getRequestProxy() {
        return this.requestProxy;
    }

    public SDKConfig getSDKConfig() {
        return this.sdkConfig;
    }

    protected void finalize() throws Throwable {
        LOCAL.remove();
    }

    public String toString() {
        return "for Email Id : ".concat(Initializer.getInitializer().getUser().getEmail()).concat(" in Environment : ").concat(Initializer.getInitializer().getEnvironment().getUrl()).concat(".");
    }
}

