/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api;

import com.zoho.crm.api.Header;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.DataTypeConverter;
import java.util.HashMap;

public class HeaderMap {
    private HashMap<String, String> headerMap = new HashMap();

    public HashMap<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public <T> void add(Header<T> header, T value) throws SDKException {
        if (header == null) {
            throw new SDKException("NULL HEADER ERROR", "Header<T> Instance MUST NOT be null");
        }
        String headerName = header.getName();
        if (headerName == null) {
            throw new SDKException("NULL HEADER NAME ERROR", "Header Name MUST NOT be null");
        }
        if (value == null) {
            throw new SDKException("NULL HEADER ERROR", headerName + " MUST NOT be null");
        }
        String headerValue = null;
        try {
            headerValue = DataTypeConverter.postConvert(value, value.getClass().getName()).toString();
        }
        catch (Exception e) {
            headerValue = value.toString();
        }
        if (this.headerMap.containsKey(headerName) && !this.headerMap.get(headerName).isEmpty()) {
            String existingHeaderValue = this.headerMap.get(headerName);
            existingHeaderValue = existingHeaderValue + "," + headerValue;
            this.headerMap.put(headerName, existingHeaderValue);
        } else {
            this.headerMap.put(headerName, headerValue);
        }
    }
}

