/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.oauth.client;

import com.zoho.oauth.client.ZohoOAuth;
import com.zoho.oauth.client.ZohoPersistenceHandler;
import com.zoho.oauth.common.ZohoHTTPConnector;
import com.zoho.oauth.common.ZohoOAuthConstants;
import com.zoho.oauth.common.ZohoOAuthException;
import com.zoho.oauth.contract.ZohoOAuthParams;
import com.zoho.oauth.contract.ZohoOAuthTokens;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class ZohoOAuthClient {
    protected static final Logger LOGGER = Logger.getLogger(ZohoOAuthClient.class.getName());
    private static ZohoOAuthClient client;
    private ZohoOAuthParams params;

    private ZohoOAuthClient(ZohoOAuthParams params) {
        this.params = params;
    }

    public static ZohoOAuthClient getInstance(ZohoOAuthParams params) {
        if (client == null) {
            client = new ZohoOAuthClient(params);
        }
        return client;
    }

    public static ZohoOAuthClient getInstance() {
        return client;
    }

    public static void initialize() throws IOException, ZohoOAuthException {
        ZohoOAuth.initialize();
    }

    public String getAccessToken(String userMailId) throws ZohoOAuthException {
        ZohoOAuthTokens tokens;
        ZohoPersistenceHandler persistence = ZohoOAuth.getPersistenceHandlerInstance();
        try {
            tokens = persistence.getOAuthTokens(userMailId);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Exception while retrieving tokens from persistence - " + ex);
            throw new ZohoOAuthException(ex);
        }
        try {
            return tokens.getAccessToken();
        }
        catch (ZohoOAuthException ex) {
            LOGGER.log(Level.INFO, "Access Token has expired. Hence refreshing.");
            tokens = this.refreshAccessToken(tokens.getRefreshToken(), userMailId);
            return tokens.getAccessToken();
        }
    }

    public ZohoOAuthTokens generateAccessToken(String grantToken) throws ZohoOAuthException {
        if (grantToken == null) {
            throw new ZohoOAuthException("Grant Token is not provided.");
        }
        try {
            ZohoHTTPConnector conn = this.getZohoConnector(ZohoOAuth.getTokenURL());
            conn.addParam("grant_type", "authorization_code");
            conn.addParam("code", grantToken);
            String resp = conn.post();
            JSONObject responseJSON = new JSONObject(resp);
            if (responseJSON.has("access_token")) {
                ZohoOAuthTokens tokens = this.getTokensFromJSON(responseJSON);
                tokens.setUserMailId(this.getUserEmailId(tokens.getAccessToken()));
                ZohoOAuth.getPersistenceHandlerInstance().saveOAuthData(tokens);
                return tokens;
            }
            throw new ZohoOAuthException("Exception while fetching access token from grant token - " + resp);
        }
        catch (Exception ex) {
            throw new ZohoOAuthException(ex);
        }
    }

    private String getUserEmailId(String accessToken) throws IOException, JSONException, NoSuchAlgorithmException {
        ZohoHTTPConnector conn = new ZohoHTTPConnector();
        conn.setUrl(ZohoOAuth.getUserInfoURL());
        conn.addHeadder("Authorization", ZohoOAuthConstants.authHeaderPrefix + accessToken);
        String response = conn.get();
        JSONObject responseJSON = new JSONObject(response);
        return responseJSON.getString("Email");
    }

    private ZohoOAuthTokens refreshAccessToken(String refreshToken, String userMailId) throws ZohoOAuthException {
        if (refreshToken == null) {
            throw new ZohoOAuthException("Refresh token is not provided.");
        }
        try {
            ZohoHTTPConnector conn = this.getZohoConnector(ZohoOAuth.getRefreshTokenURL());
            conn.addParam("grant_type", "refresh_token");
            conn.addParam("refresh_token", refreshToken);
            String resp = conn.post();
            JSONObject responseJSON = new JSONObject(resp);
            if (responseJSON.has("access_token")) {
                ZohoOAuthTokens tokens = this.getTokensFromJSON(responseJSON);
                tokens.setRefreshToken(refreshToken);
                tokens.setUserMailId(userMailId);
                ZohoOAuth.getPersistenceHandlerInstance().saveOAuthData(tokens);
                return tokens;
            }
            throw new ZohoOAuthException("Exception while fetching access token from refresh token - " + resp);
        }
        catch (Exception ex) {
            throw new ZohoOAuthException(ex);
        }
    }

    private ZohoHTTPConnector getZohoConnector(String url) {
        ZohoHTTPConnector conn = new ZohoHTTPConnector();
        conn.setUrl(url);
        conn.addParam("client_id", this.params.getClientId());
        conn.addParam("client_secret", this.params.getClientSecret());
        conn.addParam("redirect_uri", this.params.getRedirectURL());
        return conn;
    }

    private ZohoOAuthTokens getTokensFromJSON(JSONObject response) throws JSONException {
        ZohoOAuthTokens tokens = new ZohoOAuthTokens();
        Integer expiresIn = (Integer)response.get("expires_in");
        tokens.setExpiryTime(System.currentTimeMillis() + (long)expiresIn.intValue());
        String accessToken = (String)response.get("access_token");
        tokens.setAccessToken(accessToken);
        if (response.has("refresh_token")) {
            String refreshToken = (String)response.get("refresh_token");
            tokens.setRefreshToken(refreshToken);
        }
        return tokens;
    }
}

