/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.crud;

import com.zoho.crm.library.api.handler.RelatedListAPIHandler;
import com.zoho.crm.library.api.response.APIResponse;
import com.zoho.crm.library.api.response.FileAPIResponse;
import com.zoho.crm.library.common.ZCRMEntity;
import com.zoho.crm.library.crud.ZCRMAttachment;
import com.zoho.crm.library.crud.ZCRMModuleRelation;
import com.zoho.crm.library.crud.ZCRMRecord;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.setup.users.ZCRMUser;
import java.util.ArrayList;

public class ZCRMNote
extends ZCRMEntity {
    private Long id;
    private String title;
    private String content;
    private ZCRMRecord parentRecord;
    private ZCRMUser notesOwner;
    private ZCRMUser createdBy;
    private String createdTime;
    private ZCRMUser modifiedBy;
    private String modifiedTime;
    private ArrayList<ZCRMAttachment> attachments = new ArrayList();

    private ZCRMNote(ZCRMRecord parentRecord, Long noteId) {
        this.parentRecord = parentRecord;
        this.id = noteId;
    }

    public ZCRMNote(ZCRMRecord parentRecord) {
        this.parentRecord = parentRecord;
    }

    public static ZCRMNote getInstance(ZCRMRecord parentRecord, Long noteId) {
        return new ZCRMNote(parentRecord, noteId);
    }

    public ZCRMRecord getParentRecord() {
        return this.parentRecord;
    }

    public void setId(Long noteId) {
        this.id = noteId;
    }

    public Long getId() {
        return this.id;
    }

    public void setTitle(String noteTitle) {
        this.title = noteTitle;
    }

    public String getTitle() {
        return this.title;
    }

    public void setContent(String noteContent) {
        this.content = noteContent;
    }

    public String getContent() {
        return this.content;
    }

    public void setOwner(ZCRMUser notesOwner) {
        this.notesOwner = notesOwner;
    }

    public ZCRMUser getNotesOwner() {
        return this.notesOwner;
    }

    public void setCreatedBy(ZCRMUser createdBy) {
        this.createdBy = createdBy;
    }

    public ZCRMUser getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setModifiedBy(ZCRMUser modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public ZCRMUser getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedTime(String modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public String getModifiedTime() {
        return this.modifiedTime;
    }

    public void addAttachment(ZCRMAttachment attachment) {
        this.attachments.add(attachment);
    }

    public ArrayList<ZCRMAttachment> getAttachments() {
        return this.attachments;
    }

    public APIResponse uploadAttachment(String filePath) throws ZCRMException {
        return RelatedListAPIHandler.getInstance(ZCRMRecord.getInstance("Notes", this.id), ZCRMModuleRelation.getInstance("Notes", "Attachments")).uploadAttachment(filePath);
    }

    public FileAPIResponse downloadAttachment(Long attachmentId) throws ZCRMException {
        return RelatedListAPIHandler.getInstance(ZCRMRecord.getInstance("Notes", this.id), ZCRMModuleRelation.getInstance("Notes", "Attachments")).downloadAttachment(attachmentId);
    }

    public APIResponse deleteAttachment(Long attachmentId) throws ZCRMException {
        return RelatedListAPIHandler.getInstance(ZCRMRecord.getInstance("Notes", this.id), ZCRMModuleRelation.getInstance("Notes", "Attachments")).deleteAttachment(attachmentId);
    }
}

