/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.api.response;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.api.response.CommonAPIResponse;
import com.zoho.crm.library.common.ZCRMEntity;
import com.zoho.crm.library.exception.ZCRMException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BulkAPIResponse
extends CommonAPIResponse {
    private List<? extends ZCRMEntity> bulkData;
    private ArrayList<EntityResponse> bulkEntitiesResponse;

    public BulkAPIResponse() {
    }

    public BulkAPIResponse(HttpResponse response, String responseJSONRootKey) throws IOException, JSONException, ZCRMException {
        super(response, responseJSONRootKey);
    }

    public void setData(List<? extends ZCRMEntity> data) {
        this.bulkData = data;
    }

    public List<? extends ZCRMEntity> getData() {
        return this.bulkData;
    }

    @Override
    protected void processDataResponse() throws JSONException {
        this.bulkEntitiesResponse = new ArrayList();
        if (this.responseJSON.has(this.responseJSONRootKey)) {
            JSONArray recordsArray = this.responseJSON.getJSONArray(this.responseJSONRootKey);
            for (int i = 0; i < recordsArray.length(); ++i) {
                JSONObject recordJSON = recordsArray.getJSONObject(i);
                if (!recordJSON.has("status") || !recordJSON.has("message")) continue;
                EntityResponse individualResponse = new EntityResponse(recordJSON);
                this.bulkEntitiesResponse.add(individualResponse);
            }
        }
    }

    @Override
    protected void handleForFaultyResponses() throws JSONException, ZCRMException {
        if (this.httpStatusCode != APIConstants.ResponseCode.NO_CONTENT && this.httpStatusCode != APIConstants.ResponseCode.NOT_MODIFIED) {
            throw new ZCRMException(this.responseJSON.getString("code"), this.responseJSON.getString("message"));
        }
        this.responseJSON = new JSONObject();
        this.bulkData = new ArrayList<ZCRMEntity>();
    }

    public ArrayList<EntityResponse> getEntityResponses() {
        return this.bulkEntitiesResponse;
    }

    public static class EntityResponse {
        private JSONObject responseJSON;
        private ZCRMEntity data;
        private String status;
        private String message;
        private String code;
        private JSONObject errorDetails;
        private HashMap<String, String> upsertedDetails = new HashMap();

        public EntityResponse(JSONObject entityResponseJSON) throws JSONException {
            this.responseJSON = entityResponseJSON;
            this.status = entityResponseJSON.getString("status");
            this.code = entityResponseJSON.getString("code");
            this.message = entityResponseJSON.getString("message");
            if (this.responseJSON.has("details") && "error".equals(this.status)) {
                this.errorDetails = this.responseJSON.getJSONObject("details");
            }
            if (entityResponseJSON.has("action")) {
                this.upsertedDetails.put("action", entityResponseJSON.getString("action"));
            }
            if (entityResponseJSON.has("duplicate_field")) {
                this.upsertedDetails.put("duplicate_field", entityResponseJSON.optString("duplicate_field"));
            }
        }

        public void setData(ZCRMEntity entity) {
            this.data = entity;
        }

        public ZCRMEntity getData() {
            return this.data;
        }

        public JSONObject getResponseJSON() {
            return this.responseJSON;
        }

        public String getStatus() {
            return this.status;
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public HashMap<String, String> getUpsertedDetails() {
            return this.upsertedDetails;
        }

        public JSONObject getErrorDetails() {
            return this.errorDetails;
        }
    }
}

