/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.api.response;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.api.response.CommonAPIResponse;
import com.zoho.crm.library.common.ZCRMEntity;
import com.zoho.crm.library.exception.ZCRMException;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class APIResponse
extends CommonAPIResponse {
    protected ZCRMEntity data;
    protected String message;

    public APIResponse() {
    }

    public APIResponse(HttpResponse response, String responseJSONRootKey) throws JSONException, ZCRMException, IOException {
        super(response, responseJSONRootKey);
    }

    public void setData(ZCRMEntity data) {
        this.data = data;
    }

    public ZCRMEntity getData() {
        return this.data;
    }

    @Override
    protected void processDataResponse() throws JSONException, ZCRMException {
        JSONObject msgJSON = this.responseJSON;
        if (this.responseJSON.has(this.responseJSONRootKey)) {
            JSONArray recordsArray = this.responseJSON.getJSONArray(this.responseJSONRootKey);
            msgJSON = recordsArray.getJSONObject(0);
        }
        if (this.responseJSON.has("tags")) {
            JSONArray tagsArray = this.responseJSON.getJSONArray("tags");
            msgJSON = tagsArray.getJSONObject(0);
        }
        if (msgJSON.has("message")) {
            this.message = msgJSON.getString("message");
            if (msgJSON.has("status")) {
                this.status = msgJSON.getString("status");
                if ("error".equals(this.status)) {
                    if (msgJSON.has("details")) {
                        throw new ZCRMException(msgJSON.getString("code"), this.message, msgJSON.getJSONObject("details"));
                    }
                    throw new ZCRMException(msgJSON.getString("code"), this.message);
                }
            }
        }
    }

    @Override
    protected void handleForFaultyResponses() throws JSONException, ZCRMException {
        if (this.httpStatusCode == APIConstants.ResponseCode.NO_CONTENT) {
            throw new ZCRMException("INVALID_DATA", "The given id seems to be invalid.");
        }
        throw new ZCRMException(this.responseJSON.getString("code"), this.responseJSON.getString("message"));
    }

    public String getMessage() {
        return this.message;
    }
}

