/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.api.handler;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.api.APIRequest;
import com.zoho.crm.library.api.handler.APIHandler;
import com.zoho.crm.library.api.handler.CommonAPIHandler;
import com.zoho.crm.library.api.response.APIResponse;
import com.zoho.crm.library.api.response.BulkAPIResponse;
import com.zoho.crm.library.common.NullableJSONObject;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.exception.ZCRMLogger;
import com.zoho.crm.library.setup.metadata.ZCRMOrganization;
import com.zoho.crm.library.setup.users.ZCRMProfile;
import com.zoho.crm.library.setup.users.ZCRMRole;
import com.zoho.crm.library.setup.users.ZCRMUser;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OrganizationAPIHandler
extends CommonAPIHandler
implements APIHandler {
    private OrganizationAPIHandler() {
    }

    public static OrganizationAPIHandler getInstance() {
        return new OrganizationAPIHandler();
    }

    public APIResponse getOrganizationDetails() throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "org";
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONObject responseJSON = response.getResponseJSON();
            JSONArray orgArray = responseJSON.getJSONArray("org");
            response.setData(this.getZCRMOrganization(orgArray.getJSONObject(0)));
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    private ZCRMOrganization getZCRMOrganization(JSONObject orgJson) throws JSONException {
        NullableJSONObject orgDetails = new NullableJSONObject(orgJson);
        ZCRMOrganization organisation = ZCRMOrganization.getInstance(orgDetails.getString("company_name"), Long.parseLong(orgDetails.getString("id")));
        organisation.setAlias(orgDetails.optString("alias"));
        organisation.setPrimaryZuid(Long.parseLong(orgDetails.getString("primary_zuid")));
        organisation.setZgid(Long.parseLong(orgDetails.getString("zgid")));
        organisation.setPhone(orgDetails.optString("phone"));
        organisation.setMobile(orgDetails.optString("mobile"));
        organisation.setWebsite(orgDetails.optString("website"));
        organisation.setPrimaryEmail(orgDetails.getString("primary_email"));
        organisation.setEmployeeCount(orgDetails.optInt("employee_count"));
        organisation.setDescription(orgDetails.optString("description"));
        organisation.setTimeZone(orgDetails.getString("time_zone"));
        organisation.setIsoCode(orgDetails.getString("iso_code"));
        organisation.setCurrencyLocale(orgDetails.getString("currency_locale"));
        organisation.setCurrencySymbol(orgDetails.getString("currency_symbol"));
        organisation.setStreet(orgDetails.optString("street"));
        organisation.setState(orgDetails.optString("state"));
        organisation.setCity(orgDetails.optString("city"));
        organisation.setCountry(orgDetails.optString("country"));
        organisation.setCountryCode(orgDetails.getString("country_code"));
        organisation.setZipCode(orgDetails.optString("zip"));
        organisation.setMcStatus(orgDetails.getBoolean("mc_status"));
        organisation.setGappsEnabled(orgDetails.getBoolean("gapps_enabled"));
        organisation.setFax(orgDetails.optString("fax"));
        if (orgDetails.has("privacy_settings")) {
            organisation.setPrivacySettings(orgDetails.getBoolean("privacy_settings"));
        }
        return organisation;
    }

    public APIResponse getRole(Long roleId) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "settings/roles/" + roleId;
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONObject responseJSON = response.getResponseJSON();
            JSONArray rolesArray = responseJSON.getJSONArray("roles");
            response.setData(this.getZCRMRole(rolesArray.getJSONObject(0)));
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse getAllRoles() throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "settings/roles";
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMRole> allRoles = new ArrayList<ZCRMRole>();
            NullableJSONObject responseJSON = new NullableJSONObject(response.getResponseJSON());
            JSONArray rolesArray = responseJSON.optJSONArray("roles", new JSONArray());
            for (int index = 0; index < rolesArray.length(); ++index) {
                allRoles.add(this.getZCRMRole(rolesArray.getJSONObject(index)));
            }
            response.setData(allRoles);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    private ZCRMRole getZCRMRole(JSONObject roleDetails) throws JSONException {
        ZCRMRole role = ZCRMRole.getInstance(Long.parseLong(roleDetails.getString("id")), roleDetails.getString("name"));
        role.setLabel(roleDetails.getString("display_label"));
        role.setAdminUser(roleDetails.getBoolean("admin_user"));
        ZCRMRole reportingTo = null;
        if (!roleDetails.isNull("reporting_to")) {
            JSONObject reportingToObj = roleDetails.getJSONObject("reporting_to");
            reportingTo = ZCRMRole.getInstance(Long.parseLong(reportingToObj.getString("id")), reportingToObj.getString("name"));
        }
        role.setReportingTo(reportingTo);
        return role;
    }

    public APIResponse getProfile(Long profileId) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "settings/profiles/" + profileId;
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONObject responseJSON = response.getResponseJSON();
            JSONArray rolesArray = responseJSON.getJSONArray("profiles");
            response.setData(this.getZCRMProfile(rolesArray.getJSONObject(0)));
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse getAllProfiles() throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "settings/profiles";
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMProfile> allProfiles = new ArrayList<ZCRMProfile>();
            NullableJSONObject responseJSON = new NullableJSONObject(response.getResponseJSON());
            JSONArray profileArray = responseJSON.optJSONArray("profiles", new JSONArray());
            for (int index = 0; index < profileArray.length(); ++index) {
                allProfiles.add(this.getZCRMProfile(profileArray.getJSONObject(index)));
            }
            response.setData(allProfiles);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    private ZCRMProfile getZCRMProfile(JSONObject profileJson) throws JSONException {
        NullableJSONObject profileDetails = new NullableJSONObject(profileJson);
        ZCRMProfile profile = ZCRMProfile.getInstance(Long.parseLong(profileDetails.getString("id")), profileDetails.getString("name"));
        profile.setCategory(profileDetails.getBoolean("category"));
        profile.setDescription(profileDetails.optString("description"));
        if (!profileDetails.isNull("created_by")) {
            JSONObject createdByObj = profileDetails.getJSONObject("created_by");
            ZCRMUser createdBy = ZCRMUser.getInstance(Long.parseLong(createdByObj.getString("id")), createdByObj.getString("name"));
            profile.setCreatedBy(createdBy);
            profile.setCreatedTime(profileDetails.getString("created_time"));
        }
        if (!profileDetails.isNull("modified_by")) {
            JSONObject modifiedByObj = profileDetails.getJSONObject("modified_by");
            ZCRMUser modifiedBy = ZCRMUser.getInstance(Long.parseLong(modifiedByObj.getString("id")), modifiedByObj.getString("name"));
            profile.setModifiedBy(modifiedBy);
            profile.setModifiedTime(profileDetails.getString("modified_time"));
        }
        return profile;
    }

    @Override
    public String getJsonRootKey() {
        return this.jsonRootKey;
    }
}

