/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.api.handler;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.api.APIRequest;
import com.zoho.crm.library.api.handler.APIHandler;
import com.zoho.crm.library.api.handler.CommonAPIHandler;
import com.zoho.crm.library.api.handler.EntityAPIHandler;
import com.zoho.crm.library.api.response.BulkAPIResponse;
import com.zoho.crm.library.common.CommonUtil;
import com.zoho.crm.library.common.NullableJSONObject;
import com.zoho.crm.library.crud.ZCRMModule;
import com.zoho.crm.library.crud.ZCRMRecord;
import com.zoho.crm.library.crud.ZCRMTrashRecord;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.exception.ZCRMLogger;
import com.zoho.crm.library.setup.users.ZCRMUser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MassEntityAPIHandler
extends CommonAPIHandler
implements APIHandler {
    private ZCRMModule module;
    protected ZCRMTrashRecord trashRecord = null;

    private MassEntityAPIHandler(ZCRMModule zcrmModule) {
        this.module = zcrmModule;
    }

    public static MassEntityAPIHandler getInstance(ZCRMModule zcrmModule) {
        return new MassEntityAPIHandler(zcrmModule);
    }

    public BulkAPIResponse createRecords(List<ZCRMRecord> records, List<CommonUtil.Trigger> triggers, Long lar_id) throws ZCRMException {
        if (records.size() > 100) {
            throw new ZCRMException("Cannot process more than 100 records at a time.");
        }
        try {
            this.requestMethod = APIConstants.RequestMethod.POST;
            this.urlPath = this.module.getApiName();
            JSONObject requestBodyObj = new JSONObject();
            JSONArray dataArray = new JSONArray();
            for (ZCRMRecord record : records) {
                if (record.getEntityId() == null) {
                    dataArray.put((Object)EntityAPIHandler.getInstance(record).getZCRMRecordAsJSON());
                    continue;
                }
                throw new ZCRMException("Entity ID MUST be null for create operation.");
            }
            requestBodyObj.put(this.getJsonRootKey(), (Object)dataArray);
            if (triggers != null) {
                requestBodyObj.put("trigger", (Object)CommonUtil.getTriggersAsJSONArray(triggers));
            }
            if (lar_id != null) {
                requestBodyObj.put("lar_id", (Object)String.valueOf(lar_id));
            }
            this.requestBody = requestBodyObj;
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMRecord> createdRecords = new ArrayList<ZCRMRecord>();
            ArrayList<BulkAPIResponse.EntityResponse> responses = response.getEntityResponses();
            for (int i = 0; i < responses.size(); ++i) {
                BulkAPIResponse.EntityResponse entResponse = (BulkAPIResponse.EntityResponse)responses.get(i);
                if ("success".equals(entResponse.getStatus())) {
                    JSONObject responseData = entResponse.getResponseJSON();
                    JSONObject recordDetails = responseData.getJSONObject("details");
                    ZCRMRecord newRecord = records.get(i);
                    EntityAPIHandler.getInstance(newRecord).setRecordProperties(recordDetails);
                    createdRecords.add(newRecord);
                    entResponse.setData(newRecord);
                    continue;
                }
                entResponse.setData(null);
            }
            response.setData(createdRecords);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse updateRecords(List<Long> entityIds, String fieldAPIName, Object value, List<CommonUtil.Trigger> triggers) throws ZCRMException {
        if (entityIds.size() > 100) {
            throw new ZCRMException("Cannot process more than 100 records at a time.");
        }
        if (value == null) {
            value = JSONObject.NULL;
        }
        try {
            this.requestMethod = APIConstants.RequestMethod.PUT;
            this.urlPath = this.module.getApiName();
            JSONObject requestBodyObj = new JSONObject();
            JSONArray dataArray = new JSONArray();
            for (Long id : entityIds.toArray(new Long[0])) {
                JSONObject updateJSON = new JSONObject();
                updateJSON.put(fieldAPIName, value);
                updateJSON.put("id", (Object)String.valueOf(id));
                dataArray.put((Object)updateJSON);
            }
            requestBodyObj.put(this.getJsonRootKey(), (Object)dataArray);
            if (triggers != null) {
                requestBodyObj.put("trigger", (Object)CommonUtil.getTriggersAsJSONArray(triggers));
            }
            this.requestBody = requestBodyObj;
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<BulkAPIResponse.EntityResponse> responses = response.getEntityResponses();
            ArrayList<ZCRMRecord> updatedRecords = new ArrayList<ZCRMRecord>();
            for (BulkAPIResponse.EntityResponse entResponse : responses) {
                if ("success".equals(entResponse.getStatus())) {
                    JSONObject entRespJSON = entResponse.getResponseJSON();
                    JSONObject recordJSON = entRespJSON.getJSONObject("details");
                    ZCRMRecord updatedRecord = ZCRMRecord.getInstance(this.module.getApiName(), Long.parseLong(recordJSON.getString("id")));
                    EntityAPIHandler.getInstance(updatedRecord).setRecordProperties(recordJSON);
                    updatedRecords.add(updatedRecord);
                    entResponse.setData(updatedRecord);
                    continue;
                }
                entResponse.setData(null);
            }
            response.setData(updatedRecords);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse upsertRecords(List<ZCRMRecord> records, List<CommonUtil.Trigger> triggers, List<String> duplicate_check_fields) throws ZCRMException {
        if (records.size() > 100) {
            throw new ZCRMException("Cannot process more than 100 records at a time.");
        }
        try {
            this.requestMethod = APIConstants.RequestMethod.POST;
            this.urlPath = this.module.getApiName() + "/upsert";
            JSONObject requestBodyObj = new JSONObject();
            JSONArray dataArray = new JSONArray();
            for (ZCRMRecord record : records) {
                JSONObject recJSON = EntityAPIHandler.getInstance(record).getZCRMRecordAsJSON();
                recJSON.put("id", (Object)record.getEntityId());
                dataArray.put((Object)recJSON);
            }
            requestBodyObj.put(this.getJsonRootKey(), (Object)dataArray);
            if (triggers != null) {
                requestBodyObj.put("trigger", (Object)CommonUtil.getTriggersAsJSONArray(triggers));
            }
            this.requestBody = requestBodyObj;
            if (duplicate_check_fields != null) {
                this.requestQueryParams.put("duplicate_check_fields", (Object)CommonUtil.collectionToCommaDelimitedString(duplicate_check_fields.toString(), ","));
            }
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMRecord> upsertedRecords = new ArrayList<ZCRMRecord>();
            ArrayList<BulkAPIResponse.EntityResponse> responses = response.getEntityResponses();
            for (int i = 0; i < responses.size(); ++i) {
                BulkAPIResponse.EntityResponse entResponse = (BulkAPIResponse.EntityResponse)responses.get(i);
                if ("success".equals(entResponse.getStatus())) {
                    JSONObject responseData = entResponse.getResponseJSON();
                    JSONObject recordDetails = responseData.getJSONObject("details");
                    ZCRMRecord record = records.get(i);
                    EntityAPIHandler.getInstance(record).setRecordProperties(recordDetails);
                    upsertedRecords.add(record);
                    entResponse.setData(record);
                    continue;
                }
                entResponse.setData(null);
            }
            response.setData(upsertedRecords);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse getRecords(Long cvId, String sortByField, CommonUtil.SortOrder sortOrder, int page, int per_page, String modifiedSince, String isConverted, String isApproved, List<String> fields, Boolean includePrivateFields) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = this.module.getApiName();
            if (cvId != null) {
                this.requestQueryParams.put("cvid", (Object)String.valueOf(cvId));
            }
            this.requestQueryParams.put("sort_by", (Object)sortByField);
            if (sortOrder != null) {
                this.requestQueryParams.put("sort_order", (Object)sortOrder.name());
            }
            this.requestQueryParams.put("page", (Object)String.valueOf(page));
            this.requestQueryParams.put("per_page", (Object)String.valueOf(per_page));
            this.requestQueryParams.put("converted", (Object)isConverted);
            this.requestQueryParams.put("approved", (Object)isApproved);
            if (fields != null && !fields.isEmpty()) {
                this.requestQueryParams.put("fields", (Object)CommonUtil.collectionToCommaDelimitedString(fields.toString(), ","));
            }
            if (includePrivateFields.booleanValue()) {
                this.requestQueryParams.put("include", (Object)"private_fields");
            }
            this.requestHeaders.put("If-Modified-Since", (Object)modifiedSince);
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMRecord> recordsList = new ArrayList<ZCRMRecord>();
            NullableJSONObject responseJSON = new NullableJSONObject(response.getResponseJSON());
            JSONArray recordsArray = responseJSON.optJSONArray(this.getJsonRootKey(), new JSONArray());
            for (int index = 0; index < recordsArray.length(); ++index) {
                JSONObject recordDetails = recordsArray.getJSONObject(index);
                ZCRMRecord record = ZCRMRecord.getInstance(this.module.getApiName(), Long.parseLong(recordDetails.getString("id")));
                EntityAPIHandler.getInstance(record).setRecordProperties(recordDetails);
                recordsList.add(record);
            }
            response.setData(recordsList);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse deleteRecords(List<Long> entityIds) throws ZCRMException {
        if (entityIds.size() > 100) {
            throw new ZCRMException("Cannot process more than 100 records at a time.");
        }
        try {
            this.requestMethod = APIConstants.RequestMethod.DELETE;
            this.urlPath = this.module.getApiName();
            this.requestQueryParams.put("ids", (Object)CommonUtil.collectionToCommaDelimitedString(entityIds.toString(), ","));
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<BulkAPIResponse.EntityResponse> responses = response.getEntityResponses();
            for (BulkAPIResponse.EntityResponse entResponse : responses) {
                JSONObject entRespJSON = entResponse.getResponseJSON();
                JSONObject recordJSON = entRespJSON.getJSONObject("details");
                ZCRMRecord record = ZCRMRecord.getInstance(this.module.getApiName(), Long.parseLong(recordJSON.getString("id")));
                entResponse.setData(record);
            }
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse getDeletedRecords(String type, String modifiedSince, int page, int perPage) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = this.module.getApiName() + "/deleted";
            this.requestQueryParams.put("type", (Object)type);
            if (modifiedSince != null) {
                this.requestHeaders.put("If-Modified-Since", (Object)modifiedSince);
            }
            this.requestQueryParams.put("page", (Object)String.valueOf(page));
            this.requestQueryParams.put("per_page", (Object)String.valueOf(perPage));
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMTrashRecord> trashRecordsList = new ArrayList<ZCRMTrashRecord>();
            NullableJSONObject responseJSON = new NullableJSONObject(response.getResponseJSON());
            JSONArray recordsArray = responseJSON.optJSONArray(this.getJsonRootKey(), new JSONArray());
            for (int index = 0; index < recordsArray.length(); ++index) {
                JSONObject trashRecordDetails = recordsArray.getJSONObject(index);
                this.trashRecord = ZCRMTrashRecord.getInstance(trashRecordDetails.getString("type"), Long.parseLong(trashRecordDetails.getString("id")));
                this.setTrashRecordProperties(trashRecordDetails);
                trashRecordsList.add(this.trashRecord);
            }
            response.setData(trashRecordsList);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse searchByText(String searchText, int page, int per_page) throws ZCRMException {
        return this.searchRecords("word", searchText, page, per_page);
    }

    public BulkAPIResponse searchByCriteria(String searchCriteria, int page, int per_page) throws ZCRMException {
        return this.searchRecords("criteria", searchCriteria, page, per_page);
    }

    public BulkAPIResponse searchByEmail(String searchValue, int page, int per_page) throws ZCRMException {
        return this.searchRecords("email", searchValue, page, per_page);
    }

    public BulkAPIResponse searchByPhone(String searchValue, int page, int per_page) throws ZCRMException {
        return this.searchRecords("phone", searchValue, page, per_page);
    }

    private BulkAPIResponse searchRecords(String searchKey, String searchValue, int page, int per_page) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = this.module.getApiName() + "/search";
            this.requestQueryParams.put(searchKey, (Object)searchValue);
            this.requestQueryParams.put("page", (Object)String.valueOf(page));
            this.requestQueryParams.put("per_page", (Object)String.valueOf(per_page));
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMRecord> recordsList = new ArrayList<ZCRMRecord>();
            NullableJSONObject responseJSON = new NullableJSONObject(response.getResponseJSON());
            JSONArray recordsArray = responseJSON.optJSONArray(this.getJsonRootKey(), new JSONArray());
            for (int index = 0; index < recordsArray.length(); ++index) {
                JSONObject recordDetails = recordsArray.getJSONObject(index);
                ZCRMRecord record = ZCRMRecord.getInstance(this.module.getApiName(), Long.parseLong(recordDetails.getString("id")));
                EntityAPIHandler.getInstance(record).setRecordProperties(recordDetails);
                recordsList.add(record);
            }
            response.setData(recordsList);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public void setTrashRecordProperties(JSONObject trashRecordDetails) throws JSONException {
        Iterator jsonItr = trashRecordDetails.keys();
        while (jsonItr.hasNext()) {
            String fieldAPIName = (String)jsonItr.next();
            if ("created_By".equals(fieldAPIName)) {
                JSONObject createdByObj = trashRecordDetails.getJSONObject(fieldAPIName);
                ZCRMUser createdBy = ZCRMUser.getInstance(Long.parseLong(createdByObj.getString("id")), createdByObj.getString("name"));
                this.trashRecord.setCreatedBy(createdBy);
                continue;
            }
            if ("deleted_by".equals(fieldAPIName)) {
                JSONObject modifiedByObj = trashRecordDetails.getJSONObject(fieldAPIName);
                ZCRMUser deletedBy = ZCRMUser.getInstance(Long.parseLong(modifiedByObj.getString("id")), modifiedByObj.getString("name"));
                this.trashRecord.setDeletedBy(deletedBy);
                continue;
            }
            if ("display_name".equals(fieldAPIName)) {
                this.trashRecord.setDisplayName(trashRecordDetails.getString(fieldAPIName));
                continue;
            }
            if (!"deleted_time".equals(fieldAPIName)) continue;
            this.trashRecord.setDeletedTime(trashRecordDetails.getString(fieldAPIName));
        }
    }

    @Override
    public String getJsonRootKey() {
        return "data";
    }
}

