<?php

if (!defined('_PS_VERSION_')) {
  exit;
}

class ZohoSalesIQ extends Module {

  public function __construct() {
    $this->name = 'zohosalesiq';
    $this->tab = 'front_office_features';
    $this->version = '2.0';
    $this->author= 'SalesIQ Team';
    $this->dir = '/modules/zohosalesiq/';

    parent::__construct();

    $this->displayName = $this->l('Zoho SalesIQ');
    $this->description = $this->l('With Zoho SalesIQ you can instantly connect to your customers and deliver instant support');
    $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');
  }

  //Called during installation
  public function install() {
    return parent::install()
      && $this->registerHook('header')
      && $this->registerHook('displayProductAdditionalInfo')
      && Configuration::updateValue('salesiq_widget_code', '')
      && Configuration::updateValue('salesiq_widget_enabled', '1')
      && Configuration::updateValue('salesiq_include', serialize(array('all_pages')))
      && Configuration::updateValue('salesiq_button_enabled', '1');
  }

  //Render Configuration page
  public function getContent() {
    $output = null;

    if (Tools::isSubmit('submit' . $this->name)) {
      $widget_code = strval(Tools::getValue('salesiq_widget_code'));
      $widget_enabled = strval(Tools::getValue('salesiq_widget_enabled'));
      $salesiq_include = serialize(Tools::getValue('salesiq_include'));
      $button_enabled = strval(Tools::getValue('salesiq_button_enabled'));
      if(!strpos($widget_code, "/widget?plugin_source")){
        $widget_code = str_replace("/widget","/widget?plugin_source=prestashop",$widget_code);
      }
      if (!$widget_code || empty($widget_code)) {
        $output .= $this->displayError($this->l('Invalid Configuration value'));
      } else {
        if(preg_match( "/^<script[^>]*>\s*.+\s*(float\.ls|.+widgetcode.+\/widget)\s*.+\s*<\/script>$/s", $widget_code))
        {
          Configuration::updateValue('salesiq_widget_code', Tools::htmlentitiesUTF8($widget_code));
        }
        Configuration::updateValue('salesiq_widget_enabled', $widget_enabled);
        Configuration::updateValue('salesiq_include', $salesiq_include);
        Configuration::updateValue('salesiq_button_enabled', $button_enabled);
        $output .= $this->displayConfirmation($this->l('Settings updated'));
      }
    }

    return $output . $this->_displayForm();
  }
    
  //Generate form
  private function _displayForm() {
    // Get default Language
    $default_lang = (int) Configuration::get('PS_LANG_DEFAULT');
     
    // Init Fields form array
    $fields_form[0]['form'] = array(
      'legend' => array(
        'title' => $this->l('Settings'),
      ),
      'input' => array(
        array(
          'type' => 'textarea',
          'label' =>'Chat Widget code <br><br> <a href="https://salesiq.zoho.com/register.sas?source=Prestashop.salesiqpluginconfig" target="_blank"><strong>Click here to sign up</strong></a> for Zoho SalesIQ <br>and get the widget code',
          'name' => 'salesiq_widget_code',
          'cols' => 80,
          'rows' => 10,
          'required' => true
        ),
        $this->_getSelectInput($this->l('Chat Widget(If choose to disabled, only tracking will work)'), 'salesiq_widget_enabled'),
        array(
          'type' => 'select',
          'multiple' => true,
          'label' => $this->l('Include in'),
          'name' => 'salesiq_include[]',
          'size' => 6,
          'options' => array(
            'query' => array(
              array(
                'id_option' => 'all_pages',
                'name' => 'All Pages'
              ),
              array(
                'id_option' => 'index',
                'name' => 'Home Page'
              ),
              array(
                'id_option' => 'product',
                'name' => 'Product Pages'
              ),
              array(
                'id_option' => 'category',
                'name' => 'Category Pages'
              ),
              array(
                'id_option' => 'order',
                'name' => 'My Cart'
              ),
              array(
                'id_option' => 'my-account',
                'name' => 'My Account'
              )
            ),
            'id' => 'id_option',                  
            'name' => 'name'                      
          )
        ),
        $this->_getSelectInput($this->l('Quick Chat Button'), 'salesiq_button_enabled')
      ),
      'submit' => array(
        'title' => $this->l('Save'),
        'class' => 'button'
      )
    );
     
    $helper = new HelperForm();
     
    // Module, token and currentIndex
    $helper->module = $this;
    $helper->name_controller = $this->name;
    $helper->token = Tools::getAdminTokenLite('AdminModules');
    $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
     
    // Language
    $helper->default_form_language = $default_lang;
    $helper->allow_employee_form_lang = $default_lang;
     
    // Title and toolbar
    $helper->title = $this->displayName;
    $helper->show_toolbar = true;        // false -> remove toolbar
    $helper->toolbar_scroll = true;      // yes - > Toolbar is always visible on the top of the screen.
    $helper->submit_action = 'submit' . $this->name;
    $helper->toolbar_btn = array(
        'save' => array(
            'desc' => $this->l('Save'),
            'href' => AdminController::$currentIndex .
                        '&configure=' . $this->name .
                        '&save' . $this->name .
                        '&token=' . Tools::getAdminTokenLite('AdminModules')
        ),
        'back' => array(
            'desc' => $this->l('Back to list'),
            'href' => AdminController::$currentIndex .
                      '&token=' . Tools::getAdminTokenLite('AdminModules')
        )
    );
     
    // Load current value
    $widget_code = Configuration::get('salesiq_widget_code');
    $helper->fields_value['salesiq_widget_code'] = Tools::htmlentitiesDecodeUTF8($widget_code);
    $helper->fields_value['salesiq_widget_enabled'] = Configuration::get('salesiq_widget_enabled');
    $helper->fields_value['salesiq_include[]'] = unserialize(Configuration::get('salesiq_include'));
    $helper->fields_value['salesiq_button_enabled'] = Configuration::get('salesiq_button_enabled');
     
    return $helper->generateForm($fields_form);
  }    
  
  public function hookheader($params) {
    $currentPage = $this->context->controller->php_self;

    if (Configuration::get('salesiq_widget_enabled') == '1') {
      $salesiq_include = unserialize(Configuration::get('salesiq_include'));

      if (in_array($currentPage, $salesiq_include)) {
        return $this->_getWidgetScript();
      }
      else if (in_array('all_pages', $salesiq_include)) {
        return $this->_getWidgetScript();
      }
      else
      {
        return $this->_getWidgetScript(true);
      }
    }
    else
    {
      return $this->_getWidgetScript(true);
    }

    if ($currentPage == 'product'
        && Configuration::get('salesiq_button_enabled') == '1') {
      return $this->_getWidgetScript(true);
    }

  }

  private function _getWidgetScript($hideOnLoad = false) {
    global $smarty;
    $customerName = $this->context->customer->logged
                      ? $this->context->customer->firstname . ' ' . $this->context->customer->lastname
                      : '';
    $customerEmail = $this->context->customer->email ? $this->context->customer->email : '';

    $widget_code = Configuration::get('salesiq_widget_code');
    if(!strpos($widget_code, "/widget?plugin_source")){
      $widget_code = str_replace("/widget","/widget?plugin_source=prestashop",$widget_code);
    }
    
    $smarty->assign(array(
      'salesiq_widget_code' => $widget_code,
      'customerName' => json_encode($customerName),
      'customerEmail' => json_encode($customerEmail),
      'hideOnLoad' => $hideOnLoad
    ));

    return $this->display(__FILE__, 'header.tpl');
  }

  private function _getSelectInput($label, $name) {
    return array(
      'type' => 'select',
      'label' => $label,
      'name' => $name,
      'options' => array(
        'query' => array(
          array(
            'id_option' => 1,
            'name' => 'Enabled'
          ),
          array(
            'id_option' => 2,
            'name' => 'Disabled'
          )
        ),
        'id' => 'id_option',                  
        'name' => 'name'                      
      )
    );
  }

  public function hookDisplayProductAdditionalInfo($params) {
    if (Configuration::get('salesiq_button_enabled') != '1') {
      return;
    }
    global $smarty;
    try{
      $productData = $this->_getInfoAboutProduct($params);
      $question = 'Hi, I need to know more about ';
      $question .= $productData['name'];
      $question .= ' [id: ';
      $question .= $productData['id'];
      $question .= '] (url: ';
      $question .= $productData['url'];
      $question .= ' )';
      $smarty->assign(array(
        'label' => $this->l('Click here to chat'),
        'question' => htmlspecialchars(json_encode($question))
      ));
    }
    catch(Exception $e)
    {
      $smarty->assign(array(
        'label' => $this->l('Click here to chat'),
        'error'=>$this->l($e->getMessage())
      ));
    }
    return $this->display(__FILE__, 'button.tpl'); 
  }

  private function _getInfoAboutProduct($params) {
    global $link, $smarty;

    $id_product = isset($_GET['id_product']) ? (int) $_GET['id_product'] : 0;

    $product = new Product($id_product, true, (int) $params['cookie']->id_lang);

    // get product url
    $_url = $link->getProductLink($id_product);

    return array(
      'name' => $product->name, 
      'url' => $_url, 
      'id' => $id_product
    );
  }

}

?>
