/*
 * Decompiled with CFR 0.152.
 */
package attendanceclient;

import attendanceclient.LogFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConfigInfo {
    public static org.json.JSONObject config;
    protected static int reqCount;
    protected static int reqSuccessCount;
    protected static int dataCount;
    protected static long timeTakenTotal;
    private static final String ALGORITHM = "AES";
    private static final String UNICODE_FORMAT = "UTF8";
    private static final Logger LOGGER;

    public static String encrypt(String valueToEnc) throws Exception {
        Key key = ConfigInfo.generateKey();
        Cipher c = Cipher.getInstance("AES");
        c.init(1, key);
        byte[] encValue = c.doFinal(valueToEnc.getBytes("UTF8"));
        String encryptedValue = Base64.getMimeEncoder().encodeToString(encValue);
        return encryptedValue;
    }

    public static String decrypt(String encryptedValue) throws Exception {
        Key key = ConfigInfo.generateKey();
        Cipher c = Cipher.getInstance("AES");
        c.init(2, key);
        byte[] decordedValue = Base64.getMimeDecoder().decode(encryptedValue);
        byte[] decValue = c.doFinal(decordedValue);
        String decryptedValue = new String(decValue, "UTF8");
        return decryptedValue;
    }

    private static Key generateKey() throws Exception {
        byte[] keyAsBytes = "ECNADNETTAOHOZEL".getBytes("UTF8");
        SecretKeySpec key = new SecretKeySpec(keyAsBytes, "AES");
        return key;
    }

    public static String getConfigValue(String keyName, String defaultValueToReturn, String defaultValueToSet) {
        String value = defaultValueToReturn;
        try {
            if (config.has(keyName)) {
                value = config.getString(keyName);
                if (keyName.equals("dbpword") && value.equals("emptystr")) {
                    value = "";
                } else if (keyName.equals("vendorname") && value.equals("")) {
                    value = defaultValueToReturn;
                }
            } else if (!defaultValueToSet.equals("dontSetDefValue")) {
                config.put(keyName, (Object)defaultValueToSet);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(ConfigInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return value;
    }

    public static long getSleepTime() {
        long val = 300000L;
        try {
            if (config.has("sleepTime")) {
                val = 60000 * config.getInt("sleepTime");
            } else {
                config.put("sleepTime", 5);
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(ConfigInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return val;
    }

    public static int getDelaySysTime() {
        int val = 0;
        try {
            if (config.has("delaySysTime")) {
                val = config.getInt("delaySysTime");
            } else {
                config.put("delaySysTime", 0);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(ConfigInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return val;
    }

    public static int getSyncMode() {
        int sync_mode = 0;
        try {
            if (config.has("syncMode")) {
                sync_mode = config.getInt("syncMode");
            } else {
                config.put("syncMode", 0);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(ConfigInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return sync_mode;
    }

    public static long getDelaySysDate() {
        int val = 0;
        try {
            if (config.has("delaySysTime")) {
                val = config.getInt("delaySysTime");
            } else {
                config.put("delaySysTime", 0);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(ConfigInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        Calendar cal = Calendar.getInstance();
        cal.add(12, -val);
        return cal.getTime().getTime();
    }

    public static void putLastUpdatedTime(long val) {
        try {
            File file = new File("lastupdatedtime");
            if (!file.exists()) {
                file.createNewFile();
            }
            org.json.JSONObject jsonObj = new org.json.JSONObject();
            jsonObj.put("lastupdatedtime", val);
            FileWriter fileWritter = new FileWriter(file.getName());
            fileWritter.write(jsonObj.toString());
            fileWritter.flush();
            fileWritter.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception @putLastUpdatedTime {0}", e);
        }
    }

    public static Long getLastUpdatedTime() {
        Long val = null;
        try {
            File file = new File("lastupdatedtime");
            if (!file.exists()) {
                file.createNewFile();
                val = LogFile.getRequestTime();
                org.json.JSONObject jsonObj = new org.json.JSONObject();
                if (val != null) {
                    LOGGER.log(Level.INFO, "Returning time from record file");
                    jsonObj.put("lastupdatedtime", (Object)val);
                } else {
                    LOGGER.log(Level.INFO, "Resetting time to start of current day");
                    Calendar cal = Calendar.getInstance();
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    val = cal.getTimeInMillis();
                    jsonObj.put("lastupdatedtime", (Object)val);
                }
                FileWriter fileWritter = new FileWriter(file.getName());
                fileWritter.write(jsonObj.toString());
                fileWritter.flush();
                fileWritter.close();
                return val;
            }
            FileReader readRecord = null;
            readRecord = new FileReader("lastupdatedtime");
            JSONParser parser = new JSONParser();
            Object obj = parser.parse((Reader)readRecord);
            JSONObject jsonObj = (JSONObject)obj;
            LOGGER.log(Level.INFO, "Last updated json {0}", jsonObj);
            if (jsonObj.containsKey((Object)"lastupdatedtime")) {
                val = Long.parseLong(jsonObj.get((Object)"lastupdatedtime").toString());
                LOGGER.log(Level.INFO, "Returning value from lastupdatedtime file");
                return val;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception @getLastUpdatedTime {0}", e);
        }
        return val;
    }

    public static long getNextRequestTime() {
        long val = ConfigInfo.getLastUpdatedTime();
        try {
            val += ConfigInfo.getSleepTime();
        }
        catch (Exception ex) {
            Logger.getLogger(ConfigInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return val;
    }

    public static long setLastRequestTime(Long val) {
        if (val == null) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            val = cal.getTimeInMillis();
        }
        try {
            ConfigInfo.putLastUpdatedTime((long)val);
        }
        catch (Exception ex) {
            Logger.getLogger(ConfigInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return val;
    }

    public static synchronized void writeFile() throws Exception {
        LOGGER.log(Level.INFO, "\n Started writing config file");
        File file = new File(".config");
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        ConfigInfo.updateStat();
        bw.write(ConfigInfo.encrypt((String)config.toString()));
        bw.close();
        fw.close();
        LOGGER.log(Level.INFO, "\n\n\n read from file");
    }

    public static void clearStatInfo() {
        LOGGER.info("clearStatInfo called");
        reqCount = 0;
        reqSuccessCount = 0;
        dataCount = 0;
        timeTakenTotal = 0L;
    }

    private static void updateStat() throws Exception {
        config.put("reqCount", reqCount);
        config.put("reqSuccessCount", reqSuccessCount);
        config.put("dataCount", dataCount);
        config.put("timeTakenTotal", timeTakenTotal);
    }

    public static void setConfigInfo(org.json.JSONObject obj) throws Exception {
        if (config == null) {
            config = new org.json.JSONObject();
        }
        if (obj.has("dbquery")) {
            config.put("dbquery", (Object)obj.getString("dbquery"));
        }
        if (obj.has("dburl")) {
            config.put("dburl", (Object)obj.getString("dburl"));
        }
        if (obj.has("dbuname")) {
            config.put("dbuname", (Object)obj.getString("dbuname"));
        }
        if (obj.has("dbpword")) {
            config.put("dbpword", (Object)obj.getString("dbpword"));
        }
        if (obj.has("proxyUname")) {
            config.put("proxyUname", (Object)obj.getString("proxyUname"));
        }
        if (obj.has("proxyPwd")) {
            config.put("proxyPwd", (Object)obj.getString("proxyPwd"));
        }
        if (obj.has("proxyHostIP")) {
            config.put("proxyHostIP", (Object)obj.getString("proxyHostIP"));
        }
        if (obj.has("proxyPort")) {
            config.put("proxyPort", (Object)obj.getString("proxyPort"));
        }
        if (obj.has("refreshtoken")) {
            config.put("refreshtoken", (Object)obj.getString("refreshtoken"));
        }
        if (obj.has("clientID")) {
            config.put("clientID", (Object)obj.getString("clientID"));
        }
        if (obj.has("clientSecret")) {
            config.put("clientSecret", (Object)obj.getString("clientSecret"));
        }
        if (obj.has("sleepTime")) {
            config.put("sleepTime", obj.getLong("sleepTime"));
        }
        if (obj.has("timeZone")) {
            config.put("timeZone", (Object)obj.getString("timeZone"));
        }
        TimeZone.setDefault(TimeZone.getTimeZone(ConfigInfo.getConfigValue((String)"timeZone", (String)"GMT", (String)"GMT")));
        if (obj.has("lastRequestTime")) {
            ConfigInfo.putLastUpdatedTime((long)new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").parse(obj.getString("lastRequestTime")).getTime());
        }
        if (obj.has("delaySysTime")) {
            config.put("delaySysTime", (Object)obj.getString("delaySysTime"));
        }
        if (obj.has("vendorname")) {
            config.put("vendorname", (Object)obj.getString("vendorname"));
        }
        if (obj.has("syncMode")) {
            config.put("syncMode", obj.getInt("syncMode"));
        }
        if (obj.has("databaseType")) {
            config.put("databaseType", (Object)obj.getString("databaseType"));
        }
        ConfigInfo.writeFile();
    }

    public static org.json.JSONObject getstatinfo() {
        org.json.JSONObject obj = new org.json.JSONObject();
        try {
            obj.put("reqCount", reqCount);
            obj.put("reqFailCount", reqCount - reqSuccessCount);
            obj.put("reqSuccesCount", reqSuccessCount);
            obj.put("dataCount", dataCount);
            if (timeTakenTotal != 0L && reqCount != 0) {
                obj.put("averageTimeTaken", timeTakenTotal / (long)reqCount);
                long ms = timeTakenTotal / (long)reqCount;
                if (ms >= 1000L) {
                    obj.put("averageTimeTaken", (Object)(timeTakenTotal / (long)reqCount / 1000L + "s"));
                } else {
                    obj.put("averageTimeTaken", (Object)(timeTakenTotal / (long)reqCount + "ms"));
                }
            } else {
                obj.put("averageTimeTaken", 0);
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(ConfigInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return obj;
    }

    public static synchronized org.json.JSONObject getConfInfo() {
        LOGGER.log(Level.INFO, "\n\n\n getConfInfo called");
        FileInputStream fis = null;
        try {
            File file = new File(".config");
            if (file.exists()) {
                fis = new FileInputStream(file);
                byte[] data = new byte[(int)file.length()];
                fis.read(data);
                fis.close();
                config = new org.json.JSONObject(ConfigInfo.decrypt((String)new String(data, "UTF-8")));
                reqCount = config.getInt("reqCount");
                reqSuccessCount = config.getInt("reqSuccessCount");
                dataCount = config.getInt("dataCount");
                timeTakenTotal = config.getLong("timeTakenTotal");
            } else {
                file.createNewFile();
                config = new org.json.JSONObject();
                ConfigInfo.writeFile();
            }
            ConfigInfo.getLastUpdatedTime();
            if (config.has("lastRequestTime")) {
                config.remove("lastRequestTime");
                ConfigInfo.writeFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.INFO, "\n\n\n Exception in getConfInfo " + e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return config;
    }

    static {
        reqCount = 0;
        reqSuccessCount = 0;
        dataCount = 0;
        timeTakenTotal = 0L;
        LOGGER = Logger.getLogger("ConfigInfo");
    }
}

