/*
 * Decompiled with CFR 0.152.
 */
package action;

import DatabaseUtil.ConnectToDatabase;
import attendanceclient.AttendanceThread;
import attendanceclient.ConfigInfo;
import attendanceclient.LogFile;
import attendanceclient.Util;
import attendanceclient.ZPAServerRequest;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.simple.JSONObject;

public class ClientAction
extends Action {
    private static AttendanceThread attendanceThread;
    private static final Logger LOGGER;

    public void initThread() throws Exception {
        LOGGER.log(Level.INFO, "*** \n\n InitThread from the startUp called");
        if (attendanceThread == null) {
            attendanceThread = new AttendanceThread();
        }
        LOGGER.log(Level.INFO, "*** \n\n Starting Sync from the ClientAction part");
        attendanceThread.startSync();
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String mode = request.getParameter("mode");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        if (mode == null) {
            out.print("invalid input");
            return null;
        }
        LOGGER.log(Level.INFO, "*** \n server request mode : {0} ", mode);
        org.json.JSONObject confobj = ConfigInfo.getConfInfo();
        if (attendanceThread == null) {
            attendanceThread = new AttendanceThread();
        }
        if (mode.equals("getInfo")) {
            org.json.JSONObject obj = new org.json.JSONObject();
            obj.put("isRunning", attendanceThread.isRunning());
            obj.put("lastRequestTime", (Object)new SimpleDateFormat("HH:mm:ss (dd/MM/yyyy)").format(new Date(ConfigInfo.getLastUpdatedTime())));
            if (new Date(ConfigInfo.getDelaySysDate()).getTime() - ConfigInfo.getLastUpdatedTime() < ConfigInfo.getSleepTime()) {
                obj.put("nextUpdateSecs", (ConfigInfo.getSleepTime() - new Date(ConfigInfo.getDelaySysDate()).getTime() + ConfigInfo.getLastUpdatedTime()) / 1000L);
            } else {
                obj.put("nextUpdateSecs", ConfigInfo.getSleepTime() / 1000L);
            }
            org.json.JSONObject statinfo = ConfigInfo.getstatinfo();
            obj.put("statinfo", (Object)statinfo);
            obj.put("logs", LogFile.getLogs(null));
            obj.put("offsetVal", TimeZone.getTimeZone(ConfigInfo.getConfigValue((String)"timeZone", (String)"GMT", (String)"GMT")).getRawOffset());
            obj.put("time", new Date().getTime());
            obj.put("currentTimeGMT1", (Object)new Date());
            obj.put("logsFiles", (Object)LogFile.listFilesForFolder());
            JSONObject recordInfo = LogFile.getFromRecord((String)"fullData");
            if (recordInfo != null) {
                obj.put("recordinfo", (Map)recordInfo);
            }
            obj.put("sysDelay", ConfigInfo.getDelaySysTime());
            obj.put("delayedTime", ConfigInfo.getDelaySysDate());
            obj.put("vendorname", (Object)ConfigInfo.getConfigValue((String)"vendorname", (String)"Zoho People Plugin", (String)"Zoho People Plugin"));
            out.print(obj);
        } else if (mode.equals("getConfInfo")) {
            org.json.JSONObject info = new org.json.JSONObject();
            info.put("dbquery", (Object)ConfigInfo.getConfigValue((String)"dbquery", (String)"", (String)"dontSetDefValue"));
            info.put("dburl", (Object)ConfigInfo.getConfigValue((String)"dburl", (String)"", (String)"dontSetDefValue"));
            info.put("dbuname", (Object)ConfigInfo.getConfigValue((String)"dbuname", (String)"", (String)"dontSetDefValue"));
            info.put("dbpword", (Object)"password");
            info.put("proxyUname", (Object)ConfigInfo.getConfigValue((String)"proxyUname", (String)"", (String)"dontSetDefValue"));
            info.put("proxyPwd", (Object)"password");
            info.put("proxyHostIP", (Object)ConfigInfo.getConfigValue((String)"proxyHostIP", (String)"", (String)"dontSetDefValue"));
            info.put("proxyPort", (Object)ConfigInfo.getConfigValue((String)"proxyPort", (String)"", (String)"dontSetDefValue"));
            info.put("refreshtoken", (Object)"refreshtoken");
            info.put("clientID", (Object)"clientID");
            info.put("clientSecret", (Object)"clientSecret");
            info.put("lastRequestTime", (Object)ConfigInfo.getLastUpdatedTime());
            info.put("lastRequestTimeInDate", (Object)new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date(ConfigInfo.getLastUpdatedTime())));
            info.put("sleepTime", ConfigInfo.getSleepTime());
            info.put("timeZone", (Object)ConfigInfo.getConfigValue((String)"timeZone", (String)"GMT", (String)"GMT"));
            info.put("sysDelay", ConfigInfo.getDelaySysTime());
            info.put("databaseType", (Object)ConfigInfo.getConfigValue((String)"databaseType", (String)"1", (String)"1"));
            out.print(info);
        } else if (mode.equals("save") || mode.equals("resume")) {
            org.json.JSONObject obj = new org.json.JSONObject();
            if (mode.equals("save")) {
                if (request.getParameter("refreshtoken") != null && !request.getParameter("refreshtoken").equals("")) {
                    obj.put("refreshtoken", (Object)request.getParameter("refreshtoken"));
                }
                if (request.getParameter("clientID") != null && !request.getParameter("clientID").equals("")) {
                    obj.put("clientID", (Object)request.getParameter("clientID"));
                }
                if (request.getParameter("clientSecret") != null && !request.getParameter("clientSecret").equals("")) {
                    obj.put("clientSecret", (Object)request.getParameter("clientSecret"));
                }
                if (request.getParameter("sleepTime") != null && !request.getParameter("sleepTime").equals("")) {
                    obj.put("sleepTime", (Object)request.getParameter("sleepTime"));
                }
                if (request.getParameter("lastRequestTime") != null && !request.getParameter("lastRequestTime").equals("")) {
                    obj.put("lastRequestTime", (Object)request.getParameter("lastRequestTime"));
                }
                if (request.getParameter("proxyHostIP") != null) {
                    obj.put("proxyHostIP", (Object)request.getParameter("proxyHostIP"));
                }
                if (request.getParameter("proxyPort") != null) {
                    obj.put("proxyPort", (Object)request.getParameter("proxyPort"));
                }
                if (request.getParameter("proxyUname") != null) {
                    obj.put("proxyUname", (Object)request.getParameter("proxyUname"));
                }
                if (request.getParameter("proxyPwd") != null && !request.getParameter("proxyPwd").equals("")) {
                    obj.put("proxyPwd", (Object)request.getParameter("proxyPwd"));
                }
                if (request.getParameter("delaySysTime") != null && !request.getParameter("delaySysTime").equals("")) {
                    obj.put("delaySysTime", (Object)request.getParameter("delaySysTime"));
                }
                if (request.getParameter("dburl") != null && !request.getParameter("dburl").equals("")) {
                    obj.put("dburl", (Object)request.getParameter("dburl"));
                }
                if (request.getParameter("dbuname") != null && !request.getParameter("dbuname").equals("")) {
                    obj.put("dbuname", (Object)request.getParameter("dbuname"));
                }
                if (request.getParameter("dbpword") != null && !request.getParameter("dbpword").equals("")) {
                    obj.put("dbpword", (Object)request.getParameter("dbpword"));
                }
                if (request.getParameter("dbquery") != null && !request.getParameter("dbquery").equals("")) {
                    obj.put("dbquery", (Object)request.getParameter("dbquery"));
                }
                if (request.getParameter("timeZone") != null && !request.getParameter("timeZone").equals("")) {
                    obj.put("timeZone", (Object)request.getParameter("timeZone"));
                }
                if (request.getParameter("databaseType") != null && !request.getParameter("databaseType").equals("")) {
                    obj.put("databaseType", (Object)request.getParameter("databaseType"));
                }
                ConfigInfo.setConfigInfo((org.json.JSONObject)obj);
            } else {
                if (attendanceThread.isRunning()) {
                    attendanceThread.stopSync();
                }
                attendanceThread.startSync();
                obj = new org.json.JSONObject();
                obj.put("isRunning", attendanceThread.isRunning());
            }
            out.print(obj);
        } else if (mode.equals("manualUpdate")) {
            Date eDate;
            Date sDate;
            org.json.JSONObject obj = new org.json.JSONObject();
            obj.put("startTime", (Object)request.getParameter("fDate"));
            obj.put("endTime", (Object)request.getParameter("tDate"));
            obj.put("isRunning", attendanceThread.isRunning());
            obj.put("uploadRecord", (Object)request.getParameter("uploadRecord"));
            if (obj.has("startTime") && obj.has("endTime")) {
                sDate = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").parse(obj.getString("startTime"));
                eDate = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").parse(obj.getString("endTime"));
                int diffInDays = (int)((eDate.getTime() - sDate.getTime()) / 86400000L);
                if (diffInDays < 0 || diffInDays > 5) {
                    obj.put("error", diffInDays);
                    out.print(obj);
                    return null;
                }
            } else {
                obj.put("error1", (Object)"Enter Dates");
                out.print(obj);
                return null;
            }
            String dateformat = "yyyy-MM-dd HH:mm:ss";
            String ftime = new SimpleDateFormat(dateformat).format(sDate);
            String ttime = new SimpleDateFormat(dateformat).format(eDate);
            ArrayList list = new ConnectToDatabase().databaseConnection(ftime, ttime);
            if (obj.has("uploadRecord") && obj.getBoolean("uploadRecord")) {
                LOGGER.log(Level.INFO, "\n\n\n\n  send request to server====={0}==={1}", new Object[]{ftime, ttime});
                ZPAServerRequest.sendArrayHTTPRequest((ArrayList)list, (String)ftime, (String)ttime, (Date)new Date(ConfigInfo.getDelaySysDate()), (boolean)false);
            } else {
                LogFile.appendLog((String)("*" + new SimpleDateFormat(dateformat).format(new Date(ConfigInfo.getDelaySysDate()))));
                LogFile.appendLog((String)("," + ftime));
                LogFile.appendLog((String)("," + ttime));
                Iterator iData = list.iterator();
                int dataCount = 0;
                while (iData.hasNext()) {
                    String val = (String)iData.next();
                    dataCount += val.replaceAll("[^}]", "").length();
                }
                LOGGER.log(Level.INFO, "\n\n\n\n  get count from db===== {0} {1} ===={2}", new Object[]{ftime, ttime, dataCount});
                LogFile.appendLog((String)("," + dataCount));
                LogFile.appendLog((String)"\n");
            }
            ConfigInfo.writeFile();
            obj.put("logs", LogFile.getLogs(null));
            obj.put("logsFiles", (Object)LogFile.listFilesForFolder());
            obj.put("lastRequestTime", (Object)new SimpleDateFormat("HH:mm:ss (dd/MM/yyyy)").format(new Date(ConfigInfo.getLastUpdatedTime())));
            JSONObject recordInfo = LogFile.getFromRecord((String)"fullData");
            if (recordInfo != null) {
                obj.put("recordinfo", (Map)recordInfo);
            }
            obj.put("delayedTime", ConfigInfo.getDelaySysDate());
            out.print(obj);
        } else if (mode.equals("stop")) {
            attendanceThread.stopSync();
            out.print(attendanceThread.isRunning());
            attendanceThread = null;
        } else if (mode.equals("getLogs")) {
            org.json.JSONObject obj = new org.json.JSONObject();
            String name = request.getParameter("fileName").split(" ")[0];
            String fileName = "zpa_logs_" + name + ".log";
            obj.put("logs", LogFile.getLogs((String)fileName));
            JSONObject recordInfo = LogFile.getFromRecord((String)name);
            if (recordInfo != null) {
                obj.put("recordinfo", (Map)recordInfo);
            }
            obj.put("name", (Object)name);
            out.print(obj);
        } else if (mode.equals("saveVendorName")) {
            org.json.JSONObject obj = new org.json.JSONObject();
            if (request.getParameter("vendorName") != null) {
                obj.put("vendorname", (Object)request.getParameter("vendorName"));
            }
            ConfigInfo.setConfigInfo((org.json.JSONObject)obj);
            obj.put("vendorname", (Object)ConfigInfo.getConfigValue((String)"vendorname", (String)"Zoho People Plugin", (String)"Zoho People Plugin"));
            out.print(obj);
        } else if ("generateRT".equals(mode)) {
            org.json.JSONObject obj = new org.json.JSONObject();
            if (request.getParameter("clientId") != null) {
                obj.put("clientId", (Object)request.getParameter("clientId"));
            }
            if (request.getParameter("clientSecret") != null) {
                obj.put("clientSecret", (Object)request.getParameter("clientSecret"));
            }
            if (request.getParameter("code") != null) {
                obj.put("code", (Object)request.getParameter("code"));
            }
            if (request.getParameter("dcType") != null) {
                obj.put("dcType", (Object)request.getParameter("dcType"));
            }
            if (obj.length() != 4) {
                return null;
            }
            org.json.JSONObject json = new org.json.JSONObject();
            json.put("refreshToken", (Object)Util.generateRT((org.json.JSONObject)obj));
            out.print(json);
        } else if (mode.equals("getRawData")) {
            out.print(confobj);
            LOGGER.log(Level.INFO, "\n\n\n  getRawData  attendanceThread.isRunning()===>", attendanceThread.isRunning());
        } else {
            out.print("invalid input");
        }
        return null;
    }

    static {
        LOGGER = Logger.getLogger("ClientAction");
    }
}

