/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.oauth.common;

import com.zoho.desk.logger.ZDLogger;
import com.zoho.oauth.client.ZohoOAuthClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class ZohoHTTPConnector {
    private String url;
    private HashMap<String, String> requestParams = new HashMap();
    private HashMap<String, String> requestHeaders = new HashMap();

    public String post() throws Exception {
        String value;
        CloseableHttpClient client = this.getHttpClient();
        HttpPost post = new HttpPost(this.url);
        post.setHeader("User-Agent", "zohodesksdk-java/1.1.1");
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        if (this.requestParams != null && !this.requestParams.isEmpty()) {
            for (String key : this.requestParams.keySet()) {
                value = this.requestParams.get(key);
                if (value == null) continue;
                urlParameters.add(new BasicNameValuePair(key, value));
            }
        }
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
        if (this.requestHeaders != null && !this.requestHeaders.isEmpty()) {
            for (String key : this.requestHeaders.keySet()) {
                value = this.requestHeaders.get(key);
                if (value == null) continue;
                post.setHeader(key, value);
            }
        }
        HashMap<String, String> loggerData = new HashMap<String, String>(this.requestParams);
        loggerData.remove("client_secret");
        ZDLogger.logInfo("POST - URL = " + this.url + ", HEADERS = " + this.requestHeaders + ", PARAMS = " + loggerData);
        CloseableHttpResponse response = client.execute((HttpUriRequest)post);
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuffer result = new StringBuffer();
        String line = "";
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        ZDLogger.logInfo("STATUS_CODE = " + response.getStatusLine().getStatusCode() + " ,RESPONSE_JSON = " + result.toString());
        return result.toString();
    }

    public String get() throws IOException, NoSuchAlgorithmException {
        CloseableHttpClient client = this.getHttpClient();
        HttpGet request = new HttpGet(this.url);
        request.addHeader("User-Agent", "zohodesksdk-java/1.1.1");
        if (this.requestHeaders != null && !this.requestHeaders.isEmpty()) {
            for (String key : this.requestHeaders.keySet()) {
                String value = this.requestHeaders.get(key);
                if (value == null) continue;
                request.setHeader(key, value);
            }
        }
        HashMap<String, String> loggerData = new HashMap<String, String>(this.requestParams);
        loggerData.remove("client_secret");
        ZDLogger.logInfo("GET - URL = " + this.url + ", HEADERS = " + this.requestHeaders + ", PARAMS = " + loggerData);
        CloseableHttpResponse response = client.execute((HttpUriRequest)request);
        String result = EntityUtils.toString((HttpEntity)response.getEntity());
        ZDLogger.logInfo("STATUS_CODE = " + response.getStatusLine().getStatusCode() + " ,RESPONSE_JSON = " + result);
        return result;
    }

    private CloseableHttpClient getHttpClient() throws NoSuchAlgorithmException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setUserAgent("zohodesksdk-java/1.1.1");
        ZohoOAuthClient client = ZohoOAuthClient.getInstance();
        String timeout = client.getConfigValue("timeOut");
        if (timeout != null) {
            RequestConfig config = RequestConfig.custom().setConnectTimeout(Integer.parseInt(timeout)).setConnectionRequestTimeout(Integer.parseInt(timeout)).setSocketTimeout(Integer.parseInt(timeout)).build();
            httpClientBuilder.setDefaultRequestConfig(config);
        }
        if (client.getAllConfigs().containsKey("proxyHost") && client.getAllConfigs().containsKey("proxyPort")) {
            String proxyHost = client.getConfigValue("proxyHost");
            Integer proxyPort = Integer.valueOf(client.getConfigValue("proxyPort"));
            String proxyUserDomain = client.getConfigValue("proxyUserDomain");
            String proxyUser = client.getConfigValue("proxyUser");
            String proxyPassword = client.getConfigValue("proxyPassword");
            HttpHost proxy = new HttpHost(proxyHost, proxyPort.intValue());
            if (proxyUser != null && !proxyUser.isEmpty()) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxyHost, proxyPort.intValue()), (Credentials)new NTCredentials(proxyUser, proxyPassword, null, proxyUserDomain));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            httpClientBuilder.setProxy(proxy);
        }
        SSLContext sslContext = SSLContext.getDefault();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier());
        return httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void addParam(String key, String value) {
        this.requestParams.put(key, value);
    }

    public void addHeadder(String key, String value) {
        this.requestHeaders.put(key, value);
    }
}

