/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.oauth.client;

import com.zoho.oauth.common.ZohoOAuthException;
import org.json.JSONException;
import org.json.JSONObject;

public class ZohoOAuthTokens {
    private String userMailId;
    private String accessToken;
    private String refreshToken;
    private long expiryTime;
    private String scopes;

    public void setUserMailId(String userMailId) {
        this.userMailId = userMailId;
    }

    public String getUserMailId() {
        return this.userMailId;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        if (this.isAccessTokenValid()) {
            return this.accessToken;
        }
        throw new ZohoOAuthException("Access Token has expired.");
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Long getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(Long expiryTime) {
        this.expiryTime = expiryTime;
    }

    public long getExpiryLapseInMillis() {
        return this.getExpiryTime() - System.currentTimeMillis();
    }

    private boolean isAccessTokenValid() {
        return this.getExpiryLapseInMillis() > 15000L;
    }

    public void setScopes(String scopes) {
        if (scopes != null) {
            StringBuilder builder = new StringBuilder();
            String[] scopeSplit = scopes.split(",");
            for (int i = 0; i < scopeSplit.length; ++i) {
                builder.append(scopeSplit[i].trim());
                if (i == scopeSplit.length - 1) continue;
                builder.append(",");
            }
            this.scopes = builder.toString().toLowerCase();
            if (!this.scopes.contains("aaaserver.profile.read")) {
                this.scopes = "aaaserver.profile.read," + this.scopes;
            }
        } else {
            this.scopes = scopes;
        }
    }

    public String getScopes() {
        return this.scopes;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject tokens = new JSONObject();
        tokens.put("user_mail_id", (Object)this.getUserMailId());
        tokens.put("access_token", (Object)this.getAccessToken());
        tokens.put("refresh_token", (Object)this.getRefreshToken());
        tokens.put("expires_in", this.getExpiryLapseInMillis());
        tokens.put("expiry_time", (Object)this.getExpiryTime());
        tokens.put("scopes", (Object)this.getScopes());
        return tokens;
    }

    public String toString() {
        return "user_mail_id: " + this.userMailId + ", access_token: " + this.accessToken + ", refresh_token: " + this.refreshToken + ", expiry_time: " + this.expiryTime + ", scope: " + this.scopes;
    }
}

