/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.oauth.client;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.logger.ZDLogger;
import com.zoho.oauth.client.ZohoOAuthTokens;
import com.zoho.oauth.client.ZohoPersistenceHandler;
import com.zoho.oauth.common.ZohoHTTPConnector;
import com.zoho.oauth.common.ZohoOAuthException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class ZohoOAuthClient {
    private static Map<String, String> configProperties = new HashMap<String, String>();

    private static void init() {
        try {
            configProperties.put("deskURL", "https://desk.zoho.com");
            configProperties.put("iamURL", "https://accounts.zoho.com");
            configProperties.put("access_type", "offline");
            configProperties.putAll(ZohoOAuthClient.getConfigurationProperties());
            String dc = configProperties.get("dc");
            if (dc != null) {
                ZohoOAuthClient.setDeskAndIAMUrlDomain(dc);
            }
            ZDLogger.initLogger(ZohoOAuthClient.getInstance());
            ZDLogger.logInfo("SDK is initialized.");
        }
        catch (ZDeskException | IOException ex) {
            ex.printStackTrace();
        }
    }

    private static Map<String, String> getConfigurationProperties() throws IOException {
        HashMap<String, String> configProperties = new HashMap<String, String>();
        String sdkInitializationFilePath = System.getProperty("desk.sdk.config");
        if (sdkInitializationFilePath == null) {
            throw new ZDeskException("Unable to find SDK initialization file. Please give a valid file path.");
        }
        BufferedReader reader = new BufferedReader(new FileReader(new File(sdkInitializationFilePath)));
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] property = line.split("=");
            String value = property.length == 1 ? null : property[1].trim();
            configProperties.put(property[0].trim(), value);
        }
        reader.close();
        return configProperties;
    }

    private static void setDeskAndIAMUrlDomain(String deskDomain) {
        switch (deskDomain) {
            case "eu": {
                configProperties.put("deskURL", "https://desk.zoho.eu");
                configProperties.put("iamURL", "https://accounts.zoho.eu");
                break;
            }
            case "cn": {
                configProperties.put("deskURL", "https://desk.zoho.com.cn");
                configProperties.put("iamURL", "https://accounts.zoho.com.cn");
                break;
            }
            case "in": {
                configProperties.put("deskURL", "https://desk.zoho.in");
                configProperties.put("iamURL", "https://accounts.zoho.in");
                break;
            }
            case "au": {
                configProperties.put("deskURL", "https://desk.zoho.com.au");
                configProperties.put("iamURL", "https://accounts.zoho.com.au");
                break;
            }
            default: {
                configProperties.put("deskURL", "https://desk.zoho.com");
                configProperties.put("iamURL", "https://accounts.zoho.com");
            }
        }
    }

    public String getConfigValue(String key) {
        return configProperties.get(key);
    }

    public void setConfigValue(String key, String value) {
        configProperties.put(key, value);
    }

    public Map<String, String> getAllConfigs() {
        return configProperties;
    }

    public String getIAMUrl() {
        return this.getConfigValue("iamURL");
    }

    public String getLoginWithZohoUrl() {
        return this.getIAMUrl() + "/oauth/v2/auth?scope=" + this.getScope() + "&client_id=" + this.getClientID() + "&response_type=code&access_type=" + this.getAccessType() + "&redirect_uri=" + this.getRedirectURL();
    }

    public String getScope() {
        String scopes = this.getConfigValue("scope");
        if (scopes != null && !scopes.contains("aaaserver.profile.read")) {
            scopes = scopes + "," + "aaaserver.profile.read";
        }
        return scopes;
    }

    public String getClientID() {
        return this.getConfigValue("client_id");
    }

    public String getClientSecret() {
        return this.getConfigValue("client_secret");
    }

    public String getRedirectURL() {
        return this.getConfigValue("redirect_uri");
    }

    public String getAccessType() {
        return this.getConfigValue("access_type");
    }

    public String getDeskURL() {
        return this.getConfigValue("deskURL");
    }

    public ZohoPersistenceHandler getPersistenceHandlerInstance() {
        try {
            String className = this.getConfigValue("persistence_handler_class");
            return (ZohoPersistenceHandler)Class.forName(className).getConstructor(null).newInstance(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ZohoOAuthException(ex);
        }
    }

    public static ZohoOAuthClient getInstance() {
        return new ZohoOAuthClient();
    }

    public ZohoOAuthTokens getOAuthTokenDetails(String mailId) {
        try {
            ZohoPersistenceHandler persistence = this.getPersistenceHandlerInstance();
            return persistence.getOAuthTokens(mailId);
        }
        catch (Exception ex) {
            ZDLogger.logInfo("Exception while retrieving tokens from persistence.");
            throw new ZohoOAuthException(ex);
        }
    }

    public String getAccessToken(String userMailId) {
        ZohoOAuthTokens tokens = this.getOAuthTokenDetails(userMailId);
        try {
            return tokens.getAccessToken();
        }
        catch (ZohoOAuthException ex) {
            ZDLogger.logInfo("Access Token has expired. Hence refreshing.");
            tokens = this.refreshAccessToken(tokens.getRefreshToken(), userMailId);
            return tokens.getAccessToken();
        }
    }

    public String getRefreshToken(String mailId) {
        ZohoOAuthTokens tokens = this.getOAuthTokenDetails(mailId);
        return tokens.getRefreshToken();
    }

    public boolean isUserAuthenticated(String mailId) {
        try {
            return this.getPersistenceHandlerInstance().isUserAuthenticated(mailId);
        }
        catch (Exception ex) {
            throw new ZohoOAuthException(ex);
        }
    }

    public String getUserEmailId(String accessToken) {
        try {
            ZohoHTTPConnector conn = new ZohoHTTPConnector();
            conn.setUrl(this.getIAMUrl() + "/oauth/user/info");
            conn.addHeadder("Authorization", "Zoho-oauthtoken " + accessToken);
            String response = conn.get();
            JSONObject responseJSON = new JSONObject(response);
            return responseJSON.getString("Email");
        }
        catch (Exception ex) {
            throw new ZohoOAuthException("Exception while fetching UserID from access token, Make sure AAAserver.profile.Read scope is included while generating the Grant token.");
        }
    }

    public ZohoOAuthTokens generateAccessToken(String grantToken) {
        if (grantToken == null) {
            throw new ZohoOAuthException("Grant Token is not provided.");
        }
        try {
            ZohoHTTPConnector conn = this.getZohoConnector(this.getIAMUrl() + "/oauth/v2/token");
            conn.addParam("grant_type", "authorization_code");
            conn.addParam("code", grantToken);
            String resp = conn.post();
            JSONObject responseJSON = new JSONObject(resp);
            if (responseJSON.has("access_token")) {
                ZohoOAuthTokens tokens = this.getTokensFromJSON(responseJSON);
                tokens.setUserMailId(this.getUserEmailId(tokens.getAccessToken()));
                tokens.setScopes(this.getConfigValue("scope"));
                this.getPersistenceHandlerInstance().saveOAuthData(tokens);
                return tokens;
            }
            throw new ZohoOAuthException("Exception while fetching access token from grant token - " + resp);
        }
        catch (Exception ex) {
            throw new ZohoOAuthException(ex);
        }
    }

    public ZohoOAuthTokens generateAccessTokenFromRefreshToken(String refreshToken, String userMailId) {
        if (refreshToken == null) {
            throw new ZohoOAuthException("Refresh token is not provided.");
        }
        return this.refreshAccessToken(refreshToken, userMailId);
    }

    private ZohoOAuthTokens refreshAccessToken(String refreshToken, String userMailId) {
        if (refreshToken == null) {
            throw new ZohoOAuthException("Refresh token is not provided.");
        }
        try {
            ZohoHTTPConnector conn = this.getZohoConnector(this.getIAMUrl() + "/oauth/v2/token");
            conn.addParam("grant_type", "refresh_token");
            conn.addParam("refresh_token", refreshToken);
            String resp = conn.post();
            JSONObject responseJSON = new JSONObject(resp);
            if (responseJSON.has("access_token")) {
                ZohoOAuthTokens tokens = this.getTokensFromJSON(responseJSON);
                tokens.setRefreshToken(refreshToken);
                tokens.setUserMailId(userMailId);
                this.getPersistenceHandlerInstance().saveOAuthData(tokens);
                return tokens;
            }
            throw new ZohoOAuthException("Exception while fetching access token from refresh token - " + resp);
        }
        catch (Exception ex) {
            throw new ZohoOAuthException(ex);
        }
    }

    private ZohoHTTPConnector getZohoConnector(String url) {
        ZohoHTTPConnector conn = new ZohoHTTPConnector();
        conn.setUrl(url);
        conn.addParam("client_id", this.getClientID());
        conn.addParam("client_secret", this.getClientSecret());
        conn.addParam("redirect_uri", this.getRedirectURL());
        return conn;
    }

    private ZohoOAuthTokens getTokensFromJSON(JSONObject response) throws JSONException {
        ZohoOAuthTokens tokens = new ZohoOAuthTokens();
        Integer expiresIn = (Integer)response.get("expires_in");
        tokens.setExpiryTime(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(expiresIn.intValue()));
        String accessToken = (String)response.get("access_token");
        tokens.setAccessToken(accessToken);
        if (response.has("refresh_token")) {
            String refreshToken = (String)response.get("refresh_token");
            tokens.setRefreshToken(refreshToken);
        }
        return tokens;
    }

    static {
        ZohoOAuthClient.init();
    }
}

