/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.upload;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import com.zoho.desk.upload.Upload;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.json.JSONException;
import org.json.JSONObject;

public class UploadAPI {
    private String mailId;

    private UploadAPI(String mailId) {
        this.mailId = mailId;
    }

    public static UploadAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new UploadAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public Upload uploadFile(File file) {
        if (file == null) {
            throw new ZDeskException("file is mandatory payload data");
        }
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.addBinaryBody("file", file);
        HttpEntity payloadEntity = entityBuilder.build();
        StringBuilder requestURL = new StringBuilder("/api/v1/uploads");
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), payloadEntity, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Upload upload = new Upload(new JSONObject(responseData));
            return upload;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

