/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.upload;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.init.CommonUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Upload {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isPublic");

    public Upload() {
    }

    public Upload(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public String getSize() {
        return (String)this.data.get("size");
    }

    public String getCreatorId() {
        return (String)this.data.get("creatorId");
    }

    public String getName() {
        return (String)this.data.get("name");
    }

    public Date getCreatedTime() throws ZDeskException {
        try {
            String createdTimeValue = (String)this.data.get("createdTime");
            return createdTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(createdTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public Boolean getIsPublic() {
        return (Boolean)this.data.get("isPublic");
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public String getHref() {
        return (String)this.data.get("href");
    }

    private void setFieldValues(JSONObject uploadData) throws JSONException {
        Iterator itr = uploadData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = uploadData.get(key);
            if (uploadData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, uploadData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }
}

