/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.timeTracking;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import com.zoho.desk.timeTracking.TimeTracking;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Scanner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.json.JSONException;
import org.json.JSONObject;

public class TimeTrackingAPI {
    private String mailId;

    private TimeTrackingAPI(String mailId) {
        this.mailId = mailId;
    }

    public static TimeTrackingAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new TimeTrackingAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public TimeTracking updateTimeTrackingSettings(TimeTracking timeTracking) {
        if (timeTracking.getDepId() == null) {
            throw new ZDeskException("depId is mandatory payload key");
        }
        if (timeTracking.getIsTimeTracking() == null) {
            throw new ZDeskException("isTimeTracking is mandatory payload key");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/timeTrackSettings");
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PUT, requestURL.toString(), (HttpEntity)new ByteArrayEntity(timeTracking.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            TimeTracking timeTracking2 = new TimeTracking(new JSONObject(responseData));
            return timeTracking2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public TimeTracking getTimeTrackSetting(String depId) {
        StringBuilder requestURL = new StringBuilder("/api/v1/timeTrackSettings");
        if (depId != null) {
            String depIdStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(depIdStr).append("depId=").append(depId);
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            TimeTracking timeTracking = new TimeTracking(new JSONObject(responseData));
            return timeTracking;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public TimeTracking createTimeTrackingSettings(TimeTracking timeTracking) {
        if (timeTracking.getDepId() == null) {
            throw new ZDeskException("depId is mandatory payload key");
        }
        if (timeTracking.getIsTimeTracking() == null) {
            throw new ZDeskException("isTimeTracking is mandatory payload key");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/timeTrackSettings");
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(timeTracking.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            TimeTracking timeTracking2 = new TimeTracking(new JSONObject(responseData));
            return timeTracking2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

