/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.timeTracking;

import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.logger.ZDLogger;
import com.zoho.desk.timeTracking.ActivityPreference;
import com.zoho.desk.timeTracking.Agents;
import com.zoho.desk.timeTracking.Profiles;
import com.zoho.desk.timeTracking.TicketPreference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TimeTracking {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isTimeTracking", "isBillable");

    public TimeTracking() {
    }

    public TimeTracking(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public TicketPreference getTicketPreference() {
        try {
            Map value = (Map)this.data.get("ticketPreference");
            if (value == null) {
                return null;
            }
            return new TicketPreference(new JSONObject(value));
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public void setTicketPreference(TicketPreference ticketPreference) {
        this.data.put("ticketPreference", ticketPreference);
        this.update.add("ticketPreference");
    }

    public BillingType getBillingType() {
        String responseValue = (String)this.data.get("billingType");
        BillingType value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "FIXED_COST_FOR_TICKETS": {
                value = BillingType.FIXED_COST_FOR_TICKETS;
                break;
            }
            case "SPECIFIC_COST_PER_AGENT": {
                value = BillingType.SPECIFIC_COST_PER_AGENT;
                break;
            }
            case "SPECIFIC_COST_PER_PROFILE": {
                value = BillingType.SPECIFIC_COST_PER_PROFILE;
                break;
            }
            case "FIXED_COST_FOR_AGENTS": {
                value = BillingType.FIXED_COST_FOR_AGENTS;
            }
        }
        return value;
    }

    public void setBillingType(BillingType billingType) {
        String value = null;
        if (billingType != null) {
            value = billingType.getValue();
        }
        this.data.put("billingType", value);
        this.update.add("billingType");
    }

    public ActivityPreference getActivityPreference() {
        try {
            Map value = (Map)this.data.get("activityPreference");
            if (value == null) {
                return null;
            }
            return new ActivityPreference(new JSONObject(value));
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public void setActivityPreference(ActivityPreference activityPreference) {
        this.data.put("activityPreference", activityPreference);
        this.update.add("activityPreference");
    }

    public String getFixedCost() {
        return (String)this.data.get("fixedCost");
    }

    public void setFixedCost(String fixedCost) {
        this.data.put("fixedCost", fixedCost);
        this.update.add("fixedCost");
    }

    public List<Profiles> getProfiles() {
        try {
            ArrayList<Profiles> result = new ArrayList<Profiles>();
            List value = (List)this.data.get("profiles");
            if (value == null) {
                return null;
            }
            for (Map subProps : value) {
                result.add(new Profiles(new JSONObject(subProps)));
            }
            return result;
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public void setProfiles(List<Profiles> profiles) {
        this.data.put("profiles", profiles);
        this.update.add("profiles");
    }

    public String getDepId() {
        return (String)this.data.get("depId");
    }

    public void setDepId(String depId) {
        this.data.put("depId", depId);
        this.update.add("depId");
    }

    public Boolean getIsTimeTracking() {
        return (Boolean)this.data.get("isTimeTracking");
    }

    public void setIsTimeTracking(Boolean isTimeTracking) {
        this.data.put("isTimeTracking", isTimeTracking);
        this.update.add("isTimeTracking");
    }

    public TimerAction getTimerAction() {
        String responseValue = (String)this.data.get("timerAction");
        TimerAction value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "ADD": {
                value = TimerAction.ADD;
                break;
            }
            case "DISCARD": {
                value = TimerAction.DISCARD;
            }
        }
        return value;
    }

    public void setTimerAction(TimerAction timerAction) {
        String value = null;
        if (timerAction != null) {
            value = timerAction.getValue();
        }
        this.data.put("timerAction", value);
        this.update.add("timerAction");
    }

    public Boolean getIsBillable() {
        return (Boolean)this.data.get("isBillable");
    }

    public void setIsBillable(Boolean isBillable) {
        this.data.put("isBillable", isBillable);
        this.update.add("isBillable");
    }

    public List<Agents> getAgents() {
        try {
            ArrayList<Agents> result = new ArrayList<Agents>();
            List value = (List)this.data.get("agents");
            if (value == null) {
                return null;
            }
            for (Map subProps : value) {
                result.add(new Agents(new JSONObject(subProps)));
            }
            return result;
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public void setAgents(List<Agents> agents) {
        this.data.put("agents", agents);
        this.update.add("agents");
    }

    private void setFieldValues(JSONObject timeTrackingData) throws JSONException {
        Iterator itr = timeTrackingData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = timeTrackingData.get(key);
            if (timeTrackingData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, timeTrackingData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum TimerAction {
        ADD("ADD"),
        DISCARD("DISCARD");

        private String value;

        private TimerAction(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum BillingType {
        FIXED_COST_FOR_TICKETS("FIXED_COST_FOR_TICKETS"),
        SPECIFIC_COST_PER_AGENT("SPECIFIC_COST_PER_AGENT"),
        SPECIFIC_COST_PER_PROFILE("SPECIFIC_COST_PER_PROFILE"),
        FIXED_COST_FOR_AGENTS("FIXED_COST_FOR_AGENTS");

        private String value;

        private BillingType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

