/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.timeTracking;

import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.logger.ZDLogger;
import com.zoho.desk.timeTracking.AutoTrackAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TicketPreference {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isReviewTime", "isAutoPause", "isHideTimeTracking", "isAutoTimer");

    public TicketPreference() {
    }

    public TicketPreference(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public AutoTrackAction getAutoTrackAction() {
        try {
            Map value = (Map)this.data.get("autoTrackAction");
            if (value == null) {
                return null;
            }
            return new AutoTrackAction(new JSONObject(value));
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public void setAutoTrackAction(AutoTrackAction autoTrackAction) {
        this.data.put("autoTrackAction", autoTrackAction);
        this.update.add("autoTrackAction");
    }

    public Boolean getIsReviewTime() {
        return (Boolean)this.data.get("isReviewTime");
    }

    public void setIsReviewTime(Boolean isReviewTime) {
        this.data.put("isReviewTime", isReviewTime);
        this.update.add("isReviewTime");
    }

    public Boolean getIsAutoPause() {
        return (Boolean)this.data.get("isAutoPause");
    }

    public void setIsAutoPause(Boolean isAutoPause) {
        this.data.put("isAutoPause", isAutoPause);
        this.update.add("isAutoPause");
    }

    public Boolean getIsHideTimeTracking() {
        return (Boolean)this.data.get("isHideTimeTracking");
    }

    public void setIsHideTimeTracking(Boolean isHideTimeTracking) {
        this.data.put("isHideTimeTracking", isHideTimeTracking);
        this.update.add("isHideTimeTracking");
    }

    public Boolean getIsAutoTimer() {
        return (Boolean)this.data.get("isAutoTimer");
    }

    public void setIsAutoTimer(Boolean isAutoTimer) {
        this.data.put("isAutoTimer", isAutoTimer);
        this.update.add("isAutoTimer");
    }

    private void setFieldValues(JSONObject ticketPreferenceData) throws JSONException {
        Iterator itr = ticketPreferenceData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = ticketPreferenceData.get(key);
            if (ticketPreferenceData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, ticketPreferenceData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    public String toString() {
        return this.data.toString();
    }
}

