/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.timeTracking;

import com.zoho.desk.init.CommonUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityPreference {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isTasksEnabled", "isEventsEnabled", "canAutoTrackCalls");

    public ActivityPreference() {
    }

    public ActivityPreference(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public Boolean getIsTasksEnabled() {
        return (Boolean)this.data.get("isTasksEnabled");
    }

    public void setIsTasksEnabled(Boolean isTasksEnabled) {
        this.data.put("isTasksEnabled", isTasksEnabled);
        this.update.add("isTasksEnabled");
    }

    public Boolean getIsEventsEnabled() {
        return (Boolean)this.data.get("isEventsEnabled");
    }

    public void setIsEventsEnabled(Boolean isEventsEnabled) {
        this.data.put("isEventsEnabled", isEventsEnabled);
        this.update.add("isEventsEnabled");
    }

    public Boolean getCanAutoTrackCalls() {
        return (Boolean)this.data.get("canAutoTrackCalls");
    }

    public void setCanAutoTrackCalls(Boolean canAutoTrackCalls) {
        this.data.put("canAutoTrackCalls", canAutoTrackCalls);
        this.update.add("canAutoTrackCalls");
    }

    public TrackMode getTrackMode() {
        String responseValue = (String)this.data.get("trackMode");
        TrackMode value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "CONSECUTIVE": {
                value = TrackMode.CONSECUTIVE;
                break;
            }
            case "CONCURRENT": {
                value = TrackMode.CONCURRENT;
            }
        }
        return value;
    }

    public void setTrackMode(TrackMode trackMode) {
        String value = null;
        if (trackMode != null) {
            value = trackMode.getValue();
        }
        this.data.put("trackMode", value);
        this.update.add("trackMode");
    }

    private void setFieldValues(JSONObject activityPreferenceData) throws JSONException {
        Iterator itr = activityPreferenceData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = activityPreferenceData.get(key);
            if (activityPreferenceData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, activityPreferenceData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum TrackMode {
        CONSECUTIVE("CONSECUTIVE"),
        CONCURRENT("CONCURRENT");

        private String value;

        private TrackMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

