/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.ticketCount;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import com.zoho.desk.init.CommonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Scanner;
import org.json.JSONException;
import org.json.JSONObject;

public class TicketCountAPI {
    private String mailId;

    private TicketCountAPI(String mailId) {
        this.mailId = mailId;
    }

    public static TicketCountAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new TicketCountAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public Map<String, Object> getTicketsCount(String customField1, String contactId, String customField2, String customField3, String departmentId, String createdTimeRange, String modifiedTimeRange, String category, String assigneeId) {
        StringBuilder requestURL = new StringBuilder("/api/v1/ticketsCount");
        if (customField1 != null) {
            String customField1Str = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(customField1Str).append("customField1=").append(customField1);
        }
        if (contactId != null) {
            String contactIdStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(contactIdStr).append("contactId=").append(contactId);
        }
        if (customField2 != null) {
            String customField2Str = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(customField2Str).append("customField2=").append(customField2);
        }
        if (customField3 != null) {
            String customField3Str = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(customField3Str).append("customField3=").append(customField3);
        }
        if (departmentId != null) {
            String departmentIdStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(departmentIdStr).append("departmentId=").append(departmentId);
        }
        if (createdTimeRange != null) {
            String createdTimeRangeStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(createdTimeRangeStr).append("createdTimeRange=").append(createdTimeRange);
        }
        if (modifiedTimeRange != null) {
            String modifiedTimeRangeStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(modifiedTimeRangeStr).append("modifiedTimeRange=").append(modifiedTimeRange);
        }
        if (category != null) {
            String categoryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(categoryStr).append("category=").append(category);
        }
        if (assigneeId != null) {
            String assigneeIdStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(assigneeIdStr).append("assigneeId=").append(assigneeId);
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            Map<String, Object> map = CommonUtil.toConvertJSONToMap(data);
            return map;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Map<String, Object> getTicketsCountByField(Field field, String customField1, String contactId, String customField2, String customField3, String departmentId, String createdTimeRange, String modifiedTimeRange, String category, String assigneeId) {
        StringBuilder requestURL = new StringBuilder("/api/v1/ticketsCountByFieldValues");
        if (field != null) {
            String fieldStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(fieldStr).append("field=").append(field.getValue());
        }
        if (customField1 != null) {
            String customField1Str = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(customField1Str).append("customField1=").append(customField1);
        }
        if (contactId != null) {
            String contactIdStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(contactIdStr).append("contactId=").append(contactId);
        }
        if (customField2 != null) {
            String customField2Str = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(customField2Str).append("customField2=").append(customField2);
        }
        if (customField3 != null) {
            String customField3Str = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(customField3Str).append("customField3=").append(customField3);
        }
        if (departmentId != null) {
            String departmentIdStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(departmentIdStr).append("departmentId=").append(departmentId);
        }
        if (createdTimeRange != null) {
            String createdTimeRangeStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(createdTimeRangeStr).append("createdTimeRange=").append(createdTimeRange);
        }
        if (modifiedTimeRange != null) {
            String modifiedTimeRangeStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(modifiedTimeRangeStr).append("modifiedTimeRange=").append(modifiedTimeRange);
        }
        if (category != null) {
            String categoryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(categoryStr).append("category=").append(category);
        }
        if (assigneeId != null) {
            String assigneeIdStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(assigneeIdStr).append("assigneeId=").append(assigneeId);
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            Map<String, Object> map = CommonUtil.toConvertJSONToMap(data);
            return map;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public static enum Field {
        STATUSTYPE("statusType"),
        CHANNEL("channel"),
        PRIORITY("priority"),
        STATUS("status");

        private String value;

        private Field(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

