/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.ticket;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.ticket.GetTicketByDueInMinutesFilter;
import com.zoho.desk.ticket.GetTicketsByContactFilter;
import com.zoho.desk.ticket.GetTicketsByCrmContactTypeFilter;
import com.zoho.desk.ticket.GetTicketsByProductFilter;
import com.zoho.desk.ticket.GetTicketsByStatusFilter;
import com.zoho.desk.ticket.GetTicketsFilter;
import com.zoho.desk.ticket.Ticket;
import com.zoho.desk.ticket.UpdateTicketFilter;
import com.zoho.desk.ticketMetricsResp.TicketMetricsResp;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TicketAPI {
    private String mailId;

    private TicketAPI(String mailId) {
        this.mailId = mailId;
    }

    public static TicketAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new TicketAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public List<Map<String, Object>> getAgentsTicketsCount(List<String> agentIds, String departmentId) {
        StringBuilder requestURL = new StringBuilder("/api/v1/agentsTicketsCount");
        if (agentIds != null) {
            String agentIdsStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            StringBuilder builder = new StringBuilder("agentIds=");
            for (int i = 0; i < agentIds.size(); ++i) {
                builder.append(agentIds.get(i));
                if (i == agentIds.size() - 1) continue;
                builder.append(",");
            }
            requestURL.append(agentIdsStr).append("agentIds=").append(builder.toString());
        }
        if (departmentId != null) {
            String departmentIdStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(departmentIdStr).append("departmentId=").append(departmentId);
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Map<String, Object>> responseMap = new ArrayList<Map<String, Object>>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Map<String, Object> returnData = CommonUtil.toConvertJSONToMap(dataArray.getJSONObject(i));
                    responseMap.add(returnData);
                }
            }
            ArrayList<Map<String, Object>> arrayList = responseMap;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Ticket> getTickets(Integer from, Integer limit, APIConstants.Ticket.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Ticket.Include> includeSet, GetTicketsFilter filter) {
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Ticket.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Ticket> ticketData = new ArrayList<Ticket>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Ticket ticketRef = new Ticket(dataArray.getJSONObject(i));
                    ticketData.add(ticketRef);
                }
            }
            ArrayList<Ticket> arrayList = ticketData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public boolean moveToTrash(List<String> ticketIds) {
        if (ticketIds == null) {
            throw new ZDeskException("ticketIds is mandatory payload key");
        }
        HashMap<String, List<String>> inputData = new HashMap<String, List<String>>();
        inputData.put("ticketIds", ticketIds);
        JSONObject payloadData = new JSONObject(inputData);
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/moveToTrash");
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(payloadData.toString().getBytes("UTF-8")), this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public List<Ticket> getTicketByDueInMinutes(Integer from, Integer limit, EnumSet<APIConstants.Ticket.Include> includeSet, GetTicketByDueInMinutesFilter filter) {
        StringBuilder requestURL = new StringBuilder("/api/v1/ticketsByDueInMinutes");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Ticket.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Ticket> ticketData = new ArrayList<Ticket>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Ticket ticketRef = new Ticket(dataArray.getJSONObject(i));
                    ticketData.add(ticketRef);
                }
            }
            ArrayList<Ticket> arrayList = ticketData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public TicketMetricsResp getTicketsMetrics(String ticketId) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/metrics");
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            TicketMetricsResp ticketMetricsResp = new TicketMetricsResp(new JSONObject(responseData));
            return ticketMetricsResp;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Ticket> getTicketsByProduct(String productId, Integer from, Integer limit, APIConstants.Ticket.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Ticket.Include> includeSet, GetTicketsByProductFilter filter) {
        if (productId == null) {
            throw new ZDeskException("productId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/products/" + productId + "/tickets");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Ticket.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Ticket> ticketData = new ArrayList<Ticket>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Ticket ticketRef = new Ticket(dataArray.getJSONObject(i));
                    ticketData.add(ticketRef);
                }
            }
            ArrayList<Ticket> arrayList = ticketData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Ticket createTicket(Ticket ticket) {
        if (ticket.getContactId() == null) {
            throw new ZDeskException("contactId is mandatory payload key");
        }
        if (ticket.getSubject() == null) {
            throw new ZDeskException("subject is mandatory payload key");
        }
        if (ticket.getDepartmentId() == null) {
            throw new ZDeskException("departmentId is mandatory payload key");
        }
        if (ticket.getStatus() == null) {
            throw new ZDeskException("status is mandatory payload key");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets");
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(ticket.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Ticket ticket2 = new Ticket(new JSONObject(responseData));
            return ticket2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Ticket> getTicketsByCrmContactType(Integer from, Integer limit, EnumSet<APIConstants.Ticket.Include> includeSet, GetTicketsByCrmContactTypeFilter filter) {
        StringBuilder requestURL = new StringBuilder("/api/v1/ticketsByCrmContactType");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Ticket.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Ticket> ticketData = new ArrayList<Ticket>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Ticket ticketRef = new Ticket(dataArray.getJSONObject(i));
                    ticketData.add(ticketRef);
                }
            }
            ArrayList<Ticket> arrayList = ticketData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Ticket> getTicketsByContact(String contactId, Integer from, Integer limit, APIConstants.Ticket.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Ticket.Include> includeSet, GetTicketsByContactFilter filter) {
        if (contactId == null) {
            throw new ZDeskException("contactId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/contacts/" + contactId + "/tickets");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Ticket.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Ticket> ticketData = new ArrayList<Ticket>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Ticket ticketRef = new Ticket(dataArray.getJSONObject(i));
                    ticketData.add(ticketRef);
                }
            }
            ArrayList<Ticket> arrayList = ticketData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public boolean closeTickets(List<String> ids) {
        if (ids == null) {
            throw new ZDeskException("ids is mandatory payload key");
        }
        HashMap<String, List<String>> inputData = new HashMap<String, List<String>>();
        inputData.put("ids", ids);
        JSONObject payloadData = new JSONObject(inputData);
        StringBuilder requestURL = new StringBuilder("/api/v1/closeTickets");
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(payloadData.toString().getBytes("UTF-8")), this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public List<Ticket> getTicketsByStatus(Integer from, Integer limit, EnumSet<APIConstants.Ticket.Include> includeSet, GetTicketsByStatusFilter filter) {
        StringBuilder requestURL = new StringBuilder("/api/v1/ticketsByStatus");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Ticket.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Ticket> ticketData = new ArrayList<Ticket>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Ticket ticketRef = new Ticket(dataArray.getJSONObject(i));
                    ticketData.add(ticketRef);
                }
            }
            ArrayList<Ticket> arrayList = ticketData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Ticket getTicket(String ticketId, EnumSet<APIConstants.Ticket.Include> includeSet) {
        Object value;
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId);
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Ticket.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            value = includeStr.toString();
            requestURL.append(((String)value).substring(0, ((String)value).length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            value = new Ticket(new JSONObject(responseData));
            return value;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Ticket updateTicket(String ticketId, UpdateTicketFilter filter, Ticket ticket) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId);
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(ticket.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Ticket ticket2 = new Ticket(new JSONObject(responseData));
            return ticket2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

