/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.ticket;

import com.zoho.desk.init.CommonUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LastThread {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isDraft", "isForward");

    public LastThread() {
    }

    public LastThread(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public String getChannel() {
        return (String)this.data.get("channel");
    }

    public Boolean getIsDraft() {
        return (Boolean)this.data.get("isDraft");
    }

    public Boolean getIsForward() {
        return (Boolean)this.data.get("isForward");
    }

    public Direction getDirection() {
        String responseValue = (String)this.data.get("direction");
        Direction value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "in": {
                value = Direction.IN;
                break;
            }
            case "out": {
                value = Direction.OUT;
            }
        }
        return value;
    }

    private void setFieldValues(JSONObject lastThreadData) throws JSONException {
        Iterator itr = lastThreadData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = lastThreadData.get(key);
            if (lastThreadData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, lastThreadData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum Direction {
        IN("in"),
        OUT("out");

        private String value;

        private Direction(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

