/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.ticket;

import com.zoho.desk.init.CommonUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelRelatedInfo {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isTopicDeleted");

    public ChannelRelatedInfo() {
    }

    public ChannelRelatedInfo(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public String getTopicId() {
        return (String)this.data.get("topicId");
    }

    public Boolean getIsTopicDeleted() {
        return (Boolean)this.data.get("isTopicDeleted");
    }

    public ForumStatus getForumStatus() {
        String responseValue = (String)this.data.get("forumStatus");
        ForumStatus value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "NOSTATUS": {
                value = ForumStatus.NOSTATUS;
                break;
            }
            case "NEEDMOREINFO": {
                value = ForumStatus.NEEDMOREINFO;
                break;
            }
            case "WORKINGONIT": {
                value = ForumStatus.WORKINGONIT;
                break;
            }
            case "ANSWERED": {
                value = ForumStatus.ANSWERED;
                break;
            }
            case "UNANSWERED": {
                value = ForumStatus.UNANSWERED;
                break;
            }
            case "MAYBELATER": {
                value = ForumStatus.MAYBELATER;
                break;
            }
            case "UNDERREVIEW": {
                value = ForumStatus.UNDERREVIEW;
                break;
            }
            case "IMPLEMENTED": {
                value = ForumStatus.IMPLEMENTED;
                break;
            }
            case "WILLNOTIMPLEMENT": {
                value = ForumStatus.WILLNOTIMPLEMENT;
                break;
            }
            case "NOTAPROBLEM": {
                value = ForumStatus.NOTAPROBLEM;
                break;
            }
            case "TEMPORARYFIX": {
                value = ForumStatus.TEMPORARYFIX;
                break;
            }
            case "ANALYZING": {
                value = ForumStatus.ANALYZING;
                break;
            }
            case "SOLVED": {
                value = ForumStatus.SOLVED;
                break;
            }
            case "UNSOLVED": {
                value = ForumStatus.UNSOLVED;
                break;
            }
            case "MOSTVOTED": {
                value = ForumStatus.MOSTVOTED;
                break;
            }
            case "INPROGRESS": {
                value = ForumStatus.INPROGRESS;
            }
        }
        return value;
    }

    public String getSourceLink() {
        return (String)this.data.get("sourceLink");
    }

    public TopicType getTopicType() {
        String responseValue = (String)this.data.get("topicType");
        TopicType value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "DISCUSSION": {
                value = TopicType.DISCUSSION;
                break;
            }
            case "QUESTION": {
                value = TopicType.QUESTION;
                break;
            }
            case "IDEA": {
                value = TopicType.IDEA;
                break;
            }
            case "ANNOUNCEMENT": {
                value = TopicType.ANNOUNCEMENT;
                break;
            }
            case "PROBLEM": {
                value = TopicType.PROBLEM;
            }
        }
        return value;
    }

    private void setFieldValues(JSONObject channelRelatedInfoData) throws JSONException {
        Iterator itr = channelRelatedInfoData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = channelRelatedInfoData.get(key);
            if (channelRelatedInfoData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, channelRelatedInfoData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum TopicType {
        DISCUSSION("DISCUSSION"),
        QUESTION("QUESTION"),
        IDEA("IDEA"),
        ANNOUNCEMENT("ANNOUNCEMENT"),
        PROBLEM("PROBLEM");

        private String value;

        private TopicType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ForumStatus {
        NOSTATUS("NOSTATUS"),
        NEEDMOREINFO("NEEDMOREINFO"),
        WORKINGONIT("WORKINGONIT"),
        ANSWERED("ANSWERED"),
        UNANSWERED("UNANSWERED"),
        MAYBELATER("MAYBELATER"),
        UNDERREVIEW("UNDERREVIEW"),
        IMPLEMENTED("IMPLEMENTED"),
        WILLNOTIMPLEMENT("WILLNOTIMPLEMENT"),
        NOTAPROBLEM("NOTAPROBLEM"),
        TEMPORARYFIX("TEMPORARYFIX"),
        ANALYZING("ANALYZING"),
        SOLVED("SOLVED"),
        UNSOLVED("UNSOLVED"),
        MOSTVOTED("MOSTVOTED"),
        INPROGRESS("INPROGRESS");

        private String value;

        private ForumStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

