/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.thread;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import com.zoho.desk.thread.Thread;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ThreadAPI {
    private String mailId;

    private ThreadAPI(String mailId) {
        this.mailId = mailId;
    }

    public static ThreadAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new ThreadAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public Thread getThread(String threadId, String ticketId, EnumSet<APIConstants.Thread.Include> includeSet) {
        Object value;
        if (threadId == null) {
            throw new ZDeskException("threadId is mandatory PathParam");
        }
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/threads/" + threadId);
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Thread.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            value = includeStr.toString();
            requestURL.append(((String)value).substring(0, ((String)value).length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            value = new Thread(new JSONObject(responseData));
            return value;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Thread sendEmailReply(String ticketId, List<String> attachmentIds, String to, String fromEmailAddress, String contentType, String content, Boolean isForward) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/sendReply");
        if (to == null) {
            throw new ZDeskException("to is mandatory payload key");
        }
        if (fromEmailAddress == null) {
            throw new ZDeskException("fromEmailAddress is mandatory payload key");
        }
        if (content == null) {
            throw new ZDeskException("content is mandatory payload key");
        }
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        if (attachmentIds != null) {
            inputData.put("attachmentIds", attachmentIds);
        }
        inputData.put("to", to);
        inputData.put("fromEmailAddress", fromEmailAddress);
        if (contentType != null) {
            inputData.put("contentType", contentType);
        }
        inputData.put("content", content);
        if (isForward != null) {
            inputData.put("isForward", isForward);
        }
        inputData.put("channel", "EMAIL");
        JSONObject payloadData = new JSONObject(inputData);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(payloadData.toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Thread thread = new Thread(new JSONObject(responseData));
            return thread;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Thread sendFaceBookReply(String ticketId, String content) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/sendReply");
        if (content == null) {
            throw new ZDeskException("content is mandatory payload key");
        }
        HashMap<String, String> inputData = new HashMap<String, String>();
        inputData.put("content", content);
        inputData.put("channel", "FACEBOOK");
        JSONObject payloadData = new JSONObject(inputData);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(payloadData.toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Thread thread = new Thread(new JSONObject(responseData));
            return thread;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Thread sendTwitterReply(String ticketId, String content) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/sendReply");
        if (content == null) {
            throw new ZDeskException("content is mandatory payload key");
        }
        HashMap<String, String> inputData = new HashMap<String, String>();
        inputData.put("content", content);
        inputData.put("channel", "TWITTER");
        JSONObject payloadData = new JSONObject(inputData);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(payloadData.toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Thread thread = new Thread(new JSONObject(responseData));
            return thread;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Thread sendForumsReply(String ticketId, String content) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/sendReply");
        if (content == null) {
            throw new ZDeskException("content is mandatory payload key");
        }
        HashMap<String, String> inputData = new HashMap<String, String>();
        inputData.put("content", content);
        inputData.put("channel", "FORUMS");
        JSONObject payloadData = new JSONObject(inputData);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(payloadData.toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Thread thread = new Thread(new JSONObject(responseData));
            return thread;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Thread draftEmailReply(String ticketId, List<String> attachmentIds, String to, String fromEmailAddress, String contentType, String content, Boolean isForward) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/draftReply");
        if (fromEmailAddress == null) {
            throw new ZDeskException("fromEmailAddress is mandatory payload key");
        }
        if (content == null) {
            throw new ZDeskException("content is mandatory payload key");
        }
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        if (attachmentIds != null) {
            inputData.put("attachmentIds", attachmentIds);
        }
        if (to != null) {
            inputData.put("to", to);
        }
        inputData.put("fromEmailAddress", fromEmailAddress);
        if (contentType != null) {
            inputData.put("contentType", contentType);
        }
        inputData.put("content", content);
        if (isForward != null) {
            inputData.put("isForward", isForward);
        }
        inputData.put("channel", "EMAIL");
        JSONObject payloadData = new JSONObject(inputData);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(payloadData.toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Thread thread = new Thread(new JSONObject(responseData));
            return thread;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Thread draftFaceBookReply(String ticketId, String content) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/draftReply");
        if (content == null) {
            throw new ZDeskException("content is mandatory payload key");
        }
        HashMap<String, String> inputData = new HashMap<String, String>();
        inputData.put("content", content);
        inputData.put("channel", "FACEBOOK");
        JSONObject payloadData = new JSONObject(inputData);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(payloadData.toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Thread thread = new Thread(new JSONObject(responseData));
            return thread;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Thread draftForumsReply(String ticketId, String content) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/draftReply");
        if (content == null) {
            throw new ZDeskException("content is mandatory payload key");
        }
        HashMap<String, String> inputData = new HashMap<String, String>();
        inputData.put("content", content);
        inputData.put("channel", "FORUMS");
        JSONObject payloadData = new JSONObject(inputData);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(payloadData.toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Thread thread = new Thread(new JSONObject(responseData));
            return thread;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Thread> getThreads(String ticketId, Integer from, Integer limit) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/threads");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Thread> threadData = new ArrayList<Thread>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Thread threadRef = new Thread(dataArray.getJSONObject(i));
                    threadData.add(threadRef);
                }
            }
            ArrayList<Thread> arrayList = threadData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

