/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.thread;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.logger.ZDLogger;
import com.zoho.desk.thread.Actions;
import com.zoho.desk.thread.Attachments;
import com.zoho.desk.thread.Author;
import com.zoho.desk.thread.ChannelRelatedInfo;
import com.zoho.desk.thread.Source;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Thread {
    Map<String, Object> data = new HashMap<String, Object>();
    Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isDescriptionThread", "isContentTruncated", "canReply", "isForward", "hasAttach");

    public Thread() {
    }

    public Thread(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public Boolean getIsDescriptionThread() {
        return (Boolean)this.data.get("isDescriptionThread");
    }

    public String getBcc() {
        return (String)this.data.get("bcc");
    }

    public List<Attachments> getAttachments() {
        try {
            ArrayList<Attachments> result = new ArrayList<Attachments>();
            List value = (List)this.data.get("attachments");
            if (value == null) {
                return null;
            }
            for (Map subProps : value) {
                result.add(new Attachments(new JSONObject(subProps)));
            }
            return result;
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public Boolean getIsContentTruncated() {
        return (Boolean)this.data.get("isContentTruncated");
    }

    public Boolean getCanReply() {
        return (Boolean)this.data.get("canReply");
    }

    public Channel getChannel() {
        String responseValue = (String)this.data.get("channel");
        Channel value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "FEEDBACK_WIDGET": {
                value = Channel.FEEDBACK_WIDGET;
                break;
            }
            case "FACEBOOK": {
                value = Channel.FACEBOOK;
                break;
            }
            case "FORUMS": {
                value = Channel.FORUMS;
                break;
            }
            case "OFFLINE_CHAT": {
                value = Channel.OFFLINE_CHAT;
                break;
            }
            case "TWITTER_DM": {
                value = Channel.TWITTER_DM;
                break;
            }
            case "WEB": {
                value = Channel.WEB;
                break;
            }
            case "PHONE": {
                value = Channel.PHONE;
                break;
            }
            case "CUSTOMERPORTAL": {
                value = Channel.CUSTOMERPORTAL;
                break;
            }
            case "EMAIL": {
                value = Channel.EMAIL;
                break;
            }
            case "ONLINE_CHAT": {
                value = Channel.ONLINE_CHAT;
                break;
            }
            case "TWITTER": {
                value = Channel.TWITTER;
                break;
            }
            case "FEEDBACK": {
                value = Channel.FEEDBACK;
            }
        }
        return value;
    }

    public void setChannel(Channel channel) {
        String value = null;
        if (channel != null) {
            value = channel.getValue();
        }
        this.data.put("channel", value);
        this.update.add("channel");
    }

    public Source getSource() {
        try {
            Map value = (Map)this.data.get("source");
            if (value == null) {
                return null;
            }
            return new Source(new JSONObject(value));
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public String getContent() {
        return (String)this.data.get("content");
    }

    public void setContent(String content) {
        this.data.put("content", content);
        this.update.add("content");
    }

    public String getTwitterProfile() {
        return (String)this.data.get("twitterProfile");
    }

    public ChannelRelatedInfo getChannelRelatedInfo() {
        try {
            Map value = (Map)this.data.get("channelRelatedInfo");
            if (value == null) {
                return null;
            }
            return new ChannelRelatedInfo(new JSONObject(value));
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public String getPlainText() {
        return (String)this.data.get("plainText");
    }

    public Date getCreatedTime() throws ZDeskException {
        try {
            String createdTimeValue = (String)this.data.get("createdTime");
            return createdTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(createdTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public String getContentType() {
        return (String)this.data.get("contentType");
    }

    public void setContentType(String contentType) {
        this.data.put("contentType", contentType);
        this.update.add("contentType");
    }

    public Direction getDirection() {
        String responseValue = (String)this.data.get("direction");
        Direction value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "in": {
                value = Direction.IN;
                break;
            }
            case "out": {
                value = Direction.OUT;
            }
        }
        return value;
    }

    public String getCc() {
        return (String)this.data.get("cc");
    }

    public String getSummary() {
        return (String)this.data.get("summary");
    }

    public Visibility getVisibility() {
        String responseValue = (String)this.data.get("visibility");
        Visibility value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "private": {
                value = Visibility.PRIVATE;
                break;
            }
            case "public": {
                value = Visibility.PUBLIC;
            }
        }
        return value;
    }

    public Author getAuthor() {
        try {
            Map value = (Map)this.data.get("author");
            if (value == null) {
                return null;
            }
            return new Author(new JSONObject(value));
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public String getFullContentURL() {
        return (String)this.data.get("fullContentURL");
    }

    public String getFacebookProfile() {
        return (String)this.data.get("facebookProfile");
    }

    public Boolean getIsForward() {
        return (Boolean)this.data.get("isForward");
    }

    public void setIsForward(Boolean isForward) {
        this.data.put("isForward", isForward);
        this.update.add("isForward");
    }

    public Boolean getHasAttach() {
        return (Boolean)this.data.get("hasAttach");
    }

    public String getResponderId() {
        return (String)this.data.get("responderId");
    }

    public String getReplyTo() {
        return (String)this.data.get("replyTo");
    }

    public String getAttachmentCount() {
        return (String)this.data.get("attachmentCount");
    }

    public String getTo() {
        return (String)this.data.get("to");
    }

    public void setTo(String to) {
        this.data.put("to", to);
        this.update.add("to");
    }

    public String getFromEmailAddress() {
        return (String)this.data.get("fromEmailAddress");
    }

    public void setFromEmailAddress(String fromEmailAddress) {
        this.data.put("fromEmailAddress", fromEmailAddress);
        this.update.add("fromEmailAddress");
    }

    public List<Actions> getActions() {
        try {
            ArrayList<Actions> result = new ArrayList<Actions>();
            List value = (List)this.data.get("actions");
            if (value == null) {
                return null;
            }
            for (Map subProps : value) {
                result.add(new Actions(new JSONObject(subProps)));
            }
            return result;
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public Status getStatus() {
        String responseValue = (String)this.data.get("status");
        Status value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "SUCCESS": {
                value = Status.SUCCESS;
                break;
            }
            case "FAILED": {
                value = Status.FAILED;
                break;
            }
            case "DRAFT": {
                value = Status.DRAFT;
                break;
            }
            case "PENDING": {
                value = Status.PENDING;
            }
        }
        return value;
    }

    private void setFieldValues(JSONObject threadData) throws JSONException {
        Iterator itr = threadData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = threadData.get(key);
            if (threadData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, threadData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum Status {
        SUCCESS("SUCCESS"),
        FAILED("FAILED"),
        DRAFT("DRAFT"),
        PENDING("PENDING");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Visibility {
        PRIVATE("private"),
        PUBLIC("public");

        private String value;

        private Visibility(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Direction {
        IN("in"),
        OUT("out");

        private String value;

        private Direction(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Channel {
        FEEDBACK_WIDGET("FEEDBACK_WIDGET"),
        FACEBOOK("FACEBOOK"),
        FORUMS("FORUMS"),
        OFFLINE_CHAT("OFFLINE_CHAT"),
        TWITTER_DM("TWITTER_DM"),
        WEB("WEB"),
        PHONE("PHONE"),
        CUSTOMERPORTAL("CUSTOMERPORTAL"),
        EMAIL("EMAIL"),
        ONLINE_CHAT("ONLINE_CHAT"),
        TWITTER("TWITTER"),
        FEEDBACK("FEEDBACK");

        private String value;

        private Channel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

