/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.team;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import com.zoho.desk.team.Team;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TeamAPI {
    private String mailId;

    private TeamAPI(String mailId) {
        this.mailId = mailId;
    }

    public static TeamAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new TeamAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public List<Team> listAssociatedTeamsForAgent(String agent_id) {
        if (agent_id == null) {
            throw new ZDeskException("agent_id is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/agents/" + agent_id + "/teams");
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Team> teamData = new ArrayList<Team>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Team teamRef = new Team(dataArray.getJSONObject(i));
                    teamData.add(teamRef);
                }
            }
            ArrayList<Team> arrayList = teamData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Team> getTeamsInDepartment(String department_id) {
        if (department_id == null) {
            throw new ZDeskException("department_id is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/departments/" + department_id + "/teams");
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Team> teamData = new ArrayList<Team>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Team teamRef = new Team(dataArray.getJSONObject(i));
                    teamData.add(teamRef);
                }
            }
            ArrayList<Team> arrayList = teamData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Team createTeam(Team team) {
        if (team.getDepartmentId() == null) {
            throw new ZDeskException("departmentId is mandatory payload key");
        }
        if (team.getName() == null) {
            throw new ZDeskException("name is mandatory payload key");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/teams");
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(team.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Team team2 = new Team(new JSONObject(responseData));
            return team2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public boolean deleteTeam(String team_id, String ticketNewAgent, String ticketNewTeam, String taskNewTeam, String taskNewAgent) {
        if (team_id == null) {
            throw new ZDeskException("team_id is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/teams/" + team_id + "/deleteTeam");
        if (ticketNewAgent == null) {
            throw new ZDeskException("ticketNewAgent is mandatory payload key");
        }
        if (ticketNewTeam == null) {
            throw new ZDeskException("ticketNewTeam is mandatory payload key");
        }
        if (taskNewTeam == null) {
            throw new ZDeskException("taskNewTeam is mandatory payload key");
        }
        if (taskNewAgent == null) {
            throw new ZDeskException("taskNewAgent is mandatory payload key");
        }
        HashMap<String, String> inputData = new HashMap<String, String>();
        inputData.put("ticketNewAgent", ticketNewAgent);
        inputData.put("ticketNewTeam", ticketNewTeam);
        inputData.put("taskNewTeam", taskNewTeam);
        inputData.put("taskNewAgent", taskNewAgent);
        JSONObject payloadData = new JSONObject(inputData);
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(payloadData.toString().getBytes("UTF-8")), this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public List<String> getSubTeamsIds(String team_id) {
        if (team_id == null) {
            throw new ZDeskException("team_id is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/teams/" + team_id + "/associables");
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<String> stringData = new ArrayList<String>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    stringData.add(dataArray.getString(i));
                }
            }
            ArrayList<String> arrayList = stringData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Team getTeam(String team_id) {
        if (team_id == null) {
            throw new ZDeskException("team_id is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/teams/" + team_id);
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Team team = new Team(new JSONObject(responseData));
            return team;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Team updateTeam(String team_id, Team team) {
        if (team_id == null) {
            throw new ZDeskException("team_id is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/teams/" + team_id);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(team.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Team team2 = new Team(new JSONObject(responseData));
            return team2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Team> listTeamsInCurrentAgentAssociatedDept() {
        StringBuilder requestURL = new StringBuilder("/api/v1/teams");
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Team> teamData = new ArrayList<Team>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Team teamRef = new Team(dataArray.getJSONObject(i));
                    teamData.add(teamRef);
                }
            }
            ArrayList<Team> arrayList = teamData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

