/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.team;

import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.logger.ZDLogger;
import com.zoho.desk.team.Teams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Team {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList(new String[0]);

    public Team() {
    }

    public Team(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public List<String> getRolesWithSubordinates() {
        return (List)this.data.get("rolesWithSubordinates");
    }

    public void setRolesWithSubordinates(List<String> rolesWithSubordinates) {
        this.data.put("rolesWithSubordinates", rolesWithSubordinates);
        this.update.add("rolesWithSubordinates");
    }

    public List<Teams> getTeams() {
        try {
            ArrayList<Teams> result = new ArrayList<Teams>();
            List value = (List)this.data.get("teams");
            if (value == null) {
                return null;
            }
            for (Map subProps : value) {
                result.add(new Teams(new JSONObject(subProps)));
            }
            return result;
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public List<String> getRoles() {
        return (List)this.data.get("roles");
    }

    public void setRoles(List<String> roles) {
        this.data.put("roles", roles);
        this.update.add("roles");
    }

    public String getDepartmentId() {
        return (String)this.data.get("departmentId");
    }

    public void setDepartmentId(String departmentId) {
        this.data.put("departmentId", departmentId);
        this.update.add("departmentId");
    }

    public String getName() {
        return (String)this.data.get("name");
    }

    public void setName(String name) {
        this.data.put("name", name);
        this.update.add("name");
    }

    public List<String> getDerivedAgents() {
        return (List)this.data.get("derivedAgents");
    }

    public String getDescription() {
        return (String)this.data.get("description");
    }

    public void setDescription(String description) {
        this.data.put("description", description);
        this.update.add("description");
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public List<String> getSubTeams() {
        return (List)this.data.get("subTeams");
    }

    public void setSubTeams(List<String> subTeams) {
        this.data.put("subTeams", subTeams);
        this.update.add("subTeams");
    }

    public List<String> getAgents() {
        return (List)this.data.get("agents");
    }

    public void setAgents(List<String> agents) {
        this.data.put("agents", agents);
        this.update.add("agents");
    }

    private void setFieldValues(JSONObject teamData) throws JSONException {
        Iterator itr = teamData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = teamData.get(key);
            if (teamData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, teamData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }
}

